DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -8.50886383385411E-12   0.00000000000000E+00  -3.15728012861980E-10   1.62034072318979E-22
      8.82476145376694E-09   8.50903344090512E-09  -7.92652838203059E-19  -2.49110336317880E-01  -2.49110336321291E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41073657025745E-09   0.00000000000000E+00   3.41073657025745E-09
      3.70243398395252E-18  -2.49110336317875E-01  -2.45355022493277E-01   0.00000000000000E+00   1.00220414221630E-11
     -9.83666208456089E-23  -1.19297920525874E-08  -1.19197700111653E-08  -2.90978114574947E-18
      1.17500000000000E-12
      0.00000000000000E+00  -8.51749723915162E-12   0.00000000000000E+00  -2.08520971711115E-11   1.58706850407092E-22
      8.53860979120020E-09   8.51775769402925E-09  -7.94640859345687E-19  -2.48252192543827E-01  -2.48252192547039E-01
      0.00000000000000E+00   0.00000000000000E+00   3.21239898788331E-09   0.00000000000000E+00   3.21239898788331E-09
      3.70460235326934E-18  -2.48252192543821E-01  -2.44556663160722E-01   0.00000000000000E+00   1.35338916758665E-11
     -9.82340799503615E-23  -1.17436905735870E-08  -1.17301566819112E-08  -2.90996149392366E-18
      2.08625000000000E-12
      0.00000000000000E+00  -8.52760016024444E-12   0.00000000000000E+00  -6.84222481839908E-13   1.53837720077111E-22
      8.52823904810728E-09   8.52755482562559E-09  -7.97023785080255E-19  -2.47244517435914E-01  -2.47244517438824E-01
      0.00000000000000E+00   0.00000000000000E+00   2.90984813471982E-09   0.00000000000000E+00   2.90984813471982E-09
      3.70725395238211E-18  -2.47244517435915E-01  -2.43641133222691E-01   0.00000000000000E+00   1.54907891176464E-11
     -9.83186941802965E-23  -1.14528937494616E-08  -1.14374029603441E-08  -2.91023016730186E-18
      3.31643750000000E-12
      0.00000000000000E+00  -8.53926444186980E-12   0.00000000000000E+00   3.44736241649680E-13   1.46836526207645E-22
      8.53891163904351E-09   8.53925637528530E-09  -7.99785651219556E-19  -2.46075878863374E-01  -2.46075878865894E-01
      0.00000000000000E+00   0.00000000000000E+00   2.51986710761306E-09   0.00000000000000E+00   2.51986710761306E-09
      3.71035386139956E-18  -2.46075878863378E-01  -2.42591677183212E-01   0.00000000000000E+00   1.47291381886980E-11
     -9.81473421070003E-23  -1.10738526210869E-08  -1.10591234828983E-08  -2.91056821018000E-18
      4.97719062500000E-12
      0.00000000000000E+00  -8.55221454981606E-12   0.00000000000000E+00   3.38885640364975E-13   1.38600474753442E-22
      8.55193645526562E-09   8.55227534090613E-09  -8.02852569735720E-19  -2.44775766755822E-01  -2.44775766757900E-01
      0.00000000000000E+00   0.00000000000000E+00   2.07744424576856E-09   0.00000000000000E+00   2.07744424576856E-09
      3.71380398342273E-18  -2.44775766755825E-01  -2.41426854953946E-01   0.00000000000000E+00   1.23675264574129E-11
     -9.82048346809370E-23  -1.06420871131321E-08  -1.06297195866748E-08  -2.91095141368701E-18
      7.21920734375000E-12
      0.00000000000000E+00  -8.56599126039719E-12   0.00000000000000E+00   3.02469316345112E-13   1.31439551962832E-22
      8.56571858724713E-09   8.56602105656361E-09  -8.06082300792608E-19  -2.43404171690049E-01  -2.43404171691670E-01
      0.00000000000000E+00   0.00000000000000E+00   1.62093961326080E-09   0.00000000000000E+00   1.62093961326080E-09
      3.71743815713574E-18  -2.43404171690068E-01  -2.40194760917000E-01   0.00000000000000E+00   9.44504543274241E-12
     -9.66682146580058E-23  -1.01964057152566E-08  -1.01869606698239E-08  -2.91135585634314E-18
      1.02459299140625E-11
      0.00000000000000E+00  -8.57949243676670E-12   0.00000000000000E+00   2.79267711787764E-13   1.24256299420283E-22
      8.57934008137833E-09   8.57961934909024E-09  -8.09269512905591E-19  -2.42048458961143E-01  -2.42048458962329E-01
      0.00000000000000E+00   0.00000000000000E+00   1.18680729869997E-09   0.00000000000000E+00   1.18680729869997E-09
      3.72103029357333E-18  -2.42048458961096E-01  -2.38971550820402E-01   0.00000000000000E+00   6.62890474481492E-12
     -9.67233517698600E-23  -9.77305555253482E-09  -9.76642664779010E-09  -2.91176078066774E-18
      1.43320053839844E-11
      0.00000000000000E+00  -8.59189147628971E-12   0.00000000000000E+00   2.65329459516215E-13   1.18016714640806E-22
      8.59177477230779E-09   8.59204010176743E-09  -8.12176075239739E-19  -2.40810670894261E-01  -2.40810670895068E-01
      0.00000000000000E+00   0.00000000000000E+00   8.06936964162364E-10   0.00000000000000E+00   8.06936964162364E-10
      3.72432749890837E-18  -2.40810670894334E-01  -2.37849541633377E-01   0.00000000000000E+00   4.25308227128497E-12
     -9.74278996499212E-23  -9.40323014820035E-09  -9.39897706592916E-09  -2.91215142366863E-18
      1.98482072683789E-11
      0.00000000000000E+00  -8.60217808685695E-12   0.00000000000000E+00   2.45069543774235E-13   1.13080761326125E-22
      8.60209181669956E-09   8.60233688624345E-09  -8.14587191411500E-19  -2.39783527978212E-01  -2.39783527978717E-01
      0.00000000000000E+00   0.00000000000000E+00   5.04434009078432E-10   0.00000000000000E+00   5.04434009078432E-10
      3.72711005873980E-18  -2.39783527978236E-01  -2.36914466577350E-01   0.00000000000000E+00   2.45981650258738E-12
     -9.80846461194224E-23  -9.10923071182447E-09  -9.10677089532198E-09  -2.91252286732830E-18
      2.72950798123115E-11
      0.00000000000000E+00  -8.60980120004518E-12   0.00000000000000E+00   2.02006273681500E-13   1.09683564070292E-22
      8.60974219631578E-09   8.60994420258957E-09  -8.16377478868047E-19  -2.39021762689241E-01  -2.39021762689529E-01
      0.00000000000000E+00   0.00000000000000E+00   2.88866339254145E-10   0.00000000000000E+00   2.88866339254145E-10
      3.72926120955046E-18  -2.39021762689118E-01  -2.36218216171754E-01   0.00000000000000E+00   1.26598731773571E-12
     -9.81500548514867E-23  -8.90007652916163E-09  -8.89881054184399E-09  -2.91288373068241E-18
      3.73483577466206E-11
      0.00000000000000E+00  -8.61476081585439E-12   0.00000000000000E+00   1.36351688115405E-13   1.07632319188128E-22
      8.61474884425923E-09   8.61488519594745E-09  -8.17553961130650E-19  -2.38523150871504E-01  -2.38523150871659E-01
      0.00000000000000E+00   0.00000000000000E+00   1.54238491925514E-10   0.00000000000000E+00   1.54238491925514E-10
      3.73081181197795E-18  -2.38523150870799E-01  -2.35760448119048E-01   0.00000000000000E+00   5.85468145205154E-13
     -9.78893464640443E-23  -8.76970915601793E-09  -8.76912368787282E-09  -2.91325785084730E-18
      5.09202829579378E-11
      0.00000000000000E+00  -8.61769984744503E-12   0.00000000000000E+00   7.01042090156282E-14   1.06744642611273E-22
      8.61765974739197E-09   8.61772985160109E-09  -8.18244318772373E-19  -2.38233160520155E-01  -2.38233160520237E-01
      0.00000000000000E+00   0.00000000000000E+00   8.21830752419935E-11   0.00000000000000E+00   8.21830752419935E-11
      3.73192719452877E-18  -2.38233160519106E-01  -2.35492245271953E-01   0.00000000000000E+00   2.62279690160595E-13
     -9.81121968079289E-23  -8.70017520653313E-09  -8.69991292684306E-09  -2.91368287575640E-18
      6.92423819932160E-11
      0.00000000000000E+00  -8.61926120797756E-12   0.00000000000000E+00   2.62344447567356E-14   1.06536684140688E-22
      8.61926913704367E-09   8.61929537148854E-09  -8.18631827550496E-19  -2.38072713938404E-01  -2.38072713938454E-01
      0.00000000000000E+00   0.00000000000000E+00   4.97276532088703E-11   0.00000000000000E+00   4.97276532088703E-11
      3.73283830951566E-18  -2.38072713937722E-01  -2.35341518288364E-01   0.00000000000000E+00   1.34281218712451E-13
     -9.81952365906759E-23  -8.66915730591598E-09  -8.66902302469737E-09  -2.91420648196516E-18
      8.92423819932160E-11
      0.00000000000000E+00  -8.62017965534963E-12   0.00000000000000E+00   5.18415526643562E-15   1.06758180807321E-22
      8.62015509264268E-09   8.62016027679805E-09  -8.18846925831215E-19  -2.37984288749501E-01  -2.37984288749539E-01
      0.00000000000000E+00   0.00000000000000E+00   3.82198615872232E-11   0.00000000000000E+00   3.82198615872232E-11
      3.73360270674740E-18  -2.37984288749116E-01  -2.35256440021798E-01   0.00000000000000E+00   9.60204822388585E-14
     -9.83528178692494E-23  -8.65847615886751E-09  -8.65838013838537E-09  -2.91475578091619E-18
      1.09242381993216E-10
      0.00000000000000E+00  -8.62073072377288E-12   0.00000000000000E+00   1.78523193454538E-15   1.07038127805481E-22
      8.62076107356230E-09   8.62076285879434E-09  -8.18992003534221E-19  -2.37923746280782E-01  -2.37923746280816E-01
      0.00000000000000E+00   0.00000000000000E+00   3.41865939891636E-11   0.00000000000000E+00   3.41865939891636E-11
      3.73428643862719E-18  -2.37923746280741E-01  -2.35196977462707E-01   0.00000000000000E+00   7.98249199756052E-14
     -9.81016206129875E-23  -8.65502927770335E-09  -8.65494945278347E-09  -2.91529443509297E-18
      1.29242381993216E-10
      0.00000000000000E+00  -8.62128179219612E-12   0.00000000000000E+00   1.90452888109537E-15   1.07548142493137E-22
      8.62127228657543E-09   8.62127419110442E-09  -8.19110586083028E-19  -2.37872644271934E-01  -2.37872644271967E-01
      0.00000000000000E+00   0.00000000000000E+00   3.25138002151602E-11   0.00000000000000E+00   3.25138002151602E-11
      3.73493671463149E-18  -2.37872644270179E-01  -2.35146241434967E-01   0.00000000000000E+00   7.25634441475631E-14
     -9.81402397646456E-23  -8.65386055476364E-09  -8.65378799131959E-09  -2.91582612854846E-18
      1.49242381993216E-10
      0.00000000000000E+00  -8.62174101588216E-12   0.00000000000000E+00   1.37655822943613E-15   1.07791080746725E-22
      8.62174711542096E-09   8.62174849197930E-09  -8.19216653886377E-19  -2.37825169789744E-01  -2.37825169789776E-01
      0.00000000000000E+00   0.00000000000000E+00   3.16013677092662E-11   0.00000000000000E+00   3.16013677092662E-11
      3.73556874198568E-18  -2.37825169788917E-01  -2.35098904811257E-01   0.00000000000000E+00   6.99271375976551E-14
     -9.81030084797681E-23  -8.65341978682618E-09  -8.65334985968868E-09  -2.91635208809930E-18
      1.69242381993216E-10
      0.00000000000000E+00  -8.62220023956820E-12   0.00000000000000E+00   1.18200345758301E-15   1.08240825286780E-22
      8.62220417935322E-09   8.62220536135679E-09  -8.19314899168584E-19  -2.37779467679831E-01  -2.37779467679862E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09463247407865E-11   0.00000000000000E+00   3.09463247407865E-11
      3.73618766848049E-18  -2.37779467681473E-01  -2.35053265056246E-01   0.00000000000000E+00   6.82756248065344E-14
     -9.79095882087909E-23  -8.65321996172219E-09  -8.65315168609748E-09  -2.91687276931191E-18
      1.89242381993216E-10
      0.00000000000000E+00  -8.62265946325423E-12   0.00000000000000E+00   1.25931674606586E-15   1.08596140315134E-22
      8.62264964477352E-09   8.62265090409037E-09  -8.19407078468261E-19  -2.37734924076414E-01  -2.37734924076445E-01
      0.00000000000000E+00   0.00000000000000E+00   3.03895467664995E-11   0.00000000000000E+00   3.03895467664995E-11
      3.73679545941582E-18  -2.37734924082011E-01  -2.35008756501421E-01   0.00000000000000E+00   6.68286250219441E-14
     -9.80922697587920E-23  -8.65310727948178E-09  -8.65304045085686E-09  -2.91738838094756E-18
      2.09242381993216E-10
      0.00000000000000E+00  -8.62311868694027E-12   0.00000000000000E+00   1.06776189000890E-15   1.08896990193852E-22
      8.62308575636058E-09   8.62308682412258E-09  -8.19494006911828E-19  -2.37691315800268E-01  -2.37691315800297E-01
      0.00000000000000E+00   0.00000000000000E+00   2.98798743206830E-11   0.00000000000000E+00   2.98798743206830E-11
      3.73739305690223E-18  -2.37691315808834E-01  -2.34965171378124E-01   0.00000000000000E+00   6.58589557167051E-14
     -9.80998744297921E-23  -8.65303255739897E-09  -8.65296669844335E-09  -2.91789904999041E-18
      2.29242381993216E-10
      0.00000000000000E+00  -8.62357791062631E-12   0.00000000000000E+00   9.46075011028998E-16   1.09219546714220E-22
      8.62351348165755E-09   8.62351442773267E-09  -8.19576180991462E-19  -2.37648545645498E-01  -2.37648545645527E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93999161044788E-11   0.00000000000000E+00   2.93999161044788E-11
      3.73798105522433E-18  -2.37648545655830E-01  -2.34922417655314E-01   0.00000000000000E+00   6.49331472883502E-14
     -9.81014771486817E-23  -8.65297927698429E-09  -8.65291434383710E-09  -2.91840487423286E-18
      2.49242381993216E-10
      0.00000000000000E+00  -8.62394528957514E-12   0.00000000000000E+00   1.02337839257670E-15   1.09545157144052E-22
      8.62393338767498E-09   8.62393441105349E-09  -8.19653980158653E-19  -2.37606557389651E-01  -2.37606557389680E-01
      0.00000000000000E+00   0.00000000000000E+00   2.89431712885712E-11   0.00000000000000E+00   2.89431712885712E-11
      3.73855991865009E-18  -2.37606557401196E-01  -2.34880440980915E-01   0.00000000000000E+00   6.38895960568104E-14
     -9.80843198370079E-23  -8.65294147193803E-09  -8.65287758234208E-09  -2.91890593849144E-18
      2.69242381993216E-10
      0.00000000000000E+00  -8.62440451326118E-12   0.00000000000000E+00   9.22980915542501E-16   1.09868649002265E-22
      8.62434588713099E-09   8.62434681011202E-09  -8.19727730264833E-19  -2.37565309630799E-01  -2.37565309630827E-01
      0.00000000000000E+00   0.00000000000000E+00   2.85066094552203E-11   0.00000000000000E+00   2.85066094552203E-11
      3.73913005083920E-18  -2.37565309640829E-01  -2.34839200775542E-01   0.00000000000000E+00   6.30882103303467E-14
     -9.80818772252094E-23  -8.65291650777743E-09  -8.65285341956720E-09  -2.91940232057437E-18
      2.89242381993216E-10
      0.00000000000000E+00  -8.62477189221001E-12   0.00000000000000E+00   9.85228731215223E-16   1.10188550273957E-22
      8.62475133242229E-09   8.62475231765113E-09  -8.19797724690358E-19  -2.37524767342281E-01  -2.37524767342309E-01
      0.00000000000000E+00   0.00000000000000E+00   2.80883575432984E-11   0.00000000000000E+00   2.80883575432984E-11
      3.73969181799007E-18  -2.37524767344987E-01  -2.34798662488643E-01   0.00000000000000E+00   6.21802470281745E-14
     -9.80715992005717E-23  -8.65290285544131E-09  -8.65284067519438E-09  -2.91989409329971E-18
      3.09242381993216E-10
      0.00000000000000E+00  -8.62513927115884E-12   0.00000000000000E+00   9.07685117920476E-16   1.10504662452311E-22
      8.62515003706258E-09   8.62515094474781E-09  -8.19864232820823E-19  -2.37484898958995E-01  -2.37484898959022E-01
      0.00000000000000E+00   0.00000000000000E+00   2.76870181256403E-11   0.00000000000000E+00   2.76870181256403E-11
      3.74024555835258E-18  -2.37484898946476E-01  -2.34758794894445E-01   0.00000000000000E+00   6.14607044334184E-14
     -9.80667263295991E-23  -8.65289942357783E-09  -8.65283796287350E-09  -2.92038132553176E-18
      3.29242381993216E-10
      0.00000000000000E+00  -8.62559849484488E-12   0.00000000000000E+00   9.50274836448956E-16   1.10817099075480E-22
      8.62554229399793E-09   8.62554324427288E-09  -8.19927503176661E-19  -2.37445675445024E-01  -2.37445675445051E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73013771067126E-11   0.00000000000000E+00   2.73013771067126E-11
      3.74079158589471E-18  -2.37445675409784E-01  -2.34719569247717E-01   0.00000000000000E+00   6.06647858300065E-14
     -9.80613550917891E-23  -8.65290528616540E-09  -8.65284462137967E-09  -2.92086408271805E-18
      3.49242381993216E-10
      0.00000000000000E+00  -8.62596587379370E-12   0.00000000000000E+00   8.90317375431522E-16   1.11125910777598E-22
      8.62592836995138E-09   8.62592926026886E-09  -8.19987765918622E-19  -2.37407069790015E-01  -2.37407069790042E-01
      0.00000000000000E+00   0.00000000000000E+00   2.69303685147782E-11   0.00000000000000E+00   2.69303685147782E-11
      3.74133019326501E-18  -2.37407069724980E-01  -2.34680958790276E-01   0.00000000000000E+00   6.00099690466245E-14
     -9.80563335117861E-23  -8.65291963875260E-09  -8.65285962878365E-09  -2.92134242734639E-18
      3.69242381993216E-10
      0.00000000000000E+00  -8.62633325274254E-12   0.00000000000000E+00   9.18030681391379E-16   1.11431231344782E-22
      8.62630851866337E-09   8.62630943669416E-09  -8.20045234025026E-19  -2.37369056848490E-01  -2.37369056848517E-01
      0.00000000000000E+00   0.00000000000000E+00   2.65730006800106E-11   0.00000000000000E+00   2.65730006800106E-11
      3.74186165327861E-18  -2.37369056752990E-01  -2.34642938615589E-01   0.00000000000000E+00   5.93024134629989E-14
     -9.80513380412668E-23  -8.65294173978752E-09  -8.65288243737416E-09  -2.92181641925358E-18
      3.89242381993216E-10
      0.00000000000000E+00  -8.62670063169137E-12   0.00000000000000E+00   8.71278742464277E-16   1.11733177048098E-22
      8.62668297047426E-09   8.62668384175311E-09  -8.20100104932765E-19  -2.37331613109416E-01  -2.37331613109442E-01
      0.00000000000000E+00   0.00000000000000E+00   2.62283799591132E-11   0.00000000000000E+00   2.62283799591132E-11
      3.74238622087779E-18  -2.37331612992712E-01  -2.34605485431482E-01   0.00000000000000E+00   5.87002357045689E-14
     -9.80463966386477E-23  -8.65297092194779E-09  -8.65291222171219E-09  -2.92228611594503E-18
      4.09242381993216E-10
      0.00000000000000E+00  -8.62706801064019E-12   0.00000000000000E+00   8.88210345712470E-16   1.12031841815363E-22
      8.62705194540349E-09   8.62705283361395E-09  -8.20152561409838E-19  -2.37294716626463E-01  -2.37294716626489E-01
      0.00000000000000E+00   0.00000000000000E+00   2.58956672329178E-11   0.00000000000000E+00   2.58956672329178E-11
      3.74290413422245E-18  -2.37294716514700E-01  -2.34568577503607E-01   0.00000000000000E+00   5.80624896531382E-14
     -9.80414618345847E-23  -8.65300656333643E-09  -8.65294850084688E-09  -2.92275157281261E-18
      4.29242381993216E-10
      0.00000000000000E+00  -8.62743538958903E-12   0.00000000000000E+00   8.51364456768631E-16   1.12327338703642E-22
      8.62741564484344E-09   8.62741649620801E-09  -8.20202772878872E-19  -2.37258346849036E-01  -2.37258346849062E-01
      0.00000000000000E+00   0.00000000000000E+00   2.55741016445825E-11   0.00000000000000E+00   2.55741016445825E-11
      3.74341561625534E-18  -2.37258346789394E-01  -2.34532194478624E-01   0.00000000000000E+00   5.75034890412714E-14
     -9.80365882001016E-23  -8.65304810134159E-09  -8.65299059785265E-09  -2.92321284337647E-18
      4.49242381993216E-10
      0.00000000000000E+00  -8.62780276853786E-12   0.00000000000000E+00   8.60569453468198E-16   1.12619751354396E-22
      8.62777426216857E-09   8.62777512273814E-09  -8.20250896174232E-19  -2.37222484568169E-01  -2.37222484568194E-01
      0.00000000000000E+00   0.00000000000000E+00   2.52629676130126E-11   0.00000000000000E+00   2.52629676130126E-11
      3.74392087560760E-18  -2.37222484628598E-01  -2.34496317332901E-01   0.00000000000000E+00   5.69212389320179E-14
     -9.80317473199274E-23  -8.65309501158991E-09  -8.65303809035108E-09  -2.92366997943337E-18
      4.69242381993216E-10
      0.00000000000000E+00  -8.62817014748668E-12   0.00000000000000E+00   8.31177519122975E-16   1.12909169843800E-22
      8.62812797624352E-09   8.62812880742115E-09  -8.20297076650535E-19  -2.37187111778558E-01  -2.37187111778583E-01
      0.00000000000000E+00   0.00000000000000E+00   2.49616140387348E-11   0.00000000000000E+00   2.49616140387348E-11
      3.74442010788838E-18  -2.37187112041766E-01  -2.34460928224636E-01   0.00000000000000E+00   5.63979292656543E-14
     -9.80269486638184E-23  -8.65314681938913E-09  -8.65309042145996E-09  -2.92412303123784E-18
      4.89242381993216E-10
      0.00000000000000E+00  -8.62844568169831E-12   0.00000000000000E+00   8.34910085418743E-16   1.13195673416809E-22
      8.62847696173077E-09   8.62847779664097E-09  -8.20341448839967E-19  -2.37152211636480E-01  -2.37152211636505E-01
      0.00000000000000E+00   0.00000000000000E+00   2.46694271135100E-11   0.00000000000000E+00   2.46694271135100E-11
      3.74491349643065E-18  -2.37152212179587E-01  -2.34426010442905E-01   0.00000000000000E+00   5.58601828117703E-14
     -9.80221895573054E-23  -8.65320308393725E-09  -8.65314722375454E-09  -2.92457204759068E-18
      5.09242381993216E-10
      0.00000000000000E+00  -8.62881306064714E-12   0.00000000000000E+00   8.11166675100728E-16   1.13479336886144E-22
      8.62882138331418E-09   8.62882219448097E-09  -8.20384137387453E-19  -2.37117768345048E-01  -2.37117768345072E-01
      0.00000000000000E+00   0.00000000000000E+00   2.43858461312328E-11   0.00000000000000E+00   2.43858461312328E-11
      3.74540121335327E-18  -2.37117769206389E-01  -2.34391548276774E-01   0.00000000000000E+00   5.53666940644921E-14
     -9.80174659445610E-23  -8.65326340730603E-09  -8.65320804061207E-09  -2.92501707596582E-18
      5.29242381993216E-10
      0.00000000000000E+00  -8.62918043959597E-12   0.00000000000000E+00   8.11110492518513E-16   1.13760232027441E-22
      8.62916140629410E-09   8.62916221740471E-09  -8.20425257616935E-19  -2.37083767122703E-01  -2.37083767122727E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41103414418280E-11   0.00000000000000E+00   2.41103414418280E-11
      3.74588342018211E-18  -2.37083768254314E-01  -2.34357526973197E-01   0.00000000000000E+00   5.48650696861042E-14
     -9.80127804076909E-23  -8.65332742391618E-09  -8.65327255884659E-09  -2.92545816256517E-18
      5.49242381993216E-10
      0.00000000000000E+00  -8.62954781854480E-12   0.00000000000000E+00   7.91691796818837E-16   1.14038425067191E-22
      8.62949718588428E-09   8.62949797757619E-09  -8.20464916356634E-19  -2.37050194091962E-01  -2.37050194091986E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38424296779235E-11   0.00000000000000E+00   2.38424296779235E-11
      3.74636026877567E-18  -2.37050195300514E-01  -2.34323932612690E-01   0.00000000000000E+00   5.43968646992462E-14
     -9.80081289778573E-23  -8.65339480411876E-09  -8.65334040725416E-09  -2.92589535241903E-18
      5.69242381993216E-10
      0.00000000000000E+00  -8.62982335275642E-12   0.00000000000000E+00   7.89060727356129E-16   1.14313979249306E-22
      8.62982887442076E-09   8.62982966348161E-09  -8.20503212459545E-19  -2.37017036240818E-01  -2.37017036240841E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35816568654625E-11   0.00000000000000E+00   2.35816568654625E-11
      3.74683190191298E-18  -2.37017037134438E-01  -2.34290752079757E-01   0.00000000000000E+00   5.39250037460688E-14
     -9.80035128810355E-23  -8.65346524535067E-09  -8.65341132034703E-09  -2.92632868945343E-18
      5.89242381993216E-10
      0.00000000000000E+00  -8.63019073170525E-12   0.00000000000000E+00   7.72949417241168E-16   1.14586954101547E-22
      8.63015660846517E-09   8.63015738141470E-09  -8.20540237538971E-19  -2.36984281311953E-01  -2.36984281311977E-01
      0.00000000000000E+00   0.00000000000000E+00   2.33276131726712E-11   0.00000000000000E+00   2.33276131726712E-11
      3.74729845417643E-18  -2.36984281275090E-01  -2.34257972979481E-01   0.00000000000000E+00   5.34785152694860E-14
     -9.79989313294433E-23  -8.65353847310251E-09  -8.65348499458734E-09  -2.92675821663746E-18
      6.09242381993216E-10
      0.00000000000000E+00  -8.63046626591687E-12   0.00000000000000E+00   7.68545909843221E-16   1.14857405371699E-22
      8.63048050616356E-09   8.63048127470959E-09  -8.20576076495595E-19  -2.36951917735564E-01  -2.36951917735587E-01
      0.00000000000000E+00   0.00000000000000E+00   2.30799228295242E-11   0.00000000000000E+00   2.30799228295242E-11
      3.74776005263302E-18  -2.36951915966210E-01  -2.34225583636802E-01   0.00000000000000E+00   5.30313663293407E-14
     -9.79943836826058E-23  -8.65361422890529E-09  -8.65356119753906E-09  -2.92718397613743E-18
      6.29242381993216E-10
      0.00000000000000E+00  -8.63083364486570E-12   0.00000000000000E+00   7.54817728798605E-16   1.15125385819216E-22
      8.63080064723809E-09   8.63080140205594E-09  -8.20610808230599E-19  -2.36919934494224E-01  -2.36919934494247E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28382593525790E-11   0.00000000000000E+00   2.28382593525790E-11
      3.74821681782007E-18  -2.36919930146939E-01  -2.34193573068608E-01   0.00000000000000E+00   5.26033409178483E-14
     -9.79898699094652E-23  -8.65369226474941E-09  -8.65363966140859E-09  -2.92760600958947E-18
      6.49242381993216E-10
      0.00000000000000E+00  -8.63110917907733E-12   0.00000000000000E+00   7.48987394131323E-16   1.15390944143872E-22
      8.63111706767970E-09   8.63111781666721E-09  -8.20644506159542E-19  -2.36888321037904E-01  -2.36888321037927E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26023360288422E-11   0.00000000000000E+00   2.26023360288422E-11
      3.74866886454065E-18  -2.36888313505636E-01  -2.34161931042299E-01   0.00000000000000E+00   5.21762063185056E-14
     -9.79853893316349E-23  -8.65377232890228E-09  -8.65372015269606E-09  -2.92802435838111E-18
      6.69242381993216E-10
      0.00000000000000E+00  -8.63147655802616E-12   0.00000000000000E+00   7.36666681871904E-16   1.15654125998578E-22
      8.63142974224483E-09   8.63143047891163E-09  -8.20677238847040E-19  -2.36857067154669E-01  -2.36857067154692E-01
      0.00000000000000E+00   0.00000000000000E+00   2.23719157457488E-11   0.00000000000000E+00   2.23719157457488E-11
      3.74911630285556E-18  -2.36857056509231E-01  -2.34130648107491E-01   0.00000000000000E+00   5.17628828810768E-14
     -9.79809417716859E-23  -8.65385415754007E-09  -8.65380239465729E-09  -2.92843906400852E-18
      6.89242381993216E-10
      0.00000000000000E+00  -8.63175209223778E-12   0.00000000000000E+00   7.29361320327400E-16   1.15914973290708E-22
      8.63173859354999E-09   8.63173932291142E-09  -8.20709070375511E-19  -2.36826162930890E-01  -2.36826162930912E-01
      0.00000000000000E+00   0.00000000000000E+00   2.21467922356618E-11   0.00000000000000E+00   2.21467922356618E-11
      3.74955923870028E-18  -2.36826150488619E-01  -2.34099715684497E-01   0.00000000000000E+00   5.13506214791667E-14
     -9.79765269087060E-23  -8.65393746576846E-09  -8.65388611514708E-09  -2.92885016832476E-18
      7.09242381993216E-10
      0.00000000000000E+00  -8.63202762644940E-12   0.00000000000000E+00   7.17563885176977E-16   1.16173525214637E-22
      8.63204350597469E-09   8.63204422353869E-09  -8.20740060669380E-19  -2.36795598739281E-01  -2.36795598739303E-01
      0.00000000000000E+00   0.00000000000000E+00   2.19267806728773E-11   0.00000000000000E+00   2.19267806728773E-11
      3.74999777431373E-18  -2.36795587652569E-01  -2.34069126076756E-01   0.00000000000000E+00   5.09474736181493E-14
     -9.79721445265800E-23  -8.65402195168510E-09  -8.65397100421158E-09  -2.92925771364435E-18
      7.29242381993216E-10
      0.00000000000000E+00  -8.63239500539823E-12   0.00000000000000E+00   7.08871106469392E-16   1.16429818625533E-22
      8.63234438182878E-09   8.63234509070000E-09  -8.20770265412230E-19  -2.36765365389767E-01  -2.36765365389789E-01
      0.00000000000000E+00   0.00000000000000E+00   2.17116760080013E-11   0.00000000000000E+00   2.17116760080013E-11
      3.75043200783389E-18  -2.36765361056041E-01  -2.34038872434608E-01   0.00000000000000E+00   5.05450447990835E-14
     -9.79677945416920E-23  -8.65410731175270E-09  -8.65405676670799E-09  -2.92966174242166E-18
      7.49242381993216E-10
      0.00000000000000E+00  -8.63267053960985E-12   0.00000000000000E+00   6.97568773009293E-16   1.16683889894122E-22
      8.63264122432059E-09   8.63264192188948E-09  -8.20799735695463E-19  -2.36735454410068E-01  -2.36735454410089E-01
      0.00000000000000E+00   0.00000000000000E+00   2.15012128884395E-11   0.00000000000000E+00   2.15012128884395E-11
      3.75086203209166E-18  -2.36735464389078E-01  -2.34008948530590E-01   0.00000000000000E+00   5.01487935676673E-14
     -9.79634767601742E-23  -8.65419328357140E-09  -8.65414313477793E-09  -2.93006229639620E-18
      7.69242381993216E-10
      0.00000000000000E+00  -8.63294607382148E-12   0.00000000000000E+00   6.88852508080328E-16   1.16935776681303E-22
      8.63293426315873E-09   8.63293495201136E-09  -8.20828517187492E-19  -2.36705858531255E-01  -2.36705858531277E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12950025064117E-11   0.00000000000000E+00   2.12950025064117E-11
      3.75128793214179E-18  -2.36705891567181E-01  -2.33979348330165E-01   0.00000000000000E+00   4.97549179743104E-14
     -9.79591910342554E-23  -8.65427970943565E-09  -8.65422995451777E-09  -2.93045941495430E-18
      7.89242381993216E-10
      0.00000000000000E+00  -8.63322160803310E-12   0.00000000000000E+00   6.80115284414639E-16   1.17185520800225E-22
      8.63322409092128E-09   8.63322477103668E-09  -8.20856649087559E-19  -2.36676572280968E-01  -2.36676572280989E-01
      0.00000000000000E+00   0.00000000000000E+00   2.10924858762390E-11   0.00000000000000E+00   2.10924858762390E-11
      3.75170978185932E-18  -2.36676636020534E-01  -2.33950065252639E-01   0.00000000000000E+00   4.93690434920874E-14
     -9.79549368606066E-23  -8.65436662595632E-09  -8.65431725691293E-09  -2.93085313277175E-18
      8.09242381993216E-10
      0.00000000000000E+00  -8.63349714224472E-12   0.00000000000000E+00   6.75155366449298E-16   1.17433170536159E-22
      8.63351179509915E-09   8.63351247025463E-09  -8.20884162940490E-19  -2.36647592631977E-01  -2.36647592631998E-01
      0.00000000000000E+00   0.00000000000000E+00   2.08928990494486E-11   0.00000000000000E+00   2.08928990494486E-11
      3.75212763984030E-18  -2.36647689762647E-01  -2.33921091209214E-01   0.00000000000000E+00   4.89928740406900E-14
     -9.79507134816051E-23  -8.65445436217807E-09  -8.65440536930413E-09  -2.93124347689982E-18
      8.29242381993216E-10
      0.00000000000000E+00  -8.63377267645634E-12   0.00000000000000E+00   6.73494671866055E-16   1.17678782468657E-22
      8.63379899744975E-09   8.63379967094454E-09  -8.20911082033533E-19  -2.36618919392432E-01  -2.36618919392453E-01
      0.00000000000000E+00   0.00000000000000E+00   2.06953110939985E-11   0.00000000000000E+00   2.06953110939985E-11
      3.75254154606218E-18  -2.36619042281302E-01  -2.33892415469592E-01   0.00000000000000E+00   4.86340586756833E-14
     -9.79465194560562E-23  -8.65454361609705E-09  -8.65449498203848E-09  -2.93163046402865E-18
      8.49242381993216E-10
      0.00000000000000E+00  -8.63404821066797E-12   0.00000000000000E+00   6.77410606990701E-16   1.16219354270017E-22
      8.63408774229063E-09   8.63408841970135E-09  -8.20937421945052E-19  -2.36590555058098E-01  -2.36590555058118E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04987456461891E-11   0.00000000000000E+00   2.04987456461891E-11
      3.75295152097511E-18  -2.36590679616311E-01  -2.33864023736802E-01   0.00000000000000E+00   4.82984872044359E-14
     -9.79850974295067E-23  -8.65463546383471E-09  -8.65458716534760E-09  -2.93201409903006E-18
      8.69242381993217E-10
      0.00000000000000E+00  -8.63441558961680E-12   0.00000000000000E+00   6.86280423013505E-16   1.16112925681744E-22
      8.63438010886783E-09   8.63438079514837E-09  -8.20963193389020E-19  -2.36562503606254E-01  -2.36562503606274E-01
      0.00000000000000E+00   0.00000000000000E+00   2.03024487837141E-11   0.00000000000000E+00   2.03024487837141E-11
      3.75335756995078E-18  -2.36562584030702E-01  -2.33835897856274E-01   0.00000000000000E+00   4.79929275102848E-14
     -9.79073882907544E-23  -8.65473123685954E-09  -8.65468324393213E-09  -2.93239437656176E-18
      8.79242381993216E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00  -6.86901670329098E-16   1.17441548784705E-22
      8.63452858507420E-09   8.63452789817264E-09  -8.20975940494034E-19  -2.36548555835904E-01  -2.36548555835925E-01
      0.00000000000000E+00   0.00000000000000E+00   2.02041190645104E-11   0.00000000000000E+00   2.02041190645104E-11
      3.75355961114143E-18  -2.36548598137104E-01  -2.33821896147778E-01   0.00000000000000E+00   4.92314247013662E-14
     -9.96285107341958E-23  -8.65478124866178E-09  -8.65473201723718E-09  -2.93258367064740E-18
      8.80929881993216E-10
      0.00000000000000E+00  -8.63450743435401E-12   0.00000000000000E+00   6.65352851893911E-16   1.17666608878192E-22
      8.63455253515494E-09   8.63455320050791E-09  -8.20978086508778E-19  -2.36546204698007E-01  -2.36546204698027E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01876842786683E-11   0.00000000000000E+00   2.01876842786683E-11
      3.75359367785865E-18  -2.36546240303603E-01  -2.33819535954804E-01   0.00000000000000E+00   4.78434424260015E-14
     -9.84494278886956E-23  -8.65478872822806E-09  -8.65474088478573E-09  -2.93261559134987E-18
      8.83208006993216E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00   6.89119761235328E-16   1.17883640154013E-22
      8.63458596903964E-09   8.63458665815952E-09  -8.20980976937305E-19  -2.36543034633476E-01  -2.36543034633496E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01653125630123E-11   0.00000000000000E+00   2.01653125630123E-11
      3.75363961696133E-18  -2.36543060602339E-01  -2.33816352757889E-01   0.00000000000000E+00   4.77924853104098E-14
     -9.80706683061830E-23  -8.65479976320726E-09  -8.65475197072205E-09  -2.93265864002403E-18
      8.86283475743216E-10
      0.00000000000000E+00  -8.63459927909121E-12   0.00000000000000E+00   6.95790874097801E-16   1.18093944438219E-22
      8.63463152098608E-09   8.63463221677707E-09  -8.20984865922602E-19  -2.36538762485834E-01  -2.36538762485854E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01351202499335E-11   0.00000000000000E+00   2.01351202499335E-11
      3.75370154189443E-18  -2.36538773900174E-01  -2.33812061210690E-01   0.00000000000000E+00   4.77454811570443E-14
     -9.79801583379136E-23  -8.65481508250821E-09  -8.65476733702715E-09  -2.93271667597183E-18
      8.90435358555716E-10
      0.00000000000000E+00  -8.63469112382842E-12   0.00000000000000E+00   6.99274552651676E-16   1.18239454443712E-22
      8.63469330926158E-09   8.63469400853625E-09  -8.20990092043861E-19  -2.36533008737075E-01  -2.36533008737095E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00943559340708E-11   0.00000000000000E+00   2.00943559340708E-11
      3.75378497130547E-18  -2.36532997389766E-01  -2.33806278070357E-01   0.00000000000000E+00   4.76891243448149E-14
     -9.79675760771834E-23  -8.65483605359448E-09  -8.65478836447023E-09  -2.93279487926161E-18
      8.96040400352591E-10
      0.00000000000000E+00  -8.63478296856563E-12   0.00000000000000E+00   7.03518232307927E-16   1.18426113338754E-22
      8.63477720468416E-09   8.63477790820251E-09  -8.20997103681159E-19  -2.36525266161203E-01  -2.36525266161223E-01
      0.00000000000000E+00   0.00000000000000E+00   2.00393004145944E-11   0.00000000000000E+00   2.00393004145944E-11
      3.75389729242187E-18  -2.36525217832864E-01  -2.33798489419060E-01   0.00000000000000E+00   4.76165694814650E-14
     -9.79644667086437E-23  -8.65486482518643E-09  -8.65481720861705E-09  -2.93290018874071E-18
      9.03607206778373E-10
      0.00000000000000E+00  -8.63487481330283E-12   0.00000000000000E+00   7.09493484020525E-16   1.15265275839804E-22
      8.63489137734074E-09   8.63489208683434E-09  -8.21006490462999E-19  -2.36514859368707E-01  -2.36514859368727E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99649574918305E-11   0.00000000000000E+00   1.99649574918305E-11
      3.75404836339051E-18  -2.36514748341398E-01  -2.33788007367859E-01   0.00000000000000E+00   4.75235809965039E-14
     -9.81350096981428E-23  -8.65490456790688E-09  -8.65485704432598E-09  -2.93304187292751E-18
      9.13822395453177E-10
      0.00000000000000E+00  -8.63505850277725E-12   0.00000000000000E+00   7.17538500598815E-16  -1.98255664551376E-22
      8.63504716853662E-09   8.63504788607493E-09  -8.21019021052417E-19  -2.36500893401177E-01  -2.36500893401197E-01
      0.00000000000000E+00   0.00000000000000E+00   1.98647020272792E-11   0.00000000000000E+00   1.98647020272792E-11
      3.75425128506969E-18  -2.36500671400387E-01  -2.33773912914996E-01   0.00000000000000E+00   4.74063049275603E-14
     -9.82076452732605E-23  -8.65495999440706E-09  -8.65491258810223E-09  -2.93323226401727E-18
      9.27612900164164E-10
      0.00000000000000E+00  -8.63524219225167E-12   0.00000000000000E+00   7.26034905453363E-16   1.82904079965140E-22
      8.63525984835371E-09   8.63526057438880E-09  -8.21035689622974E-19  -2.36482188561143E-01  -2.36482188561163E-01
      0.00000000000000E+00   0.00000000000000E+00   1.97302629412892E-11   0.00000000000000E+00   1.97302629412892E-11
      3.75452337535373E-18  -2.36481764120283E-01  -2.33754980965263E-01   0.00000000000000E+00   4.72584492716681E-14
     -1.02086503034435E-22  -8.65503809577929E-09  -8.65499083733012E-09  -2.93348768573076E-18
      9.46230081523995E-10
      0.00000000000000E+00  -8.63551772646329E-12   0.00000000000000E+00   7.14678569412287E-16   1.44026990861002E-22
      8.63554625004520E-09   8.63554696472392E-09  -8.21057793455936E-19  -2.36457189914546E-01  -2.36457189914565E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95539116218566E-11   0.00000000000000E+00   1.95539116218566E-11
      3.75488741407269E-18  -2.36456405497308E-01  -2.33729587648335E-01   0.00000000000000E+00   4.70622482477399E-14
     -9.79537732067472E-23  -8.65514793859380E-09  -8.65510087634565E-09  -2.93382962061675E-18
      9.51230081523995E-10
      0.00000000000000E+00  -8.63560957120050E-12   0.00000000000000E+00   7.20917533606734E-16   1.33904780850648E-22
      8.63562298228573E-09   8.63562370320340E-09  -8.21063702213039E-19  -2.36450493874528E-01  -2.36450493874547E-01
      0.00000000000000E+00   0.00000000000000E+00   1.95069597573818E-11   0.00000000000000E+00   1.95069597573818E-11
      3.75498494887147E-18  -2.36449606888005E-01  -2.33722779651099E-01   0.00000000000000E+00   4.69954757187951E-14
     -1.01021366307203E-22  -8.65517765843635E-09  -8.65513066296073E-09  -2.93392124665843E-18
      9.57980081523995E-10
      0.00000000000000E+00  -8.63570141593770E-12   0.00000000000000E+00   7.17350766280882E-16   1.26154268021099E-22
      8.63572589469835E-09   8.63572661204924E-09  -8.21071632252703E-19  -2.36441485281152E-01  -2.36441485281171E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94446716924627E-11   0.00000000000000E+00   1.94446716924627E-11
      3.75511620040540E-18  -2.36440450288910E-01  -2.33713610246463E-01   0.00000000000000E+00   4.69141140399950E-14
     -9.82252458505491E-23  -8.65521819785585E-09  -8.65517128374191E-09  -2.93404456815269E-18
      9.67092581523995E-10
      0.00000000000000E+00  -8.63588510541212E-12   0.00000000000000E+00   7.04439067025054E-16   1.31102383277559E-22
      8.63586245282763E-09   8.63586315726683E-09  -8.21082263653564E-19  -2.36429375717550E-01  -2.36429375717569E-01
      0.00000000000000E+00   0.00000000000000E+00   1.93631690671678E-11   0.00000000000000E+00   1.93631690671678E-11
      3.75529264728352E-18  -2.36428128651240E-01  -2.33701271256310E-01   0.00000000000000E+00   4.67949248389088E-14
     -9.76697889495108E-23  -8.65527312125863E-09  -8.65522632633389E-09  -2.93421038362996E-18
      9.79394456523995E-10
      0.00000000000000E+00  -8.63606879488653E-12   0.00000000000000E+00   6.70882344561632E-16   1.18307448754163E-22
      8.63603848312553E-09   8.63603915400799E-09  -8.21096517879807E-19  -2.36413106813909E-01  -2.36413106813928E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92599796047081E-11   0.00000000000000E+00   1.92599796047081E-11
      3.75552958114512E-18  -2.36411572768023E-01  -2.33684692419907E-01   0.00000000000000E+00   4.65959467768781E-14
     -5.05484739807552E-23  -8.65534572955934E-09  -8.65529913361261E-09  -2.93443306326532E-18
      9.96001987773995E-10
      0.00000000000000E+00  -8.63625248436095E-12   0.00000000000000E+00   5.85240450967098E-16  -6.25676112699789E-23
      8.63624744223304E-09   8.63624802747343E-09  -8.21115710372327E-19  -2.36391231140899E-01  -2.36391231140918E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91396100516486E-11   0.00000000000000E+00   1.91396100516486E-11
      3.75584744281717E-18  -2.36389400045079E-01  -2.33662491793290E-01   0.00000000000000E+00   4.62038991273604E-14
     -3.84521549502649E-22  -8.65543384142395E-09  -8.65538763752520E-09  -2.93473173244484E-18
      1.01600198777400E-09
      0.00000000000000E+00  -8.63643617383536E-12   0.00000000000000E+00   4.08585780831178E-16   1.95982666009059E-22
      8.63642801570654E-09   8.63642842429251E-09  -8.21139043946528E-19  -2.36364880659708E-01  -2.36364880659727E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90339325255428E-11   0.00000000000000E+00   1.90339325255428E-11
      3.75622812146768E-18  -2.36363073167846E-01  -2.33636141351132E-01   0.00000000000000E+00   4.54461978183853E-14
     -5.22854606761393E-23  -8.65550780301586E-09  -8.65546235681809E-09  -2.93508907752115E-18
      1.03600198777400E-09
      0.00000000000000E+00  -8.63643617383536E-12   0.00000000000000E+00  -1.03393458037852E-15   1.44207111067278E-22
      8.63650952393534E-09   8.63650849000091E-09  -8.21162924235646E-19  -2.36338374756764E-01  -2.36338374756783E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89756641777738E-11   0.00000000000000E+00   1.89756641777738E-11
      3.75660763475124E-18  -2.36337293373721E-01  -2.33610354288514E-01   0.00000000000000E+00   4.55105417381669E-14
     -1.09844178758226E-22  -8.65552966472034E-09  -8.65548415417871E-09  -2.93544471051559E-18
      1.05600198777400E-09
      0.00000000000000E+00  -8.63643617383536E-12   0.00000000000000E+00  -1.44790073045388E-16   1.25860262858857E-22
      8.63646993072994E-09   8.63646978593999E-09  -8.21187603090892E-19  -2.36311594841532E-01  -2.36311594841551E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89637920122091E-11   0.00000000000000E+00   1.89637920122091E-11
      3.75698691059148E-18  -2.36312290180631E-01  -2.33585367380942E-01   0.00000000000000E+00   4.27848651450658E-14
     -9.79421013225228E-23  -8.65547636281721E-09  -8.65543357795217E-09  -2.93579930750059E-18
      1.06100198777400E-09
      0.00000000000000E+00  -8.63643617383536E-12   0.00000000000000E+00  -2.35552926710064E-16   1.23301698814057E-22
      8.63645293290661E-09   8.63645269735381E-09  -8.21193826747002E-19  -2.36304880921778E-01  -2.36304880921797E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89636039642480E-11   0.00000000000000E+00   1.89636039642480E-11
      3.75708172861130E-18  -2.36306091540042E-01  -2.33579174171095E-01   0.00000000000000E+00   4.23882007668379E-14
     -9.79875694212759E-23  -8.65545868951871E-09  -8.65541630131804E-09  -2.93588790186430E-18
      1.06775198777400E-09
      0.00000000000000E+00  -8.63643617383536E-12   0.00000000000000E+00  -3.15409340260082E-16   1.21756219124176E-22
      8.63641559131845E-09   8.63641527590923E-09  -8.21202334541320E-19  -2.36295778939320E-01  -2.36295778939339E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89681081208344E-11   0.00000000000000E+00   1.89681081208344E-11
      3.75720976334112E-18  -2.36297826777406E-01  -2.33570919779467E-01   0.00000000000000E+00   4.17669732614579E-14
     -9.79751627120620E-23  -8.65542515100328E-09  -8.65538338403012E-09  -2.93600742879980E-18
      1.07686448777400E-09
      0.00000000000000E+00  -8.63634432909816E-12   0.00000000000000E+00  -4.53461775656927E-16   1.21010865667581E-22
      8.63633990151144E-09   8.63633944804978E-09  -8.21214023284420E-19  -2.36283416604079E-01  -2.36283416604097E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89812617791108E-11   0.00000000000000E+00   1.89812617791108E-11
      3.75738273008908E-18  -2.36286880440795E-01  -2.33559993177987E-01   0.00000000000000E+00   4.08876984664868E-14
     -9.79271051132568E-23  -8.65536159752730E-09  -8.65532070982894E-09  -2.93616870680466E-18
      1.08916636277400E-09
      0.00000000000000E+00  -8.63625248436095E-12   0.00000000000000E+00  -6.12369763491561E-16   1.20785549900829E-22
      8.63619843807044E-09   8.63619782570079E-09  -8.21230153144718E-19  -2.36266599581664E-01  -2.36266599581683E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90044332725607E-11   0.00000000000000E+00   1.90044332725607E-11
      3.75761652025164E-18  -2.36272538373267E-01  -2.33545688414887E-01   0.00000000000000E+00   3.96125424861650E-14
     -9.79247796020379E-23  -8.65524187151557E-09  -8.65520225897318E-09  -2.93638636710693E-18
      1.10577389402400E-09
      0.00000000000000E+00  -8.63597695014933E-12   0.00000000000000E+00  -6.90743993834795E-16   1.20838228937146E-22
      8.63598164858771E-09   8.63598095784384E-09  -8.21252277467906E-19  -2.36243793617950E-01  -2.36243793617969E-01
      0.00000000000000E+00   0.00000000000000E+00   1.90123562479319E-11   0.00000000000000E+00   1.90123562479319E-11
      3.75793226855217E-18  -2.36254034502508E-01  -2.33527250354806E-01   0.00000000000000E+00   3.79617773732873E-14
     -9.79220994329264E-23  -8.65503127586915E-09  -8.65499331409187E-09  -2.93667999108426E-18
      1.12577389402400E-09
      0.00000000000000E+00  -8.63588510541212E-12   0.00000000000000E+00  -3.79648323706919E-16   1.21015695176649E-22
      8.63584639617617E-09   8.63584601652796E-09  -8.21278174443082E-19  -2.36216753745061E-01  -2.36216753745080E-01
      0.00000000000000E+00   0.00000000000000E+00   1.88927916908173E-11   0.00000000000000E+00   1.88927916908173E-11
      3.75831012438598E-18  -2.36232824958238E-01  -2.33506120973346E-01   0.00000000000000E+00   3.67961051773367E-14
     -9.79189417676754E-23  -8.65477560432390E-09  -8.65473880821883E-09  -2.93703194994290E-18
      1.13577389402400E-09
      0.00000000000000E+00  -8.63579326067491E-12   0.00000000000000E+00  -1.94610499049167E-16   1.21115007398954E-22
      8.63583750835814E-09   8.63583731374776E-09  -8.21290725264697E-19  -2.36203437071660E-01  -2.36203437071678E-01
      0.00000000000000E+00   0.00000000000000E+00   1.87866364139111E-11   0.00000000000000E+00   1.87866364139111E-11
      3.75849799075012E-18  -2.36222446723524E-01  -2.33495778882160E-01   0.00000000000000E+00   3.66252459929389E-14
     -9.79173849444832E-23  -8.65466057540739E-09  -8.65462395016149E-09  -2.93720726548542E-18
      1.14927389402400E-09
      0.00000000000000E+00  -8.63597695014933E-12   0.00000000000000E+00   6.03187281888662E-16   1.21256453877487E-22
      8.63601354091901E-09   8.63601414410641E-09  -8.21306221611139E-19  -2.36186163833133E-01  -2.36186163833152E-01
      0.00000000000000E+00   0.00000000000000E+00   1.85153883523507E-11   0.00000000000000E+00   1.85153883523507E-11
      3.75874794849288E-18  -2.36208626357842E-01  -2.33481988284569E-01   0.00000000000000E+00   3.70977723183395E-14
     -9.79152225682989E-23  -8.65456663023100E-09  -8.65452953245878E-09  -2.93744172688174E-18
      1.16749889402400E-09
      0.00000000000000E+00  -8.63689539752140E-12   0.00000000000000E+00   2.32309972598149E-15   1.21457711346358E-22
      8.63687092082911E-09   8.63687324392896E-09  -8.21322041167301E-19  -2.36165274531596E-01  -2.36165274531613E-01
      0.00000000000000E+00   0.00000000000000E+00   1.78004891512295E-11   0.00000000000000E+00   1.78004891512295E-11
      3.75907236240766E-18  -2.36189337122861E-01  -2.33462653613796E-01   0.00000000000000E+00   4.05099682622239E-14
     -9.79120242208163E-23  -8.65471424304831E-09  -8.65467373308014E-09  -2.93775032124036E-18
      1.18749889402399E-09
      0.00000000000000E+00  -8.63891598173997E-12   0.00000000000000E+00   5.23121991849318E-15   1.21695841382989E-22
      8.63894537157754E-09   8.63895060279758E-09  -8.21329387824151E-19  -2.36147092657274E-01  -2.36147092657290E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64656311676975E-11   0.00000000000000E+00   1.64656311676975E-11
      3.75940167503102E-18  -2.36165334403584E-01  -2.33438416980621E-01   0.00000000000000E+00   4.87215744412806E-14
     -9.79077625527983E-23  -8.65546495553963E-09  -8.65541623396529E-09  -2.93807228720686E-18
      1.20749889402399E-09
      0.00000000000000E+00  -8.64249792649106E-12   0.00000000000000E+00   8.89498725346202E-15   1.21957119216296E-22
      8.64245226133696E-09   8.64246115632433E-09  -8.21323163254534E-19  -2.36135346491848E-01  -2.36135346491863E-01
      0.00000000000000E+00   0.00000000000000E+00   1.45462293064482E-11   0.00000000000000E+00   1.45462293064482E-11
      3.75969259961714E-18  -2.36135771713803E-01  -2.33408353008810E-01   0.00000000000000E+00   6.21253741255958E-14
     -9.79022900563843E-23  -8.65706951100480E-09  -8.65700738563077E-09  -2.93836943636261E-18
      1.22749889402399E-09
      0.00000000000000E+00  -8.64745754230027E-12   0.00000000000000E+00   1.25526897792681E-14   1.22243995663380E-22
      8.64740831774471E-09   8.64742087043461E-09  -8.21301750913935E-19  -2.36130856832293E-01  -2.36130856832306E-01
      0.00000000000000E+00   0.00000000000000E+00   1.22003959361888E-11   0.00000000000000E+00   1.22003959361888E-11
      3.75993660753587E-18  -2.36097731196291E-01  -2.33369488974326E-01   0.00000000000000E+00   8.00972684866332E-14
     -9.78952148835466E-23  -8.65970136363921E-09  -8.65962126637082E-09  -2.93863485662193E-18
      1.24749889402399E-09
      0.00000000000000E+00  -8.65333560548155E-12   0.00000000000000E+00   1.47213793702188E-14   1.22550894529462E-22
      8.65329523674817E-09   8.65330995812767E-09  -8.21267784521053E-19  -2.36132497947435E-01  -2.36132497947445E-01
      0.00000000000000E+00   0.00000000000000E+00   9.88633871955286E-12   0.00000000000000E+00   9.88633871955286E-12
      3.76013433431026E-18  -2.36049037071096E-01  -2.33319668444763E-01   0.00000000000000E+00   9.98090253755667E-14
     -9.78864190382122E-23  -8.66329610587247E-09  -8.66319629684719E-09  -2.93886654978920E-18
      1.26749889402399E-09
      0.00000000000000E+00  -8.65884628971400E-12   0.00000000000000E+00   1.36413136227251E-14   1.22859129449163E-22
      8.65878800644954E-09   8.65880164776328E-09  -8.21230861642153E-19  -2.36135924943954E-01  -2.36135924943963E-01
      0.00000000000000E+00   0.00000000000000E+00   8.45126110162459E-12   0.00000000000000E+00   8.45126110162459E-12
      3.76030335953229E-18  -2.35989729802223E-01  -2.33259083045747E-01   0.00000000000000E+00   1.14828705564358E-13
     -9.78763424139552E-23  -8.66736773757037E-09  -8.66725290886490E-09  -2.93907249789014E-18
      1.28749889402399E-09
      0.00000000000000E+00  -8.66160163183023E-12   0.00000000000000E+00   6.88578446079184E-15   1.23132466219342E-22
      8.66155075105843E-09   8.66155763684302E-09  -8.21209994508062E-19  -2.36132406137046E-01  -2.36132406137056E-01
      0.00000000000000E+00   0.00000000000000E+00   9.15091475991220E-12   0.00000000000000E+00   9.15091475991220E-12
      3.76048637782749E-18  -2.35923991636584E-01  -2.33192256109248E-01   0.00000000000000E+00   1.15268219059315E-13
     -9.78663036762891E-23  -8.67082381982186E-09  -8.67070855160290E-09  -2.93927638331942E-18
      1.30749889402399E-09
      0.00000000000000E+00  -8.65820337655355E-12   0.00000000000000E+00  -8.00537097703569E-15   1.23315481750291E-22
      8.65823708119826E-09   8.65822907582740E-09  -8.21234659373066E-19  -2.36108286010364E-01  -2.36108286010377E-01
      0.00000000000000E+00   0.00000000000000E+00   1.35331302301543E-11   0.00000000000000E+00   1.35331302301543E-11
      3.76075704043209E-18  -2.35862185627278E-01  -2.33130118121788E-01   0.00000000000000E+00   8.81750055575661E-14
     -9.78587702887769E-23  -8.67185038106312E-09  -8.67176220605766E-09  -2.93952238105903E-18
      1.32749889402399E-09
      0.00000000000000E+00  -8.64488588965846E-12   0.00000000000000E+00  -3.05441515662238E-14   1.23337868686027E-22
      8.64487695192190E-09   8.64484640777045E-09  -8.21342823167533E-19  -2.36045831352312E-01  -2.36045831352335E-01
      0.00000000000000E+00   0.00000000000000E+00   2.31074696414902E-11   0.00000000000000E+00   2.31074696414902E-11
      3.76121918982492E-18  -2.35822328400061E-01  -2.33091461390369E-01   0.00000000000000E+00   1.76097963713828E-14
     -9.78574333022400E-23  -8.66797148720811E-09  -8.66795387741184E-09  -2.93987636665739E-18
      1.34749889402399E-09
      0.00000000000000E+00  -8.61779169218224E-12   0.00000000000000E+00  -6.52901070900726E-14   1.23128190280744E-22
      8.61783871714411E-09   8.61777342703714E-09  -8.21574123631918E-19  -2.35926319241205E-01  -2.35926319241244E-01
      0.00000000000000E+00   0.00000000000000E+00   3.87425076903511E-11   0.00000000000000E+00   3.87425076903511E-11
      3.76199403997873E-18  -2.35829902882089E-01  -2.33102639109793E-01   0.00000000000000E+00  -1.01444673739884E-13
     -9.78668655989030E-23  -8.65641449005366E-09  -8.65651593472750E-09  -2.94041991634681E-18
      1.36749889402399E-09
      0.00000000000000E+00  -8.57545126832957E-12   0.00000000000000E+00  -1.05192378425114E-13   1.22640328173017E-22
      8.57551800385077E-09   8.57541281147247E-09  -8.21956275109655E-19  -2.35736281676642E-01  -2.35736281676702E-01
      0.00000000000000E+00   0.00000000000000E+00   5.97570526345745E-11   0.00000000000000E+00   5.97570526345745E-11
      3.76318918103142E-18  -2.35914653261925E-01  -2.33194113991890E-01   0.00000000000000E+00  -2.71142172035596E-13
     -9.78915846996624E-23  -8.63489872193501E-09  -8.63516986410715E-09  -2.94123290592176E-18
      1.38749889402399E-09
      0.00000000000000E+00  -8.52061996021667E-12   0.00000000000000E+00  -1.36312298567367E-13   1.21893055520675E-22
      8.52071060956392E-09   8.52057429726548E-09  -8.22484045813048E-19  -2.35477256406138E-01  -2.35477256406221E-01
      0.00000000000000E+00   0.00000000000000E+00   8.28182160699404E-11   0.00000000000000E+00   8.28182160699404E-11
      3.76484554535282E-18  -2.36102957858163E-01  -2.33392430165712E-01   0.00000000000000E+00  -4.74963337751742E-13
     -9.79342470366944E-23  -8.60291754999748E-09  -8.60339251333533E-09  -2.94236149953977E-18
      1.39749889402399E-09
      0.00000000000000E+00  -8.49077042062423E-12   0.00000000000000E+00  -1.48259416406749E-13   1.21462657444461E-22
      8.49091424269012E-09   8.49076598327384E-09  -8.22780944866678E-19  -2.35331936624712E-01  -2.35331936624807E-01
      0.00000000000000E+00   0.00000000000000E+00   9.42310625682990E-11   0.00000000000000E+00   9.42310625682990E-11
      3.76578785597850E-18  -2.36225666895801E-01  -2.33520934790247E-01   0.00000000000000E+00  -5.81310122133730E-13
     -9.79602078172247E-23  -8.58441573571988E-09  -8.58499704584212E-09  -2.94300691111182E-18
      1.41099889402399E-09
      0.00000000000000E+00  -8.44944028888084E-12   0.00000000000000E+00  -1.51908309737758E-13   1.20822366645237E-22
      8.44963427986888E-09   8.44948237155927E-09  -8.23219614097956E-19  -2.35116968459083E-01  -2.35116968459190E-01
      0.00000000000000E+00   0.00000000000000E+00   1.07082074992160E-10   0.00000000000000E+00   1.07082074992160E-10
      3.76723346399090E-18  -2.36446549119317E-01  -2.33750775009690E-01   0.00000000000000E+00  -7.15395713555783E-13
     -9.80030205148236E-23  -8.55584905083785E-09  -8.55656444655150E-09  -2.94401384989294E-18
      1.42922389402399E-09
      0.00000000000000E+00  -8.40709986502817E-12   0.00000000000000E+00  -1.15794732952581E-13   1.20077711177051E-22
      8.40719822136910E-09   8.40708242663626E-09  -8.23761523527971E-19  -2.34847055974085E-01  -2.34847055974196E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10817426510033E-10   0.00000000000000E+00   1.10817426510033E-10
      3.76925311158904E-18  -2.36829333295098E-01  -2.34145740899002E-01   0.00000000000000E+00  -8.10659754667204E-13
     -9.80677956492563E-23  -8.51708919339150E-09  -8.51789985314627E-09  -2.94549158806107E-18
      1.44922389402399E-09
      0.00000000000000E+00  -8.40811015713745E-12   0.00000000000000E+00   9.62822310169258E-15   1.19910883217426E-22
      8.40805371528691E-09   8.40806334351014E-09  -8.24023098038242E-19  -2.34701183656819E-01  -2.34701183656902E-01
      0.00000000000000E+00   0.00000000000000E+00   8.26975617067057E-11   0.00000000000000E+00   8.26975617067057E-11
      3.77090706282317E-18  -2.37273826034917E-01  -2.34598786836086E-01   0.00000000000000E+00  -6.90458611015901E-13
     -9.81264047440929E-23  -8.49007044660571E-09  -8.49076090521683E-09  -2.94688396478494E-18
      1.46922389402399E-09
      0.00000000000000E+00  -8.49719955222875E-12   0.00000000000000E+00   2.55638517724069E-13   1.21095070966301E-22
      8.49694324171623E-09   8.49719888023407E-09  -8.23570906980466E-19  -2.34882772994256E-01  -2.34882772994261E-01
      0.00000000000000E+00   0.00000000000000E+00   5.32920969944510E-12   0.00000000000000E+00   5.32920969944510E-12
      3.77101364701716E-18  -2.37589891194922E-01  -2.34911154052834E-01   0.00000000000000E+00  -2.05303173041456E-13
     -9.81384716906751E-23  -8.50232278676041E-09  -8.50252808993355E-09  -2.94744274003670E-18
      1.48922389402399E-09
      0.00000000000000E+00  -8.71744323205240E-12   0.00000000000000E+00   6.36349481082554E-13   1.24443721067094E-22
      8.71684153944341E-09   8.71747788892461E-09  -8.21975265677741E-19  -2.35593335911280E-01  -2.35593335911146E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.34058947729527E-10   0.00000000000000E+00  -1.34058947729527E-10
      3.76833246806257E-18  -2.37538890926520E-01  -2.34834687009686E-01   0.00000000000000E+00   7.66199194754561E-13
     -9.80584612333955E-23  -8.58418514038976E-09  -8.58341894119510E-09  -2.94635720238483E-18
      1.50922389402399E-09
      0.00000000000000E+00  -9.10080316515662E-12   0.00000000000000E+00   9.51548451548806E-13   1.30692364354004E-22
      9.09994182506593E-09   9.10089337351760E-09  -8.18887284131064E-19  -2.36999097472817E-01  -2.36999097472481E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.36060990239346E-10   0.00000000000000E+00  -3.36060990239346E-10
      3.76161124825778E-18  -2.36803872040607E-01  -2.34042485269297E-01   0.00000000000000E+00   2.43621561362134E-12
     -9.78363592505842E-23  -8.76726859889179E-09  -8.76483238327826E-09  -2.94272396412672E-18
      1.52922389402399E-09
      0.00000000000000E+00  -9.64838148838789E-12   0.00000000000000E+00   1.75003924555817E-12   1.40161658886216E-22
      9.64699209279806E-09   9.64874213204376E-09  -8.14230685357699E-19  -2.39142727083771E-01  -2.39142727083191E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.80288372983712E-10   0.00000000000000E+00  -5.80288372983712E-10
      3.75000548079811E-18  -2.35031397887515E-01  -2.32174476998661E-01   0.00000000000000E+00   4.03724984447768E-12
     -9.74315096129827E-23  -9.07249100890436E-09  -9.06845375905998E-09  -2.93577479544041E-18
      1.54922389402399E-09
      0.00000000000000E+00  -1.03011220357218E-11   0.00000000000000E+00   1.62163009624675E-12   1.52217102513953E-22
      1.02994662033187E-08   1.03010878334151E-08  -8.08424698475015E-19  -2.41841473384246E-01  -2.41841473383429E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.17201288601726E-10   0.00000000000000E+00  -8.17201288601726E-10
      3.73366145502608E-18  -2.31925304831799E-01  -2.28937375721739E-01   0.00000000000000E+00   6.48291202961294E-12
     -9.68319638635888E-23  -9.49036945684299E-09  -9.48388654481348E-09  -2.92523675655106E-18
      1.56922389402399E-09
      0.00000000000000E+00  -1.09062870091822E-11   0.00000000000000E+00   1.50514957613301E-12   1.64579487731780E-22
      1.09047147774101E-08   1.09062199269864E-08  -8.02566631286390E-19  -2.44602499494536E-01  -2.44602499493575E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.61068369282510E-10   0.00000000000000E+00  -9.61068369282510E-10
      3.71444008764043E-18  -2.27437140144207E-01  -2.24303884107810E-01   0.00000000000000E+00   7.97600966426073E-12
     -9.60821655992499E-23  -9.95312756736802E-09  -9.94515155770386E-09  -2.91187345635404E-18
      1.58922389402399E-09
      0.00000000000000E+00  -1.11856786997675E-11   0.00000000000000E+00   6.99608294458126E-13   1.72623777833859E-22
      1.11850087624912E-08   1.11857083707858E-08  -7.98587833551512E-19  -2.46547156673156E-01  -2.46547156672276E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.80597552951698E-10   0.00000000000000E+00  -8.80597552951698E-10
      3.69682813658139E-18  -2.22054518411613E-01  -2.18807850047557E-01   0.00000000000000E+00   8.03510553177094E-12
     -9.53189627548843E-23  -1.03131459233657E-08  -1.03051108178340E-08  -2.89824030302988E-18
      1.60922389402399E-09
      0.00000000000000E+00  -1.07353639532390E-11   0.00000000000000E+00  -1.10806393926139E-12   1.69296096275819E-22
      1.07364833247296E-08   1.07353752607906E-08  -7.99398338379965E-19  -2.46332176148541E-01  -2.46332176148147E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.94164468904237E-10   0.00000000000000E+00  -3.94164468904237E-10
      3.68894484720331E-18  -2.17137065852422E-01  -2.13879017096681E-01   0.00000000000000E+00   5.48405274288541E-12
     -9.48144778423659E-23  -1.03466948446291E-08  -1.03412107918863E-08  -2.88954650882334E-18
      1.62922389402399E-09
      0.00000000000000E+00  -9.13818397320008E-12   0.00000000000000E+00  -3.95218615657071E-12   1.47101587794289E-22
      9.14213986604252E-09   9.13818767988609E-09  -8.08904304396501E-19  -2.42120764284458E-01  -2.42120764285142E-01
      0.00000000000000E+00   0.00000000000000E+00   6.84064217882290E-10   0.00000000000000E+00   6.84064217882290E-10
      3.70262613156096E-18  -2.14975573286274E-01  -2.11881018073217E-01   0.00000000000000E+00  -1.13374941497456E-12
     -9.49899481298926E-23  -9.82111814835336E-09  -9.82225189776843E-09  -2.89372182716446E-18
      1.64922389402399E-09
      0.00000000000000E+00  -6.28484352237385E-12   0.00000000000000E+00  -7.07703603514895E-12   1.03708258971765E-22
      6.29187187279907E-09   6.28479483676402E-09  -8.31443731988888E-19  -2.31812100209334E-01  -2.31812100211716E-01
      0.00000000000000E+00   0.00000000000000E+00   2.38239325642789E-09   0.00000000000000E+00   2.38239325642789E-09
      3.75027399668951E-18  -2.17968594969573E-01  -2.15237941706896E-01   0.00000000000000E+00  -1.32783325516953E-11
     -9.63230110740356E-23  -8.65390976064010E-09  -8.66718809319190E-09  -2.91883026470062E-18
      1.66922389402399E-09
      0.00000000000000E+00  -2.72034927134973E-12   0.00000000000000E+00  -8.87585519983783E-12   4.78818312455412E-23
      2.72928656631553E-09   2.72041071111574E-09  -8.70407891220822E-19  -2.13623393240831E-01  -2.13623393245228E-01
      0.00000000000000E+00   0.00000000000000E+00   4.39685425584350E-09   0.00000000000000E+00   4.39685425584350E-09
      3.83821108180638E-18  -2.26821173424481E-01  -2.24578821989232E-01   0.00000000000000E+00  -3.16852882768988E-11
     -9.91240217592417E-23  -7.08557967868215E-09  -7.11726496695915E-09  -2.96780319058556E-18
      1.68922389402399E-09
      0.00000000000000E+00   5.05880812539057E-13   0.00000000000000E+00  -8.10898794758115E-12  -3.41520269165871E-24
     -4.97782641194712E-10  -5.05891629142297E-10  -9.26429019658095E-19  -1.86842127943770E-01  -1.86842127949954E-01
      0.00000000000000E+00   0.00000000000000E+00   6.18487160221102E-09   0.00000000000000E+00   6.18487160221102E-09
      3.96190851385060E-18  -2.39397729042861E-01  -2.37608503589787E-01   0.00000000000000E+00  -5.51496033096945E-11
     -1.03356286184865E-22  -5.62383036975906E-09  -5.67897997306886E-09  -3.03547949419251E-18
      1.70922389402399E-09
      0.00000000000000E+00   2.56641749178992E-12   0.00000000000000E+00  -5.31533326844014E-12  -3.29776062085939E-23
     -2.56113485101564E-09  -2.56645018428412E-09  -9.95352756566597E-19  -1.52798959384404E-01  -1.52798959391675E-01
      0.00000000000000E+00   0.00000000000000E+00   7.27111104148976E-09   0.00000000000000E+00   7.27111104148976E-09
      4.10733073468040E-18  -2.52307256051347E-01  -2.50824982320025E-01   0.00000000000000E+00  -7.97265665938279E-11
     -1.08693616685822E-22  -4.62493429061164E-09  -4.70466085720558E-09  -3.11197797811380E-18
      1.72922389402399E-09
      0.00000000000000E+00   3.32551424481013E-12   0.00000000000000E+00  -2.17602735333555E-12  -4.30577925024680E-23
     -3.32336845668020E-09  -3.32554448403358E-09  -1.06747872251177E-18  -1.15688795764523E-01  -1.15688795771907E-01
      0.00000000000000E+00   0.00000000000000E+00   7.38360627154044E-09   0.00000000000000E+00   7.38360627154044E-09
      4.25500286011121E-18  -2.63683616008521E-01  -2.62405050121985E-01   0.00000000000000E+00  -9.92707250768505E-11
     -1.14609030544647E-22  -3.95879106242993E-09  -4.05806178750690E-09  -3.18752413759944E-18
      1.74922389402399E-09
      0.00000000000000E+00   3.05025556739917E-12   0.00000000000000E+00   3.57249507013235E-13  -4.56042006162061E-23
     -3.05057823616331E-09  -3.05022098665634E-09  -1.13008430722618E-18  -8.20944624568192E-02  -8.20944624632457E-02
      0.00000000000000E+00   0.00000000000000E+00   6.42655660763878E-09   0.00000000000000E+00   6.42655660763878E-09
      4.38353399226398E-18  -2.73661751060340E-01  -2.72597968593286E-01   0.00000000000000E+00  -1.05463645139665E-10
     -1.20297002893674E-22  -3.27087197584265E-09  -3.37633562098243E-09  -3.25344968503781E-18
      1.76922389402399E-09
      0.00000000000000E+00   2.10664273732904E-12   0.00000000000000E+00   2.07334746385739E-12  -4.63424129959850E-23
     -2.10866682259123E-09  -2.10659347512742E-09  -1.17259647613309E-18  -5.85199102101458E-02  -5.85199102147425E-02
      0.00000000000000E+00   0.00000000000000E+00   4.59675348818914E-09   0.00000000000000E+00   4.59675348818914E-09
      4.47546906202776E-18  -2.83025436722724E-01  -2.82240858925298E-01   0.00000000000000E+00  -9.08396522057536E-11
     -1.24825761182347E-22  -2.39932036085572E-09  -2.49016001306160E-09  -3.30287258589467E-18
      1.78922389402399E-09
      0.00000000000000E+00   1.02866105672430E-12   0.00000000000000E+00   2.52786887664991E-12  -4.65758622864416E-23
     -1.03114752836814E-09  -1.02861965949153E-09  -1.19320554157465E-18  -4.69088194111182E-02  -4.69088194137298E-02
      0.00000000000000E+00   0.00000000000000E+00   2.61159698011836E-09   0.00000000000000E+00   2.61159698011836E-09
      4.52770100163013E-18  -2.92009489872130E-01  -2.91510739611135E-01   0.00000000000000E+00  -6.15428518152291E-11
     -1.27744963000006E-22  -1.52143446881145E-09  -1.58297732062681E-09  -3.33449546005548E-18
      1.80922389402399E-09
      0.00000000000000E+00   1.09387082014164E-13   0.00000000000000E+00   2.25925809898011E-12  -4.65309894212335E-23
     -1.11660544465857E-10  -1.09401286366924E-10  -1.19543405102349E-18  -4.57145264533229E-02  -4.57145264542793E-02
      0.00000000000000E+00   0.00000000000000E+00   9.56414083026429E-10   0.00000000000000E+00   9.56414083026429E-10
      4.54682928329066E-18  -3.00844313157424E-01  -3.00577446992758E-01   0.00000000000000E+00  -3.04858489833648E-11
     -1.29175257654780E-22  -8.16526947676169E-10  -8.47012796659663E-10  -3.35139523226717E-18
      1.82922389402399E-09
      0.00000000000000E+00  -8.02998537405406E-13   0.00000000000000E+00   2.35953354879184E-12  -4.62083166728450E-23
      8.00656340821144E-10   8.03015874369889E-10  -1.17975932057892E-18  -5.46127381243747E-02  -5.46127381238859E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.88794789941336E-10   0.00000000000000E+00  -4.88794789941336E-10
      4.53705338749183E-18  -3.11671553511887E-01  -3.11572558465279E-01   0.00000000000000E+00  -4.54430368904725E-12
     -1.29434860492428E-22  -3.09676780739406E-10  -3.14221084428582E-10  -3.35729406691292E-18
      1.84922389402399E-09
      0.00000000000000E+00  -1.73770242796641E-12   0.00000000000000E+00   2.51234243156894E-12  -4.55244227896136E-23
      1.73520012494046E-09   1.73771246737199E-09  -1.14644213993909E-18  -7.30132962936621E-02  -7.30132962919272E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.73492982648898E-09   0.00000000000000E+00  -1.73492982648898E-09
      4.50235479096205E-18  -3.26552505024522E-01  -3.26551639731271E-01   0.00000000000000E+00   1.27076153687557E-11
     -1.28916867859871E-22  -1.54902562515639E-11  -2.78264088293703E-12  -3.35591265102297E-18
      1.86922389402399E-09
      0.00000000000000E+00  -2.42203756489969E-12   0.00000000000000E+00   1.93141956193746E-12  -4.40899981548019E-23
      2.42016065854037E-09   2.42209207810226E-09  -1.10203180669162E-18  -9.67446900677671E-02  -9.67446900652606E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.50652516797918E-09   0.00000000000000E+00  -2.50652516797918E-09
      4.45222428760247E-18  -3.43604392595850E-01  -3.43631013154448E-01   0.00000000000000E+00   2.19967534552481E-11
     -1.27954311108054E-22   6.24363364218578E-11   8.44330898769780E-11  -3.35019248091085E-18
      1.88922389402399E-09
      0.00000000000000E+00  -3.01461980936265E-12   0.00000000000000E+00   1.69654658181410E-12  -4.00699912243883E-23
      3.01291493678536E-09   3.01461148336713E-09  -1.05179488325056E-18  -1.22641459469566E-01  -1.22641459466589E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.97740612770093E-09   0.00000000000000E+00  -2.97740612770093E-09
      4.39267616504845E-18  -3.60388971466617E-01  -3.60377280570569E-01   0.00000000000000E+00   2.85302588342303E-11
     -1.26649311039364E-22  -6.57356145003100E-11  -3.72053556662063E-11  -3.34088128179789E-18
      1.90922389402399E-09
      0.00000000000000E+00  -3.95722234732350E-12   0.00000000000000E+00   2.53981351193333E-12  -2.78335351636981E-23
      3.95466739855486E-09   3.95720721206676E-09  -9.96727455802893E-19  -1.50019176966850E-01  -1.50019176963375E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.47491231181957E-09   0.00000000000000E+00  -3.47491231181957E-09
      4.32317791881206E-18  -3.75387627419811E-01  -3.75235730432826E-01   0.00000000000000E+00   3.67407678427220E-11
     -1.24889222969816E-22  -5.19035668089797E-10  -4.82294900247199E-10  -3.32645046300917E-18
      1.92922389402399E-09
      0.00000000000000E+00  -5.90671873929046E-12   0.00000000000000E+00   5.00082043995539E-12   7.56507894219727E-24
      5.90171497414950E-09   5.90671579458946E-09  -9.35932043233610E-19  -1.79185702703313E-01  -1.79185702699098E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.21476329569963E-09   0.00000000000000E+00  -4.21476329569963E-09
      4.23888265289807E-18  -3.86714320014298E-01  -3.86181356797093E-01   0.00000000000000E+00   4.91319023620470E-11
     -1.22390731732433E-22  -1.74108440125184E-09  -1.69195249888991E-09  -3.30295060966446E-18
      1.94922389402399E-09
      0.00000000000000E+00  -9.74077729401866E-12   0.00000000000000E+00   9.61888874312523E-12   8.51217663883046E-23
      9.73117555783804E-09   9.74079444658125E-09  -8.71813197076477E-19  -2.08949219880269E-01  -2.08949219875138E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.13058951979061E-09   0.00000000000000E+00  -5.13058951979061E-09
      4.13627086250226E-18  -3.90362955077848E-01  -3.88910653780349E-01   0.00000000000000E+00   6.42320576440228E-11
     -1.18834450400385E-22  -4.67443698443456E-09  -4.61020492679066E-09  -3.26445766542578E-18
      1.96922389402399E-09
      0.00000000000000E+00  -1.57341974652330E-11   0.00000000000000E+00   1.49074419629907E-11   2.14027466035811E-22
      1.57192685939483E-08   1.57341760359115E-08  -8.12930148659671E-19  -2.35689487545837E-01  -2.35689487539940E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.89718398770029E-09   0.00000000000000E+00  -5.89718398770029E-09
      4.01832718274825E-18  -3.80497401406799E-01  -3.77398449930889E-01   0.00000000000000E+00   7.74796649080383E-11
     -1.14077045530016E-22  -9.91447171311908E-09  -9.83699204821115E-09  -3.20539703408858E-18
      1.98922389402399E-09
      0.00000000000000E+00  -2.25582614397523E-11   0.00000000000000E+00   1.69340580834845E-11   3.69328044073121E-22
      2.25413305128212E-08   2.25582645709051E-08  -7.66496382961712E-19  -2.56826738977393E-01  -2.56826738970924E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.46987119851449E-09   0.00000000000000E+00  -6.46987119851449E-09
      3.88892975877796E-18  -3.52996563686521E-01  -3.47928094591765E-01   0.00000000000000E+00   8.72899925188684E-11
     -1.08213584124521E-22  -1.61756833649093E-08  -1.60883933723906E-08  -3.12243337581625E-18
      2.00922389402399E-09
      0.00000000000000E+00  -2.78285879949318E-11   0.00000000000000E+00   1.30878657865940E-11   4.97939472405874E-22
      2.78154765699414E-08   2.78285644357285E-08  -7.34363335164649E-19  -2.72045189522355E-01  -2.72045189515450E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.90423580810269E-09   0.00000000000000E+00  -6.90423580810269E-09
      3.75084504261591E-18  -3.08363635434804E-01  -3.01771510371005E-01   0.00000000000000E+00   9.01296313328135E-11
     -1.01654650650054E-22  -2.10144582589585E-08  -2.09243286276258E-08  -3.01648170745126E-18
      2.02922389402399E-09
      0.00000000000000E+00  -3.03832493603591E-11   0.00000000000000E+00   6.36552421087977E-12   5.69291598557707E-22
      3.03768955039504E-08   3.03832610281619E-08  -7.13672390152682E-19  -2.82711936679508E-01  -2.82711936672309E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.19876522608154E-09   0.00000000000000E+00  -7.19876522608154E-09
      3.60686973809428E-18  -2.52813525462326E-01  -2.45509203566955E-01   0.00000000000000E+00   8.10887374279831E-11
     -9.46540578979646E-23  -2.32655845395083E-08  -2.31844958020804E-08  -2.89319734794159E-18
      2.04922389402399E-09
      0.00000000000000E+00  -3.08221753594739E-11   0.00000000000000E+00   1.12361704716067E-12   5.91158491630093E-22
      3.08210359751957E-08   3.08221595922435E-08  -6.99788426588569E-19  -2.90727684024304E-01  -2.90727684016955E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34922451550699E-09   0.00000000000000E+00  -7.34922451550699E-09
      3.45988524778414E-18  -1.94399998296429E-01  -1.87004691791302E-01   0.00000000000000E+00   6.37973514899852E-11
     -8.76398901820921E-23  -2.35367324282264E-08  -2.34729350767365E-08  -2.76009682119557E-18
      2.06922389402399E-09
      0.00000000000000E+00  -3.00977040723809E-11   0.00000000000000E+00  -1.76398913635887E-12   5.81041816672510E-22
      3.00994409946270E-08   3.00976770054912E-08  -6.89328894871510E-19  -2.97436909837280E-01  -2.97436909829880E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.39992601571449E-09   0.00000000000000E+00  -7.39992601571449E-09
      3.31188672746985E-18  -1.38390885117467E-01  -1.31239727743057E-01   0.00000000000000E+00   4.68888186405152E-11
     -7.89521468269389E-23  -2.27446398084171E-08  -2.26977509897767E-08  -2.62255783259834E-18
      2.07922389402399E-09
      0.00000000000000E+00  -2.92925931060198E-11   0.00000000000000E+00  -3.95801771554095E-12   5.66074217661313E-22
      2.92965659407763E-08   2.92926079230613E-08  -6.84995745061688E-19  -3.00451059496082E-01  -3.00451059488654E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.42809121721132E-09   0.00000000000000E+00  -7.42809121721132E-09
      3.23760581529773E-18  -1.11822975797406E-01  -1.04934304989857E-01   0.00000000000000E+00   3.80612051325478E-11
     -6.54100041579542E-23  -2.19025779109824E-08  -2.18645167058499E-08  -2.55261007023604E-18
      2.09272389402399E-09
      0.00000000000000E+00  -2.81374618461607E-11   0.00000000000000E+00  -4.21241980071434E-12   5.41095442253972E-22
      2.81416743730673E-08   2.81374619532671E-08  -6.78506966920863E-19  -3.04772609287424E-01  -3.04772609280050E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.37415311426002E-09   0.00000000000000E+00  -7.37415311426002E-09
      3.13805474825522E-18  -8.03774912456195E-02  -7.38357399429630E-02   0.00000000000000E+00   2.96071595017636E-11
     -7.81554484981303E-24  -2.07929159985087E-08  -2.07633088390070E-08  -2.45954778133436E-18
      2.11094889402399E-09
      0.00000000000000E+00  -2.59915095613068E-11   0.00000000000000E+00  -5.79497452402220E-12   5.15731779464887E-22
      2.59972766128402E-08   2.59914816383167E-08  -6.64720974880045E-19  -3.12404363224933E-01  -3.12404363217754E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.17917066364248E-09   0.00000000000000E+00  -7.17917066364248E-09
      3.00721436291034E-18  -4.94840379857716E-02  -4.35569477283789E-02   0.00000000000000E+00   2.14561397635591E-11
      1.54783405430174E-22  -1.88337671144379E-08  -1.88123109746742E-08  -2.34249338803029E-18
      2.13094889402399E-09
      0.00000000000000E+00  -2.33378395691698E-11   0.00000000000000E+00  -6.52060652731276E-12   5.16648169209840E-22
      2.33443609335235E-08   2.33378403269967E-08  -6.39976955000873E-19  -3.24143882358497E-01  -3.24143882351650E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.84718364444940E-09   0.00000000000000E+00  -6.84718364444940E-09
      2.87027069002135E-18  -3.06904973681949E-02  -2.54948628533492E-02   0.00000000000000E+00   1.47299817678784E-11
      3.65837744374770E-22  -1.65053866643156E-08  -1.64906566825473E-08  -2.23029373502048E-18
      2.15094889402399E-09
      0.00000000000000E+00  -2.14089163983373E-11   0.00000000000000E+00  -4.72964321981588E-12   5.29076612097287E-22
      2.14136570012135E-08   2.14089273579942E-08  -6.09321961888271E-19  -3.37914069199305E-01  -3.37914069192732E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.57269632303269E-09   0.00000000000000E+00  -6.57269632303269E-09
      2.73881676356070E-18  -2.15151076046723E-02  -1.68407162811547E-02   0.00000000000000E+00   9.56093981973125E-12
      5.35253241251695E-22  -1.48457919747819E-08  -1.48362310349616E-08  -2.12949480167243E-18
      2.17094889402399E-09
      0.00000000000000E+00  -2.01937186803445E-11   0.00000000000000E+00  -2.96714132066015E-12   5.29868782846550E-22
      2.01966842127216E-08   2.01937170714015E-08  -5.77326312441110E-19  -3.52115061261979E-01  -3.52115061255581E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.39795571041000E-09   0.00000000000000E+00  -6.39795571041000E-09
      2.61085764935250E-18  -1.67153533325992E-02  -1.23687730055078E-02   0.00000000000000E+00   6.54655531444608E-12
      6.37183268593996E-22  -1.38023079163066E-08  -1.37957613609915E-08  -2.03353133691139E-18
      2.19094889402399E-09
      0.00000000000000E+00  -1.93337764058704E-11   0.00000000000000E+00  -2.09051086616161E-12   5.10583353416610E-22
      1.93358590373812E-08   1.93337685265155E-08  -5.45953919772757E-19  -3.66078030975442E-01  -3.66078030969161E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.28073684111821E-09   0.00000000000000E+00  -6.28073684111821E-09
      2.48524291253013E-18  -1.38215065941109E-02  -9.70893155380849E-03   0.00000000000000E+00   5.11816930019096E-12
      6.76378578416277E-22  -1.30581498546982E-08  -1.30530316853973E-08  -1.93928899275738E-18
      2.21094889402399E-09
      0.00000000000000E+00  -1.86770865348366E-11   0.00000000000000E+00  -1.59077563858599E-12   4.73194446093651E-22
      1.86786586449273E-08   1.86770678692892E-08  -5.15561572572091E-19  -3.79693161284709E-01  -3.79693161278507E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.20172590831912E-09   0.00000000000000E+00  -6.20172590831912E-09
      2.36120839436375E-18  -1.18863654717350E-02  -7.95579816279545E-03   0.00000000000000E+00   4.34330902051220E-12
      6.65381998114972E-22  -1.24796852699913E-08  -1.24753419609701E-08  -1.84564682179166E-18
      2.23094889402399E-09
      0.00000000000000E+00  -1.82365073304521E-11   0.00000000000000E+00  -1.05926564946280E-12   4.23400574714194E-22
      1.82375751407150E-08   1.82365158750659E-08  -4.85590916719898E-19  -3.93173976445140E-01  -3.93173976438934E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.20582007704436E-09   0.00000000000000E+00  -6.20582007704436E-09
      2.23709199282286E-18  -1.05188599595026E-02  -6.72838338190711E-03   0.00000000000000E+00   3.82929690916153E-12
      6.18710337603463E-22  -1.20345250949313E-08  -1.20306957980215E-08  -1.75150107610297E-18
      2.25094889402399E-09
      0.00000000000000E+00  -1.82104234250852E-11   0.00000000000000E+00  -3.71936118992640E-14   3.67430602942778E-22
      1.82104530408224E-08   1.82104158472109E-08  -4.54277450630242E-19  -4.07214613019639E-01  -4.07214613013173E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.46579876762885E-09   0.00000000000000E+00  -6.46579876762885E-09
      2.10777601747029E-18  -9.55388178164813E-03  -5.85353702294833E-03   0.00000000000000E+00   3.44190032773540E-12
      5.50202313439003E-22  -1.17480589799104E-08  -1.17446170795821E-08  -1.65349856684004E-18
      2.27094889402399E-09
      0.00000000000000E+00  -1.84335142917622E-11   0.00000000000000E+00   5.78123449883700E-13   3.06929926762836E-22
      1.84329073844705E-08   1.84334855079207E-08  -4.21124790287176E-19  -4.21977319151950E-01  -4.21977319145136E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.81370358651983E-09   0.00000000000000E+00  -6.81370358651983E-09
      1.97150194573989E-18  -8.85879040184624E-03  -5.19777454990230E-03   0.00000000000000E+00   3.07976883339303E-12
      4.66391013685408E-22  -1.16228616902347E-08  -1.16197819214009E-08  -1.55037715545271E-18
      2.29094889402399E-09
      0.00000000000000E+00  -1.85662299370271E-11   0.00000000000000E+00   3.56062395738228E-13   2.43176401976110E-22
      1.85658418706475E-08   1.85661979330435E-08  -3.87207304705319E-19  -4.36977715432300E-01  -4.36977715425313E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.98774452197865E-09   0.00000000000000E+00  -6.98774452197865E-09
      1.83174705530032E-18  -8.30869451353601E-03  -4.66069757367091E-03   0.00000000000000E+00   2.80406793806893E-12
      3.72313317863541E-22  -1.15812574790032E-08  -1.15784534110648E-08  -1.44453975059500E-18
      2.30094889402399E-09
      0.00000000000000E+00  -1.86127952187913E-11   0.00000000000000E+00   2.57456930826486E-13   2.09435078310522E-22
      1.86125743895548E-08   1.86128318464858E-08  -3.70208483772965E-19  -4.44478573265077E-01  -4.44478573258015E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.06228367150805E-09   0.00000000000000E+00  -7.06228367150805E-09
      1.76112421858524E-18  -8.06811492009489E-03  -4.42890888090249E-03   0.00000000000000E+00   2.73611782146753E-12
      3.20700943301232E-22  -1.15532842927996E-08  -1.15505481749778E-08  -1.39091573481227E-18
      2.31444889402399E-09
      0.00000000000000E+00  -1.86202346425051E-11   0.00000000000000E+00   5.36548879897472E-14   1.67209915783111E-22
      1.86202051650606E-08   1.86202588199488E-08  -3.47323029662090E-19  -4.54524939024396E-01  -4.54524939017365E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.03149156916822E-09   0.00000000000000E+00  -7.03149156916822E-09
      1.66619908240147E-18  -7.80523922311772E-03  -4.15399000634192E-03   0.00000000000000E+00   2.37610010648285E-12
      2.55568771205858E-22  -1.15911433508873E-08  -1.15887672507806E-08  -1.31887605273938E-18
      2.33267389402399E-09
      0.00000000000000E+00  -1.84843044314380E-11   0.00000000000000E+00  -3.43710269039172E-13   1.18118512115265E-22
      1.84846070866188E-08   1.84842633763499E-08  -3.17752823723525E-19  -4.67447155902616E-01  -4.67447155895865E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.75087131645761E-09   0.00000000000000E+00  -6.75087131645761E-09
      1.54316445265903E-18  -7.53684734859953E-03  -3.84002943366591E-03   0.00000000000000E+00   1.92020878298924E-12
      1.78911558597931E-22  -1.17353122686754E-08  -1.17333920598923E-08  -1.22541162893550E-18
      2.35267389402399E-09
      0.00000000000000E+00  -1.75453756829655E-11   0.00000000000000E+00  -2.29400068643401E-12   7.52075498096731E-23
      1.75477149272457E-08   1.75454209265593E-08  -2.91322019318352E-19  -4.78980208106487E-01  -4.78980208100881E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.60597820568081E-09   0.00000000000000E+00  -5.60597820568081E-09
      1.43104488854541E-18  -7.26423487793359E-03  -3.50249485005639E-03   0.00000000000000E+00   1.30290097619146E-12
      1.11564143324126E-22  -1.19407456218547E-08  -1.19394427208784E-08  -1.13972286922706E-18
      2.37267389402399E-09
      0.00000000000000E+00  -1.46065277817990E-11   0.00000000000000E+00  -7.23209589946115E-12   4.42879419044596E-23
      1.46137325783457E-08   1.46065004824463E-08  -2.80301714655528E-19  -4.83773647363920E-01  -4.83773647361379E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.54049170382986E-09   0.00000000000000E+00  -2.54049170382986E-09
      1.38023505446881E-18  -6.85666072494120E-03  -3.05504199596130E-03   0.00000000000000E+00   4.54883307701429E-13
      6.35040758481992E-23  -1.20664636619243E-08  -1.20660087786165E-08  -1.09993333981328E-18
      2.39267389402399E-09
      0.00000000000000E+00  -8.93713584345281E-12   0.00000000000000E+00  -1.39767871428391E-11   2.36712638161919E-23
      8.95111833388571E-09   8.93714154674289E-09  -2.97976013947379E-19  -4.76142549094872E-01  -4.76142549098044E-01
      0.00000000000000E+00   0.00000000000000E+00   3.17249109401716E-09   0.00000000000000E+00   3.17249109401716E-09
      1.44368487634915E-18  -6.25637511069832E-03  -2.44101070607527E-03   0.00000000000000E+00  -1.19501501668587E-12
      3.21557620679387E-23  -1.21084376257434E-08  -1.21096326407600E-08  -1.14570886240177E-18
      2.41267389402399E-09
      0.00000000000000E+00  -1.58037239312991E-12   0.00000000000000E+00  -1.81552618097050E-11   8.35369953933900E-24
      1.59856910175393E-09   1.58041383994424E-09  -3.56603632928274E-19  -4.51512331096942E-01  -4.51512331107466E-01
      0.00000000000000E+00   0.00000000000000E+00   1.05236957828469E-08   0.00000000000000E+00   1.05236957828469E-08
      1.65415879200609E-18  -5.56565042277661E-03  -1.75202796888224E-03   0.00000000000000E+00  -3.96545154892567E-12
      8.74865990395714E-24  -1.21001441712422E-08  -1.21041096227911E-08  -1.29755515907782E-18
      2.43267389402399E-09
      0.00000000000000E+00   4.80164286120950E-12   0.00000000000000E+00  -1.58164220862307E-11  -9.10427952201393E-24
     -4.78580629292155E-09  -4.80162271500779E-09  -4.62713612180142E-19  -4.08570323026099E-01  -4.08570323042954E-01
      0.00000000000000E+00   0.00000000000000E+00   1.68541871339891E-08   0.00000000000000E+00   1.68541871339891E-08
      1.99124253468588E-18  -5.05788978980304E-03  -1.26050709475212E-03   0.00000000000000E+00  -8.29653768561181E-12
     -2.05672810137466E-23  -1.20442678812958E-08  -1.20525644189814E-08  -1.52852892250573E-18
      2.45267389402399E-09
      0.00000000000000E+00   7.82076306269532E-12   0.00000000000000E+00  -7.62604121068409E-12  -2.95961053085300E-23
     -7.81318839018472E-09  -7.82081443139543E-09  -6.11658942023009E-19  -3.49204626769359E-01  -3.49204626789077E-01
      0.00000000000000E+00   0.00000000000000E+00   1.97177093565537E-08   0.00000000000000E+00   1.97177093565537E-08
      2.38559672181695E-18  -5.45167822357286E-03  -1.70334548031621E-03   0.00000000000000E+00  -1.55671769411517E-11
     -5.74778425070148E-23  -1.18813277482172E-08  -1.18968949251584E-08  -1.77393777979394E-18
      2.47267389402399E-09
      0.00000000000000E+00   7.66233089101233E-12   0.00000000000000E+00   9.95712303742790E-14  -4.00007623995109E-23
     -7.66247957779866E-09  -7.66238000656833E-09  -7.75705829065533E-19  -2.80188611546702E-01  -2.80188611565591E-01
      0.00000000000000E+00   0.00000000000000E+00   1.88895683351115E-08   0.00000000000000E+00   1.88895683351115E-08
      2.76338808851918E-18  -1.02524454195449E-02  -6.71512073672742E-03   0.00000000000000E+00  -2.71286661407080E-11
     -7.58187369361652E-23  -1.12000596624024E-08  -1.12271883285431E-08  -1.98768225945365E-18
      2.49267389402399E-09
      0.00000000000000E+00   6.89799898797130E-12   0.00000000000000E+00   1.50657594751507E-12  -4.27811209385816E-23
     -6.89955617908877E-09  -6.89804960314129E-09  -9.21315235722998E-19  -2.12414187451999E-01  -2.12414187468616E-01
      0.00000000000000E+00   0.00000000000000E+00   1.66168833940357E-08   0.00000000000000E+00   1.66168833940357E-08
      3.09572575639989E-18  -2.48121501701298E-02  -2.17500595741589E-02   0.00000000000000E+00  -4.40570990727833E-11
     -8.33075518582591E-23  -9.67477669182149E-09  -9.71883379089435E-09  -2.17441052067690E-18
      2.51267389402399E-09
      0.00000000000000E+00   5.97789841062629E-12   0.00000000000000E+00   1.81443514900454E-12  -4.45337538474997E-23
     -5.97968611648219E-09  -5.97787168133323E-09  -1.04203159046481E-18  -1.50897031251970E-01  -1.50897031266284E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43139161707422E-08   0.00000000000000E+00   1.43139161707422E-08
      3.38200407981474E-18  -4.72108149552013E-02  -4.45843944443817E-02   0.00000000000000E+00  -6.85549055290981E-11
     -9.16735715247906E-23  -8.26748958387973E-09  -8.33604448940892E-09  -2.33997248934993E-18
      2.53267389402399E-09
      0.00000000000000E+00   4.91378528533989E-12   0.00000000000000E+00   2.11834234983673E-12  -4.60789770623466E-23
     -4.91586562677748E-09  -4.91374728442769E-09  -1.13942239477759E-18  -9.74187743873482E-02  -9.74187743994427E-02
      0.00000000000000E+00   0.00000000000000E+00   1.20944795868948E-08   0.00000000000000E+00   1.20944795868948E-08
      3.62389367155264E-18  -7.49749912959568E-02  -7.27125686686268E-02   0.00000000000000E+00  -9.72274225823913E-11
     -1.00265944794848E-22  -7.08350487988471E-09  -7.18073230246720E-09  -2.48447127677504E-18
      2.54267389402399E-09
      0.00000000000000E+00   4.13485006908285E-12   0.00000000000000E+00   3.31685225055350E-12  -4.67280061045396E-23
     -4.13819982123698E-09  -4.13488296898647E-09  -1.18017124893445E-18  -7.39420962026051E-02  -7.39420962132065E-02
      0.00000000000000E+00   0.00000000000000E+00   1.06014034602729E-08   0.00000000000000E+00   1.06014034602729E-08
      3.72990770615536E-18  -9.04182392671710E-02  -8.83808321956926E-02   0.00000000000000E+00  -1.18344090045289E-10
     -1.04598786602942E-22  -6.34817640124106E-09  -6.46652049128646E-09  -2.54973645722092E-18
      2.55617389402399E-09
      0.00000000000000E+00   3.03482565154831E-12   0.00000000000000E+00   3.59379715127113E-12  -4.73500802457347E-23
     -3.03837156566775E-09  -3.03477776851652E-09  -1.22021874791761E-18  -5.00950777326572E-02  -5.00950777412909E-02
      0.00000000000000E+00   0.00000000000000E+00   8.63371170159100E-09   0.00000000000000E+00   8.63371170159100E-09
      3.84646281412684E-18  -1.13579671351278E-01  -1.11815613987533E-01   0.00000000000000E+00  -1.25670131393233E-10
     -1.10130149619191E-22  -5.47326380168105E-09  -5.59893393307439E-09  -2.62624406620923E-18
      2.57439889402399E-09
      0.00000000000000E+00   1.70335249625079E-12   0.00000000000000E+00   3.35032928040294E-12  -4.77749467079510E-23
     -1.70674156605160E-09  -1.70339123677125E-09  -1.24998689261412E-18  -3.16494423375956E-02  -3.16494423438151E-02
      0.00000000000000E+00   0.00000000000000E+00   6.21945297814065E-09   0.00000000000000E+00   6.21945297814065E-09
      3.95981234465346E-18  -1.47741873363440E-01  -1.46318995967409E-01   0.00000000000000E+00  -1.26132726458164E-10
     -1.16800753541690E-22  -4.38992901491122E-09  -4.51606174136950E-09  -2.70982545203934E-18
      2.59439889402399E-09
      0.00000000000000E+00   8.12917769023819E-13   0.00000000000000E+00   2.08361534968596E-12  -4.79607617627260E-23
     -8.14986466373920E-10  -8.12902851024282E-10  -1.26486821712402E-18  -2.19154694067348E-02  -2.19154694111622E-02
      0.00000000000000E+00   0.00000000000000E+00   4.42749321709944E-09   0.00000000000000E+00   4.42749321709944E-09
      4.04836220899545E-18  -1.85373046228258E-01  -1.84234192874187E-01   0.00000000000000E+00  -1.25220321371549E-10
     -1.23274928910110E-22  -3.48937004470340E-09  -3.61459036607508E-09  -2.78349399187143E-18
      2.61439889402399E-09
      0.00000000000000E+00   4.18903846403530E-13   0.00000000000000E+00   9.25471137747759E-13  -4.80374722587292E-23
     -4.19873542932345E-10  -4.18948071794645E-10  -1.27190324450199E-18  -1.69975079266250E-02  -1.69975079299841E-02
      0.00000000000000E+00   0.00000000000000E+00   3.35910425220332E-09   0.00000000000000E+00   3.35910425220332E-09
      4.11554429403951E-18  -2.19763753057229E-01  -2.18837391259576E-01   0.00000000000000E+00  -1.21872064188173E-10
     -1.28968212476463E-22  -2.81828411622041E-09  -2.94015618040871E-09  -2.84364104953753E-18
      2.63439889402399E-09
      0.00000000000000E+00   2.65155756318130E-13   0.00000000000000E+00   3.58532933760168E-13  -4.80754469380155E-23
     -2.65492448388078E-10  -2.65133915454366E-10  -1.27589111356916E-18  -1.40868380410971E-02  -1.40868380437095E-02
      0.00000000000000E+00   0.00000000000000E+00   2.61235336339729E-09   0.00000000000000E+00   2.61235336339729E-09
      4.16779136130746E-18  -2.48566846757359E-01  -2.47827301002921E-01   0.00000000000000E+00  -1.10982301331871E-10
     -1.33746786892216E-22  -2.23623714661094E-09  -2.34721944794295E-09  -2.89190024773830E-18
      2.65439889402399E-09
      0.00000000000000E+00   2.00588906061238E-13   0.00000000000000E+00   1.48428999165617E-13  -4.80970539161578E-23
     -2.00777349607785E-10  -2.00628920608667E-10  -1.27861206674358E-18  -1.21275685243019E-02  -1.21275685263021E-02
      0.00000000000000E+00   0.00000000000000E+00   2.00022475615779E-09   0.00000000000000E+00   2.00022475615779E-09
      4.20779585643061E-18  -2.70849244441140E-01  -2.70282240032886E-01   0.00000000000000E+00  -9.23298046042303E-11
     -1.37486114872594E-22  -1.70726603094469E-09  -1.79959583554906E-09  -2.92918378968703E-18
      2.67439889402399E-09
      0.00000000000000E+00   1.68443248038604E-13   0.00000000000000E+00   7.36107438523666E-14  -4.81100013931503E-23
     -1.68510871672512E-10  -1.68437260928708E-10  -1.28070684873913E-18  -1.07171957591000E-02  -1.07171957605902E-02
      0.00000000000000E+00   0.00000000000000E+00   1.49020877362184E-09   0.00000000000000E+00   1.49020877362184E-09
      4.23760003190305E-18  -2.86873848848955E-01  -2.86457395602579E-01   0.00000000000000E+00  -6.97520351283484E-11
     -1.40194609414270E-22  -1.25201947756471E-09  -1.32177151269320E-09  -2.95689318316392E-18
      2.69439889402399E-09
      0.00000000000000E+00   1.50074300597099E-13   0.00000000000000E+00   4.22137378205607E-14  -4.81178774348173E-23
     -1.50107660686126E-10  -1.50065446948354E-10  -1.28244730888186E-18  -9.66339462884940E-03  -9.66339462992606E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07666811425033E-09   0.00000000000000E+00   1.07666811425033E-09
      4.25913339418806E-18  -2.97466132730418E-01  -2.97174188994171E-01   0.00000000000000E+00  -4.70921264162099E-11
     -1.41979245890195E-22  -8.79510540885543E-10  -9.26602667301895E-10  -2.97668608530620E-18
      2.71439889402399E-09
      0.00000000000000E+00   1.34277005797404E-13   0.00000000000000E+00   3.81664405038278E-14  -4.81208125341386E-23
     -1.34301106418548E-10  -1.34262939978092E-10  -1.28388193706757E-18  -8.88931056241007E-03  -8.88931056319866E-03
      0.00000000000000E+00   0.00000000000000E+00   7.88593028251251E-10   0.00000000000000E+00   7.88593028251251E-10
      4.27490525475308E-18  -3.04307654055617E-01  -3.04101498210178E-01   0.00000000000000E+00  -2.99864877470886E-11
     -1.43103015804604E-22  -6.24343600525972E-10  -6.54330088273204E-10  -2.99102331768551E-18
      2.73439889402399E-09
      0.00000000000000E+00   1.16550971516351E-13   0.00000000000000E+00   4.55531360975279E-14  -4.81178427383233E-23
     -1.16588977158315E-10  -1.16543424022265E-10  -1.28497171686951E-18  -8.35042591862451E-03  -8.35042591929299E-03
      0.00000000000000E+00   0.00000000000000E+00   6.68478787561206E-10   0.00000000000000E+00   6.68478787561206E-10
      4.28827483050431E-18  -3.09908809752483E-01  -3.09734916472516E-01   0.00000000000000E+00  -2.38756840200762E-11
     -1.43984129806597E-22  -5.28059679518725E-10  -5.51935363538945E-10  -3.00330311363480E-18
      2.75439889402399E-09
      0.00000000000000E+00   1.05988826737486E-13   0.00000000000000E+00   2.92710744271147E-14  -4.81121471501564E-23
     -1.06063512247309E-10  -1.06034241172930E-10  -1.28586099725280E-18  -7.92515387277790E-03  -7.92515387342293E-03
      0.00000000000000E+00   0.00000000000000E+00   6.45037643618624E-10   0.00000000000000E+00   6.45037643618624E-10
      4.30117558337668E-18  -3.15477967536838E-01  -3.15308148767727E-01   0.00000000000000E+00  -2.37582895411308E-11
     -1.44843459112336E-22  -5.15245112904339E-10  -5.39003402445614E-10  -3.01531458612388E-18
      2.77439889402399E-09
      0.00000000000000E+00   9.76309556516009E-14   0.00000000000000E+00   2.50394292518148E-14  -4.81041831898985E-23
     -9.76766594254630E-11  -9.76516199962593E-11  -1.28659282024690E-18  -7.57398152198874E-03  -7.57398152264934E-03
      0.00000000000000E+00   0.00000000000000E+00   6.60598329148403E-10   0.00000000000000E+00   6.60598329148403E-10
      4.31438754995965E-18  -3.21521830610658E-01  -3.21344467631555E-01   0.00000000000000E+00  -2.62310708380891E-11
     -1.45773079421214E-22  -5.36715638314052E-10  -5.62946709152287E-10  -3.02779472971275E-18
      2.78439889402399E-09
      0.00000000000000E+00   8.82627924564332E-14   0.00000000000000E+00   5.20663100559999E-14  -4.80983423011001E-23
     -8.82923557305266E-11  -8.82402894205187E-11  -1.28686737936023E-18  -7.44149814090882E-03  -7.44149814160454E-03
      0.00000000000000E+00   0.00000000000000E+00   6.95723113003851E-10   0.00000000000000E+00   6.95723113003851E-10
      4.32134478108969E-18  -3.24947250824251E-01  -3.24755855046373E-01   0.00000000000000E+00  -3.02610309560173E-11
     -1.46300463321507E-22  -5.77221792627074E-10  -6.07482823583237E-10  -3.03447740172945E-18
      2.79789889402399E-09
      0.00000000000000E+00   7.21899634451160E-14   0.00000000000000E+00   6.69261686749128E-14  -4.80867034283298E-23
     -7.22460079210567E-11  -7.21790817524299E-11  -1.28702746541142E-18  -7.33430487545848E-03  -7.33430487631832E-03
      0.00000000000000E+00   0.00000000000000E+00   8.59835895944734E-10   0.00000000000000E+00   8.59835895944734E-10
      4.33295256568494E-18  -3.31568393835990E-01  -3.31320227886338E-01   0.00000000000000E+00  -4.52496833316191E-11
     -1.47344944656961E-22  -7.42407130860563E-10  -7.87656814192330E-10  -3.04592510027352E-18
      2.81612389402399E-09
      0.00000000000000E+00   6.28218002499483E-14   0.00000000000000E+00   3.50017372112630E-14  -4.80693455637535E-23
     -6.28255643989512E-11  -6.27905626617880E-11  -1.28708634279764E-18  -7.18967374565357E-03  -7.18967374673496E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08139433165116E-09   0.00000000000000E+00   1.08139433165116E-09
      4.35266097737928E-18  -3.43802247724970E-01  -3.43481314030725E-01   0.00000000000000E+00  -6.51772974894262E-11
     -1.49335547039963E-22  -9.53426471499763E-10  -1.01860376898934E-09  -3.06557463458165E-18
      2.83612389402399E-09
      0.00000000000000E+00   6.67711239498719E-14   0.00000000000000E+00  -1.41453590249361E-15  -4.80533448355340E-23
     -6.67671844613770E-11  -6.67685989973276E-11  -1.28724817305971E-18  -6.91977546353513E-03  -6.91977546473127E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19614085302367E-09   0.00000000000000E+00   1.19614085302367E-09
      4.37658379443976E-18  -3.58885486116640E-01  -3.58529650903097E-01   0.00000000000000E+00  -7.71446485166304E-11
     -1.51858429573260E-22  -1.05222760550958E-09  -1.12937225402637E-09  -3.08933562138005E-18
      2.85612389402399E-09
      0.00000000000000E+00   7.99967661077558E-14   0.00000000000000E+00  -2.70716557618915E-14  -4.80432662918330E-23
     -7.99591976367135E-11  -7.99862692925235E-11  -1.28769126861665E-18  -6.47452781120603E-03  -6.47452781241929E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21325398523100E-09   0.00000000000000E+00   1.21325398523100E-09
      4.40084887414437E-18  -3.73928913159397E-01  -3.73571850245650E-01   0.00000000000000E+00  -8.11693555165072E-11
     -1.54444619119069E-22  -1.05209836042184E-09  -1.13326771593850E-09  -3.11315760552772E-18
      2.87612389402399E-09
      0.00000000000000E+00   9.61614398562805E-14   0.00000000000000E+00  -3.80573467913261E-14  -4.80396659924483E-23
     -9.61859695434639E-11  -9.62240268903032E-11  -1.28847466539842E-18  -5.83548524501903E-03  -5.83548524621603E-03
      0.00000000000000E+00   0.00000000000000E+00   1.19700099628376E-09   0.00000000000000E+00   1.19700099628376E-09
      4.42478889407005E-18  -3.88357913996779E-01  -3.88011088058829E-01   0.00000000000000E+00  -8.21025550005267E-11
     -1.56995787941478E-22  -1.01867441439275E-09  -1.10077696939343E-09  -3.13631422867163E-18
      2.89612389402399E-09
      0.00000000000000E+00   1.04978534628203E-13   0.00000000000000E+00  -2.11417142957622E-14  -4.80391983293003E-23
     -1.04918638517542E-10  -1.04939780231886E-10  -1.28944681858268E-18  -5.09707791863237E-03  -5.09707791979748E-03
      0.00000000000000E+00   0.00000000000000E+00   1.16510802830044E-09   0.00000000000000E+00   1.16510802830044E-09
      4.44809105463606E-18  -4.02130088133585E-01  -4.01796057262470E-01   0.00000000000000E+00  -8.20077373828919E-11
     -1.59485283601731E-22  -9.78160510685496E-10  -1.06016824806855E-09  -3.15864423605338E-18
      2.91612389402399E-09
      0.00000000000000E+00   9.57022161702429E-14   0.00000000000000E+00   2.44128871817345E-14  -4.80347815899031E-23
     -9.57110314038138E-11  -9.56866185166801E-11  -1.29024810358023E-18  -4.47462740122249E-03  -4.47462740233273E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11024177542811E-09   0.00000000000000E+00   1.11024177542811E-09
      4.47029589014462E-18  -4.15358868048037E-01  -4.15039209054025E-01   0.00000000000000E+00  -8.09862832550376E-11
     -1.61891274696179E-22  -9.33568873656329E-10  -1.01455515691153E-09  -3.18004778656439E-18
      2.93612389402399E-09
      0.00000000000000E+00   4.78511080851214E-14   0.00000000000000E+00   1.27496891685798E-13  -4.80116382249110E-23
     -4.79706906661683E-11  -4.78431937745305E-11  -1.29010843439059E-18  -4.42964124059776E-03  -4.42964124159766E-03
      0.00000000000000E+00   0.00000000000000E+00   9.99904608068187E-10   0.00000000000000E+00   9.99904608068187E-10
      4.49029398230598E-18  -4.28195342565401E-01  -4.27895374520639E-01   0.00000000000000E+00  -7.75907012569637E-11
     -1.64151018413143E-22  -8.74470713036395E-10  -9.52061414293523E-10  -3.20018554791539E-18
      2.95612389402399E-09
      0.00000000000000E+00  -2.35306216725684E-13   0.00000000000000E+00   7.54847246111112E-13  -4.78750836493146E-23
      2.34587999088759E-10   2.35342846334822E-10  -1.28433594625811E-18  -7.78038739948812E-03  -7.78038740000507E-03
      0.00000000000000E+00   0.00000000000000E+00   5.16945744751182E-10   0.00000000000000E+00   5.16945744751182E-10
      4.50063289720101E-18  -4.41049547348009E-01  -4.40812526285368E-01   0.00000000000000E+00  -5.75285658479065E-11
     -1.65794795157037E-22  -6.94760025237954E-10  -7.52288591086026E-10  -3.21629695094290E-18
      2.97612389402399E-09
      0.00000000000000E+00  -1.05547971998890E-12   0.00000000000000E+00   2.20853190778655E-12  -4.74207424064492E-23
      1.05331009076671E-09   1.05551862267445E-09  -1.26226097552167E-18  -2.07973806580369E-02  -2.07973806572181E-02
      0.00000000000000E+00   0.00000000000000E+00  -8.18763756676104E-10   0.00000000000000E+00  -8.18763756676104E-10
      4.48425762206749E-18  -4.54659394101009E-01  -4.54584815417469E-01   0.00000000000000E+00   1.23324014571345E-12
     -1.65736125268861E-22  -2.37988106143831E-10  -2.36754865998284E-10  -3.22199664654582E-18
      2.99612389402399E-09
      0.00000000000000E+00  -1.82844502832744E-12   0.00000000000000E+00   2.19219932684604E-12  -4.67122076295568E-23
      1.82624782180134E-09   1.82844002112814E-09  -1.22501715159642E-18  -4.23208417095210E-02  -4.23208417074685E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.05250026865515E-09   0.00000000000000E+00  -2.05250026865515E-09
      4.44320761669439E-18  -4.68764363513564E-01  -4.68834986409431E-01   0.00000000000000E+00   5.37451836705355E-11
     -1.64156843101901E-22   1.70315063856479E-10   2.24060247526850E-10  -3.21819046509797E-18
      3.01612389402399E-09
      0.00000000000000E+00  -2.43122203862044E-12   0.00000000000000E+00   1.81039889309311E-12  -4.58352165655569E-23
      2.42945698596561E-09   2.43126738485866E-09  -1.17651819131728E-18  -6.94662148791928E-02  -6.94662148762398E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.95305180320046E-09   0.00000000000000E+00  -2.95305180320046E-09
      4.38414658063038E-18  -4.82927307006689E-01  -4.83091744048288E-01   0.00000000000000E+00   8.70526922360021E-11
     -1.61589159589948E-22   4.34731726106049E-10   5.21784418341890E-10  -3.20762838931309E-18
      3.02612389402399E-09
      0.00000000000000E+00  -2.84397228763107E-12   0.00000000000000E+00   2.36173706311055E-12  -4.53367050627207E-23
      2.84158045118196E-09   2.84394218824503E-09  -1.14856651116285E-18  -8.46911745512062E-02  -8.46911745476785E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.52771600537981E-09   0.00000000000000E+00  -3.52771600537981E-09
      4.34886942057658E-18  -4.89988783545162E-01  -4.90204265265653E-01   0.00000000000000E+00   1.04594858101999E-10
     -1.60035568034622E-22   5.79178959032809E-10   6.83773817134649E-10  -3.20030290941373E-18
      3.03287389402399E-09
      0.00000000000000E+00  -3.15753022045756E-12   0.00000000000000E+00   2.62233676211707E-12  -4.49728626684837E-23
      3.15493980552172E-09   3.15756214228379E-09  -1.12789055712789E-18  -9.57589878892405E-02  -9.57589878852989E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.94162561236769E-09   0.00000000000000E+00  -3.94162561236769E-09
      4.32226344769309E-18  -4.94754747863744E-01  -4.95001833185251E-01   0.00000000000000E+00   1.16179853617951E-10
     -1.58863717550432E-22   6.67883616466524E-10   7.84063470084316E-10  -3.19437289056521E-18
      3.04198639402399E-09
      0.00000000000000E+00  -3.58414902478652E-12   0.00000000000000E+00   2.64798789148921E-12  -4.44315193252184E-23
      3.58154489877122E-09   3.58419288666267E-09  -1.09700859909966E-18  -1.11986350045870E-01  -1.11986350041419E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.45126122750030E-09   0.00000000000000E+00  -4.45126122750030E-09
      4.28170132975750E-18  -5.01158542609240E-01  -5.01431790618737E-01   0.00000000000000E+00   1.29887671923465E-10
     -1.57081201265626E-22   7.37180668914305E-10   8.67068340837613E-10  -3.18469273065783E-18
      3.05428826902399E-09
      0.00000000000000E+00  -4.20685634305356E-12   0.00000000000000E+00   2.82811698678884E-12  -4.35181864861447E-23
      4.20401596438740E-09   4.20684408137414E-09  -1.05093046502236E-18  -1.35553249978843E-01  -1.35553249973822E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.02127466145140E-09   0.00000000000000E+00  -5.02127466145140E-09
      4.21993023653166E-18  -5.09520798459218E-01  -5.09777483638607E-01   0.00000000000000E+00   1.42075247898565E-10
     -1.54411594677759E-22   6.72355332178782E-10   8.14430580077193E-10  -3.16899977150930E-18
      3.07089580027399E-09
      0.00000000000000E+00  -5.28878734735822E-12   0.00000000000000E+00   3.50948719824547E-12  -4.09832324346022E-23
      5.28528484867123E-09   5.28879433586944E-09  -9.84797575397367E-19  -1.68111256657628E-01  -1.68111256652156E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.47203975622437E-09   0.00000000000000E+00  -5.47203975622437E-09
      4.12905316527892E-18  -5.19371364172958E-01  -5.19429240470500E-01   0.00000000000000E+00   1.46453332356719E-10
     -1.50593292334664E-22   3.67920879983742E-11   1.83245420354943E-10  -3.14425558988155E-18
      3.09089580027399E-09
      0.00000000000000E+00  -7.83839725223916E-12   0.00000000000000E+00   6.51875381606982E-12  -3.04778581302038E-23
      7.83188338251663E-09   7.83840213633267E-09  -9.05719040793734E-19  -2.05278145511364E-01  -2.05278145505617E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.74661904648051E-09   0.00000000000000E+00  -5.74661904648051E-09
      4.01412078434931E-18  -5.26310158885209E-01  -5.25651400661769E-01   0.00000000000000E+00   1.45959496535240E-10
     -1.45753391483179E-22  -2.23774258638725E-09  -2.09178308985215E-09  -3.10840174355557E-18
      3.11089580027399E-09
      0.00000000000000E+00  -1.29903359411582E-11   0.00000000000000E+00   1.28670818305996E-11  -6.52231975820152E-25
      1.29774527204100E-08   1.29903198022406E-08  -8.33214420555377E-19  -2.37939004367238E-01  -2.37939004361257E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.98136881597421E-09   0.00000000000000E+00  -5.98136881597421E-09
      3.89449340802982E-18  -5.23400735094516E-01  -5.21193010525148E-01   0.00000000000000E+00   1.49928866576510E-10
     -1.40284301733080E-22  -7.15887985284275E-09  -7.00895098626638E-09  -3.06127898747444E-18
      3.13089580027399E-09
      0.00000000000000E+00  -2.08148646380790E-11   0.00000000000000E+00   1.94172329397537E-11   4.88677880990632E-23
      2.07954417332828E-08   2.08148589662226E-08  -7.72669789088408E-19  -2.64539026268324E-01  -2.64539026262069E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.25501508520228E-09   0.00000000000000E+00  -6.25501508520228E-09
      3.76939310632578E-18  -5.05430021948124E-01  -5.00843566541197E-01   0.00000000000000E+00   1.60194940067445E-10
     -1.33590867502991E-22  -1.47200388210876E-08  -1.45598438810202E-08  -2.99672331723737E-18
      3.15089580027399E-09
      0.00000000000000E+00  -2.92902969875896E-11   0.00000000000000E+00   2.10159982499903E-11   1.02517417823655E-22
      2.92692856370230E-08   2.92903016352731E-08  -7.26709621251725E-19  -2.84750166894120E-01  -2.84750166887568E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.55162599951069E-09   0.00000000000000E+00  -6.55162599951069E-09
      3.63836058633556E-18  -4.69679566435959E-01  -4.62516398429196E-01   0.00000000000000E+00   1.67866725035008E-10
     -1.25361379196388E-22  -2.29065423607974E-08  -2.27386756357625E-08  -2.91165096508384E-18
      3.17089580027399E-09
      0.00000000000000E+00  -3.55455665045826E-11   0.00000000000000E+00   1.55333979456689E-11   1.43310565032880E-22
      3.55300465371403E-08   3.55455799350861E-08  -6.95243943855622E-19  -2.99091890971040E-01  -2.99091890964202E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.83823493653416E-09   0.00000000000000E+00  -6.83823493653416E-09
      3.50159588760488E-18  -4.16435201598006E-01  -4.07391444678974E-01   0.00000000000000E+00   1.65637713795113E-10
     -1.15945927562040E-22  -2.88729827123468E-08  -2.87073449985518E-08  -2.80635194374926E-18
      3.19089580027399E-09
      0.00000000000000E+00  -3.75797437442549E-11   0.00000000000000E+00   5.08550831807551E-12   1.59470536778010E-22
      3.75746209616081E-08   3.75797064699263E-08  -6.76897185562035E-19  -3.08339924453987E-01  -3.08339924446882E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.10510903027579E-09   0.00000000000000E+00  -7.10510903027579E-09
      3.35949370699936E-18  -3.48194042494592E-01  -3.38593259165476E-01   0.00000000000000E+00   1.52407741610001E-10
     -1.06241251048232E-22  -3.06270051812605E-08  -3.04745974396507E-08  -2.68259652143733E-18
      3.21089580027399E-09
      0.00000000000000E+00  -3.58938417480735E-11   0.00000000000000E+00  -4.13861074630233E-12   1.52461041219152E-22
      3.58980011245581E-08   3.58938625138120E-08  -6.67813383607894E-19  -3.14084231532097E-01  -3.14084231524801E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29566910663402E-09   0.00000000000000E+00  -7.29566910663402E-09
      3.21358032486668E-18  -2.72750510154312E-01  -2.63740661088678E-01   0.00000000000000E+00   1.24458554772826E-10
     -9.65096340174464E-23  -2.87226519619506E-08  -2.85981934071779E-08  -2.54576694125879E-18
      3.23089580027399E-09
      0.00000000000000E+00  -3.33347718352602E-11   0.00000000000000E+00  -6.31867190219750E-12   1.36261884385738E-22
      3.33410671684940E-08   3.33347484965919E-08  -6.61141868006470E-19  -3.18972577762455E-01  -3.18972577755134E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32075174003382E-09   0.00000000000000E+00  -7.32075174003382E-09
      3.06716529006601E-18  -2.01969339535858E-01  -1.93773489442043E-01   0.00000000000000E+00   8.60719108094908E-11
     -8.68712977785420E-23  -2.61000686673675E-08  -2.60139967565581E-08  -2.40602342205954E-18
      3.25089580027399E-09
      0.00000000000000E+00  -3.12164648163058E-11   0.00000000000000E+00  -5.23292768063820E-12   1.19535437023720E-22
      3.12216630343306E-08   3.12164301066501E-08  -6.53784946623406E-19  -3.24167805615980E-01  -3.24167805608722E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25746837305424E-09   0.00000000000000E+00  -7.25746837305424E-09
      2.92201592260492E-18  -1.39381437652892E-01  -1.31832939825057E-01   0.00000000000000E+00   5.67653993142860E-11
     -8.05454617707395E-23  -2.40157271329100E-08  -2.39589617335958E-08  -2.26823097598152E-18
      3.25589580027399E-09
      0.00000000000000E+00  -3.04513063106299E-11   0.00000000000000E+00  -7.53818378789327E-12   1.14625943398293E-22
      3.04588167353461E-08   3.04512785515583E-08  -6.52290212503349E-19  -3.25333906427434E-01  -3.25333906420157E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27702921700655E-09   0.00000000000000E+00  -7.27702921700655E-09
      2.88563077651989E-18  -1.24215109153622E-01  -1.16913821296799E-01   0.00000000000000E+00   4.87886342124044E-11
     -7.91400905567200E-23  -2.32230379687640E-08  -2.31742493345517E-08  -2.23334056401654E-18
      3.26264580027399E-09
      0.00000000000000E+00  -2.96945056760399E-11   0.00000000000000E+00  -5.54934599640857E-12   1.08666539668506E-22
      2.97000770093726E-08   2.96945276633763E-08  -6.49795615856512E-19  -3.27101422511408E-01  -3.27101422504177E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.23174760000361E-09   0.00000000000000E+00  -7.23174760000361E-09
      2.83681648021987E-18  -1.05108530799898E-01  -9.80313763890587E-02   0.00000000000000E+00   4.10117765963072E-11
     -7.65459756626235E-23  -2.25037918399690E-08  -2.24627800633727E-08  -2.18702086436335E-18
      3.27175830027399E-09
      0.00000000000000E+00  -2.87185634984727E-11   0.00000000000000E+00  -5.28438068723064E-12   1.02228580461223E-22
      2.87238774433435E-08   2.87185930626564E-08  -6.45389607654917E-19  -3.29867508973024E-01  -3.29867508965872E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.15298021504369E-09   0.00000000000000E+00  -7.15298021504369E-09
      2.77163494801028E-18  -8.18246307023437E-02  -7.50301148516717E-02   0.00000000000000E+00   3.46388320992141E-11
     -6.94094545026698E-23  -2.16002516797116E-08  -2.15656128476124E-08  -2.12624534035536E-18
      3.27790923777399E-09
      0.00000000000000E+00  -2.78455792713152E-11   0.00000000000000E+00  -6.98806219236043E-12   9.86174490418057E-23
      2.78525245721716E-08   2.78455365099793E-08  -6.41736206819199E-19  -3.31966105987245E-01  -3.31966105980159E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.08669279459892E-09   0.00000000000000E+00  -7.08669279459892E-09
      2.72804514354900E-18  -6.76233498482660E-02  -6.10830028396322E-02   0.00000000000000E+00   3.13693626536888E-11
     -5.98835672864315E-23  -2.07902130780340E-08  -2.07588437153804E-08  -2.08630893672980E-18
      3.28621300339899E-09
      0.00000000000000E+00  -2.65378939029544E-11   0.00000000000000E+00  -7.75766842755164E-12   9.63622627590206E-23
      2.65456113445473E-08   2.65378536761199E-08  -6.34646753127120E-19  -3.35547957401700E-01  -3.35547957394758E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.94135638084293E-09   0.00000000000000E+00  -6.94135638084293E-09
      2.67040574704288E-18  -5.17713151127948E-02  -4.55971659640867E-02   0.00000000000000E+00   2.69481674167252E-11
     -3.83676982605289E-23  -1.96234454626936E-08  -1.95964972952769E-08  -2.03575899391576E-18
      3.29742308699274E-09
      0.00000000000000E+00  -2.46656389349790E-11   0.00000000000000E+00  -8.21930453439507E-12   9.89674756251808E-23
      2.46738590681388E-08   2.46656397636045E-08  -6.20442481567621E-19  -3.41967422289704E-01  -3.41967422283004E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.69938873754561E-09   0.00000000000000E+00  -6.69938873754561E-09
      2.59530503926797E-18  -3.67323746978760E-02  -3.10718432260276E-02   0.00000000000000E+00   2.17410214076595E-11
      3.95733120311246E-24  -1.79879920474664E-08  -1.79662510260587E-08  -1.97486255770035E-18
      3.31255669984430E-09
      0.00000000000000E+00  -2.26467997664203E-11   0.00000000000000E+00  -6.55497235368729E-12   1.10226355942489E-22
      2.26533952407496E-08   2.26468402683960E-08  -5.94976223184174E-19  -3.52751090539129E-01  -3.52751090532719E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.40988228422553E-09   0.00000000000000E+00  -6.40988228422553E-09
      2.49830036235441E-18  -2.52663823854996E-02  -2.01506775818336E-02   0.00000000000000E+00   1.53970802694152E-11
      6.36863048469312E-23  -1.62523550644399E-08  -1.62369579841704E-08  -1.90332413917024E-18
      3.33255669984430E-09
      0.00000000000000E+00  -2.10801122391343E-11   0.00000000000000E+00  -3.83310378113597E-12   1.28158373338111E-22
      2.10839465696096E-08   2.10801134658286E-08  -5.57317905554740E-19  -3.68271188954598E-01  -3.68271188948431E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.16765660274759E-09   0.00000000000000E+00  -6.16765660274759E-09
      2.37494723029946E-18  -1.79748402010119E-02  -1.32764296294546E-02   0.00000000000000E+00   9.83576589695651E-12
      1.27478143499707E-22  -1.49222926289780E-08  -1.49124568630810E-08  -1.81762932474472E-18
      3.35255669984430E-09
      0.00000000000000E+00  -2.00974653957510E-11   0.00000000000000E+00  -2.39050703980817E-12   1.40378780320253E-22
      2.00998632652278E-08   2.00974727581881E-08  -5.19792992216090E-19  -3.83639562489799E-01  -3.83639562483782E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.01705530016169E-09   0.00000000000000E+00  -6.01705530016169E-09
      2.25460612429622E-18  -1.41939690654758E-02  -9.75769918909800E-03   0.00000000000000E+00   6.91520837487918E-12
      1.70530722886707E-22  -1.40873326664015E-08  -1.40804174580265E-08  -1.73481313208014E-18
      3.37255669984430E-09
      0.00000000000000E+00  -1.93509513717282E-11   0.00000000000000E+00  -1.80952754426461E-12   1.42703477372552E-22
      1.93528071474085E-08   1.93509976198644E-08  -4.83972309753428E-19  -3.98363466814078E-01  -3.98363466808175E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.90271797955237E-09   0.00000000000000E+00  -5.90271797955237E-09
      2.13655176470518E-18  -1.19091086296732E-02  -7.67199954775433E-03   0.00000000000000E+00   5.46913658174339E-12
      1.90785153014180E-22  -1.34537487768939E-08  -1.34482796403119E-08  -1.65257945495175E-18
      3.39255669984430E-09
      0.00000000000000E+00  -1.86999558744013E-11   0.00000000000000E+00  -1.57705891548889E-12   1.34911704842039E-22
      1.87014780503464E-08   1.86999009914311E-08  -4.50094668503449E-19  -4.12387068226426E-01  -4.12387068220623E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.80278044809600E-09   0.00000000000000E+00  -5.80278044809600E-09
      2.02049615574326E-18  -1.03617793646596E-02  -6.29831871846378E-03   0.00000000000000E+00   4.65779761481522E-12
      1.89882097831550E-22  -1.29017783409501E-08  -1.28971205433351E-08  -1.57040148723981E-18
      3.41255669984430E-09
      0.00000000000000E+00  -1.81367639458447E-11   0.00000000000000E+00  -1.36292358410616E-12   1.19168344331425E-22
      1.81381707447432E-08   1.81368078211592E-08  -4.17938204684928E-19  -4.25793260419361E-01  -4.25793260413648E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.71311030294090E-09   0.00000000000000E+00  -5.71311030294090E-09
      1.90623394968444E-18  -9.25427675566024E-03  -5.33997328332078E-03   0.00000000000000E+00   4.03738541696781E-12
      1.72346484483539E-22  -1.24277349036354E-08  -1.24236975182183E-08  -1.48829574499951E-18
      3.43255669984430E-09
      0.00000000000000E+00  -1.76612837413214E-11   0.00000000000000E+00  -1.14921305103082E-12   9.86535551647525E-23
      1.76624728100884E-08   1.76613235970375E-08  -3.87204139069418E-19  -4.38680692077869E-01  -4.38680692072236E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.63280392555519E-09   0.00000000000000E+00  -5.63280392555519E-09
      1.79357787117334E-18  -8.43367498004162E-03  -4.64387673532188E-03   0.00000000000000E+00   3.52616870101452E-12
      1.44259551724080E-22  -1.20320458401836E-08  -1.20285196714824E-08  -1.40637373210392E-18
      3.45255669984430E-09
      0.00000000000000E+00  -1.73096102425537E-11   0.00000000000000E+00  -8.45802384512793E-13   7.67299148579040E-23
      1.73104859665585E-08   1.73096401641741E-08  -3.57422007743560E-19  -4.51226095196376E-01  -4.51226095190776E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.60020638072963E-09   0.00000000000000E+00  -5.60020638072963E-09
      1.68157374355874E-18  -7.81565388382906E-03  -4.12638716618862E-03   0.00000000000000E+00   3.10592280966978E-12
      1.11891871919818E-22  -1.17125397062542E-08  -1.17094337834444E-08  -1.32415173581518E-18
      3.47255669984430E-09
      0.00000000000000E+00  -1.73912602139312E-11   0.00000000000000E+00   2.21086628684716E-13   5.63963752567284E-23
      1.73910168568699E-08   1.73912379434987E-08  -3.26882577417124E-19  -4.64155237370939E-01  -4.64155237365077E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.86189829024270E-09   0.00000000000000E+00  -5.86189829024270E-09
      1.56433577775389E-18  -7.40449573172141E-03  -3.77196895315670E-03   0.00000000000000E+00   2.67693815159888E-12
      8.06237625949722E-23  -1.15320165914075E-08  -1.15293396532559E-08  -1.23745320033677E-18
      3.49255669984430E-09
      0.00000000000000E+00  -1.77776510233633E-11   0.00000000000000E+00   9.73998231122192E-13   3.91606229166951E-23
      1.77766745972399E-08   1.77776485954710E-08  -2.95024494069372E-19  -4.77738181324954E-01  -4.77738181318677E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.27668056203078E-09   0.00000000000000E+00  -6.27668056203078E-09
      1.43880216651327E-18  -7.14957370171402E-03  -3.52598403712933E-03   0.00000000000000E+00   2.26587328297534E-12
      5.35647523820348E-23  -1.15032339067234E-08  -1.15009680334404E-08  -1.14377767244390E-18
      3.50255669984430E-09
      0.00000000000000E+00  -1.79672185609596E-11   0.00000000000000E+00   9.57356722489408E-13   3.11759641278414E-23
      1.79662497725296E-08   1.79672071292521E-08  -2.79025887356388E-19  -4.84614318002902E-01  -4.84614317996423E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.47896291264297E-09   0.00000000000000E+00  -6.47896291264297E-09
      1.37401253738685E-18  -7.03963842516373E-03  -3.42005675966317E-03   0.00000000000000E+00   2.18198525551059E-12
      4.09012424950356E-23  -1.14904262018647E-08  -1.14882442166091E-08  -1.09498665003046E-18
      3.51605669984430E-09
      0.00000000000000E+00  -1.81275794721240E-11   0.00000000000000E+00   6.08538806563522E-13   2.27407889469790E-23
      1.81269590028980E-08   1.81275675417045E-08  -2.57470067058211E-19  -4.93930946091995E-01  -4.93930946085395E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.59920348708349E-09   0.00000000000000E+00  -6.59920348708349E-09
      1.28492329031122E-18  -6.91929362798669E-03  -3.28707023842442E-03   0.00000000000000E+00   1.90765231727774E-12
      2.76506056618948E-23  -1.15302717069384E-08  -1.15283640546211E-08  -1.02745322325301E-18
      3.53428169984430E-09
      0.00000000000000E+00  -1.82861034885442E-11   0.00000000000000E+00   4.50965488790529E-13   1.49428478303520E-23
      1.82856518786174E-08   1.82861028441062E-08  -2.28936047836817E-19  -5.06390418774697E-01  -5.06390418768028E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66806439791256E-09   0.00000000000000E+00  -6.66806439791256E-09
      1.16339781665926E-18  -6.79303303064808E-03  -3.13255491770189E-03   0.00000000000000E+00   1.69643357489123E-12
      1.55077187299792E-23  -1.16197348797685E-08  -1.16180384461936E-08  -9.34461768822447E-19
      3.53928169984430E-09
      0.00000000000000E+00  -1.83953068810839E-11   0.00000000000000E+00   1.09075413445865E-12   1.29729788359609E-23
      1.83941973484156E-08   1.83952881025501E-08  -2.21212423415415E-19  -5.09798709890386E-01  -5.09798709883649E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.73694502857794E-09   0.00000000000000E+00  -6.73694502857794E-09
      1.12971309151637E-18  -6.77696617312256E-03  -3.10378848473497E-03   0.00000000000000E+00   1.46796745313471E-12
      1.23890669738550E-23  -1.16598110414253E-08  -1.16583430739722E-08  -9.08500668100957E-19
      3.54603169984430E-09
      0.00000000000000E+00  -1.85497897290670E-11   0.00000000000000E+00   1.14836693317864E-12   1.08492529243439E-23
      1.85486504308540E-08   1.85497987977872E-08  -2.10842868265355E-19  -5.14394695506044E-01  -5.14394695499271E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.77326162009432E-09   0.00000000000000E+00  -6.77326162009432E-09
      1.08399357558074E-18  -6.78432579084320E-03  -3.07390814745310E-03   0.00000000000000E+00   9.67181115906639E-13
      9.07236532723144E-24  -1.17775043588086E-08  -1.17765371776927E-08  -8.73150707315380E-19
      3.55514419984430E-09
      0.00000000000000E+00  -1.86548601084324E-11   0.00000000000000E+00   5.90103640221916E-13   8.73445249325650E-24
      1.86542358552447E-08   1.86548259588850E-08  -1.97177713610686E-19  -5.20483804784469E-01  -5.20483804777750E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.71942972063528E-09   0.00000000000000E+00  -6.71942972063528E-09
      1.02276277225145E-18  -6.78776702696582E-03  -3.02729716516480E-03   0.00000000000000E+00   8.98553286515695E-13
      5.83614706145333E-24  -1.19362947915363E-08  -1.19353962382498E-08  -8.25585058640762E-19
      3.56744607484430E-09
      0.00000000000000E+00  -1.84543630471083E-11   0.00000000000000E+00  -7.82361248284640E-13   6.77088559186413E-24
      1.84551544823875E-08   1.84543721211392E-08  -1.80056326930967E-19  -5.28160684532993E-01  -5.28160684526616E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.37714406058426E-09   0.00000000000000E+00  -6.37714406058426E-09
      9.44311943161147E-19  -6.73915907748193E-03  -2.93400161297843E-03   0.00000000000000E+00   1.03673976766843E-12
      2.99079363045622E-24  -1.20782648003227E-08  -1.20772280605550E-08  -7.64255616230179E-19
      3.58405360609430E-09
      0.00000000000000E+00  -1.73217337478651E-11   0.00000000000000E+00  -3.34600873662122E-12   5.00907783017031E-24
      1.73250850386988E-08   1.73217390299621E-08  -1.61834876913878E-19  -5.36365677942559E-01  -5.36365677937389E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.17055551383863E-09   0.00000000000000E+00  -5.17055551383863E-09
      8.58441780885211E-19  -6.56884828540054E-03  -2.74038881585473E-03   0.00000000000000E+00   1.02827508745563E-12
      7.50955345131572E-25  -1.21522117912110E-08  -1.21511835161235E-08  -6.96606903971334E-19
      3.60405360609430E-09
      0.00000000000000E+00  -1.40121086425919E-11   0.00000000000000E+00  -8.14973509050789E-12   3.34821204134173E-24
      1.40202592177637E-08   1.40121094826732E-08  -1.54343809299396E-19  -5.39610069311600E-01  -5.39610069309750E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.85071448185671E-09   0.00000000000000E+00  -1.85071448185671E-09
      8.21427491248077E-19  -6.19961724111093E-03  -2.36793937848946E-03   0.00000000000000E+00   4.16142562189012E-13
     -8.85215538255914E-25  -1.21618111433786E-08  -1.21613950008164E-08  -6.67083681948682E-19
      3.62405360609430E-09
      0.00000000000000E+00  -7.91710819202601E-12   0.00000000000000E+00  -1.50231151075438E-11   1.47713516007289E-24
      7.93216363737996E-09   7.91714052227242E-09  -1.72770246032654E-19  -5.30887515762939E-01  -5.30887515767173E-01
      0.00000000000000E+00   0.00000000000000E+00   4.23413633806456E-09   0.00000000000000E+00   4.23413633806456E-09
      9.06110218009368E-19  -5.61578093478783E-03  -1.78728997405055E-03   0.00000000000000E+00  -9.52899045952537E-13
     -2.39660302776356E-24  -1.21503239612909E-08  -1.21512768603368E-08  -7.33339971976712E-19
      3.64405360609430E-09
      0.00000000000000E+00   1.15908058355899E-13   0.00000000000000E+00  -1.98152512638492E-11  -1.34348896569679E-24
     -9.61231832168755E-11  -1.15938434480726E-10  -2.28261196646840E-19  -5.05763667333523E-01  -5.05763667345771E-01
      0.00000000000000E+00   0.00000000000000E+00   1.22487495320331E-08   0.00000000000000E+00   1.22487495320331E-08
      1.15108520865003E-18  -4.86936525197056E-03  -1.04669215473581E-03   0.00000000000000E+00  -3.09537585793333E-12
     -5.19797495600374E-24  -1.21297157216946E-08  -1.21328110975525E-08  -9.22824012003192E-19
      3.66405360609430E-09
      0.00000000000000E+00   7.54954555372149E-12   0.00000000000000E+00  -1.83735772759002E-11  -7.05380492018740E-24
     -7.53108651613226E-09  -7.54946009340816E-09  -3.28246314120162E-19  -4.62871873312922E-01  -4.62871873332569E-01
      0.00000000000000E+00   0.00000000000000E+00   1.96469899855461E-08   0.00000000000000E+00   1.96469899855461E-08
      1.54402500836095E-18  -4.11941404624072E-03  -3.07861739021207E-04   0.00000000000000E+00  -6.22480240504629E-12
     -1.34321245594433E-23  -1.20913050897328E-08  -1.20975298921378E-08  -1.21577869424079E-18
      3.68405360609430E-09
      0.00000000000000E+00   1.17229704124315E-11   0.00000000000000E+00  -1.04292903689832E-11  -2.01542318486493E-23
     -1.17125684792758E-08  -1.17229977696448E-08  -4.75523783058483E-19  -4.03336074314206E-01  -4.03336074337971E-01
      0.00000000000000E+00   0.00000000000000E+00   2.37655197672769E-08   0.00000000000000E+00   2.37655197672769E-08
      2.01933540370649E-18  -3.53980326538299E-03   2.54418055887210E-04   0.00000000000000E+00  -1.13256382858125E-11
     -3.67344689355861E-23  -1.20311963593464E-08  -1.20425219976322E-08  -1.54381162064801E-18
      3.70405360609430E-09
      0.00000000000000E+00   1.13500807793689E-11   0.00000000000000E+00   6.73164440545589E-13  -3.59487130056553E-23
     -1.13507149767921E-08  -1.13500418123516E-08  -6.57932469373491E-19  -3.30460323200643E-01  -3.30460323223890E-01
      0.00000000000000E+00   0.00000000000000E+00   2.32467216997713E-08   0.00000000000000E+00   2.32467216997713E-08
      2.48426983770192E-18  -3.78215909895328E-03  -3.38921702085057E-05   0.00000000000000E+00  -2.04271510508551E-11
     -6.67708260950120E-23  -1.18762527363688E-08  -1.18966798874197E-08  -1.82633736832843E-18
      3.72405360609430E-09
      0.00000000000000E+00   8.76703939014447E-12   0.00000000000000E+00   6.01464700757283E-12  -4.15548637139153E-23
     -8.77309562569991E-09  -8.76708097869237E-09  -8.34364376132246E-19  -2.54041637486604E-01  -2.54041637506377E-01
      0.00000000000000E+00   0.00000000000000E+00   1.97733275352483E-08   0.00000000000000E+00   1.97733275352483E-08
      2.87973638840688E-18  -9.98353396692614E-03  -6.51581948387055E-03   0.00000000000000E+00  -3.39233862657309E-11
     -7.83076960783277E-23  -1.09723231702901E-08  -1.10062465565559E-08  -2.04537201227464E-18
      3.74405360609430E-09
      0.00000000000000E+00   7.02869404901761E-12   0.00000000000000E+00   3.85680916580031E-12  -4.35419610258242E-23
     -7.03253859061570E-09  -7.02868178144994E-09  -9.77727474640149E-19  -1.84745866595913E-01  -1.84745866612312E-01
      0.00000000000000E+00   0.00000000000000E+00   1.63992855083541E-08   0.00000000000000E+00   1.63992855083541E-08
      3.20772209857397E-18  -2.67051215672931E-02  -2.37527459337613E-02   0.00000000000000E+00  -5.29874006828335E-11
     -8.59519475694322E-23  -9.31761632622125E-09  -9.37060372690416E-09  -2.22999462393381E-18
      3.75405360609430E-09
      0.00000000000000E+00   6.19446830096164E-12   0.00000000000000E+00   3.60801652309802E-12  -4.45311271879343E-23
     -6.19807093302715E-09  -6.19446291650409E-09  -1.04020336243088E-18  -1.52385161809926E-01  -1.52385161824608E-01
      0.00000000000000E+00   0.00000000000000E+00   1.46819920485072E-08   0.00000000000000E+00   1.46819920485072E-08
      3.35454201905904E-18  -3.76920030121410E-02  -3.50178479129440E-02   0.00000000000000E+00  -7.29224999497619E-11
     -9.05709098690461E-23  -8.41460663205326E-09  -8.48752913200311E-09  -2.31433865662816E-18
      3.76755360609430E-09
      0.00000000000000E+00   5.37815227666114E-12   0.00000000000000E+00   2.45469209036549E-12  -4.56697976343419E-23
     -5.38061244727320E-09  -5.37815775518288E-09  -1.11241346996705E-18  -1.13153821794735E-01  -1.13153821807769E-01
      0.00000000000000E+00   0.00000000000000E+00   1.30338978814007E-08   0.00000000000000E+00   1.30338978814007E-08
      3.53049964045795E-18  -5.53487617251157E-02  -5.29366758461477E-02   0.00000000000000E+00  -9.09702733628031E-11
     -9.64895488411412E-23  -7.56476985285492E-09  -7.65574012621781E-09  -2.41808617049090E-18
      3.78577860609430E-09
      0.00000000000000E+00   4.28299563019860E-12   0.00000000000000E+00   2.43861223241406E-12  -4.69076287608569E-23
     -4.28542874568414E-09  -4.28299013345177E-09  -1.18930036847107E-18  -6.90850518134902E-02  -6.90850518244255E-02
      0.00000000000000E+00   0.00000000000000E+00   1.09352030157888E-08   0.00000000000000E+00   1.09352030157888E-08
      3.72979371542070E-18  -8.30631237315400E-02  -8.09672168378983E-02   0.00000000000000E+00  -1.12025505073848E-10
     -1.04327595274737E-22  -6.54018737726313E-09  -6.65221288233709E-09  -2.54049334694963E-18
      3.79077860609430E-09
      0.00000000000000E+00   3.70464932000280E-12   0.00000000000000E+00   5.15835244214011E-12  -4.71853569029147E-23
     -3.70979006013432E-09  -3.70463170769223E-09  -1.20748594856461E-18  -5.83223544460477E-02  -5.83223544559157E-02
      0.00000000000000E+00   0.00000000000000E+00   9.86799667321872E-09   0.00000000000000E+00   9.86799667321872E-09
      3.77913369878679E-18  -9.12261241896826E-02  -8.92842277477831E-02   0.00000000000000E+00  -1.26543109168729E-10
     -1.06502263923766E-22  -6.03682185635765E-09  -6.16336496552649E-09  -2.57164775022218E-18
      3.79752860609430E-09
      0.00000000000000E+00   2.97512657236341E-12   0.00000000000000E+00   4.89387199758890E-12  -4.74790303094341E-23
     -2.98002307793602E-09  -2.97512920593848E-09  -1.22709403952851E-18  -4.65122459299576E-02  -4.65122459385522E-02
      0.00000000000000E+00   0.00000000000000E+00   8.59466760728609E-09   0.00000000000000E+00   8.59466760728609E-09
      3.83714770513597E-18  -1.03067038662283E-01  -1.01296485210236E-01   0.00000000000000E+00  -1.28222563764188E-10
     -1.09304777780494E-22  -5.49131583758337E-09  -5.61953840134767E-09  -2.61005366560746E-18
      3.80664110609430E-09
      0.00000000000000E+00   2.10012176098731E-12   0.00000000000000E+00   4.41832341696936E-12  -4.77416045211627E-23
     -2.10455364410027E-09  -2.10013532068335E-09  -1.24557986069361E-18  -3.51256458989034E-02  -3.51256459059578E-02
      0.00000000000000E+00   0.00000000000000E+00   7.05441191267653E-09   0.00000000000000E+00   7.05441191267653E-09
      3.90143103369024E-18  -1.20228642242538E-01  -1.18667693045574E-01   0.00000000000000E+00  -1.26983173685264E-10
     -1.12822091295938E-22  -4.82729341830792E-09  -4.95427659199329E-09  -2.65585117299662E-18
      3.81894298109430E-09
      0.00000000000000E+00   1.26093639712213E-12   0.00000000000000E+00   3.17820346431064E-12  -4.79342375325678E-23
     -1.26415084186399E-09  -1.26097263839973E-09  -1.26021427134153E-18  -2.58050746070026E-02  -2.58050746125141E-02
      0.00000000000000E+00   0.00000000000000E+00   5.51152841445901E-09   0.00000000000000E+00   5.51152841445901E-09
      3.96923316730386E-18  -1.44493564896526E-01  -1.43154337015372E-01   0.00000000000000E+00  -1.25072908616756E-10
     -1.17165580727015E-22  -4.12548286744253E-09  -4.25055577605941E-09  -2.70901889596233E-18
      3.83555051234430E-09
      0.00000000000000E+00   6.66241723703399E-13   0.00000000000000E+00   1.67882090480260E-12  -4.80524591009371E-23
     -6.67928928997471E-10  -6.66250108092716E-10  -1.27011568529744E-18  -1.91340259977713E-02  -1.91340260020465E-02
      0.00000000000000E+00   0.00000000000000E+00   4.27520231426268E-09   0.00000000000000E+00   4.27520231426268E-09
      4.04023372333805E-18  -1.77046266398797E-01  -1.75909188156736E-01   0.00000000000000E+00  -1.24627594404341E-10
     -1.22524526126419E-22  -3.48432461176544E-09  -3.60895220616990E-09  -2.77011803804061E-18
      3.85555051234430E-09
      0.00000000000000E+00   3.58102630372147E-13   0.00000000000000E+00   7.24202910608045E-13  -4.81117868925430E-23
     -3.58784304069468E-10  -3.58060101158908E-10  -1.27591262401364E-18  -1.48982534573404E-02  -1.48982534607354E-02
      0.00000000000000E+00   0.00000000000000E+00   3.39504201026264E-09   0.00000000000000E+00   3.39504201026264E-09
      4.10813456354330E-18  -2.13354209294480E-01  -2.12397340614272E-01   0.00000000000000E+00  -1.23953920193473E-10
     -1.28370270369211E-22  -2.91302798891020E-09  -3.03698190910381E-09  -2.83222193952966E-18
      3.87555051234430E-09
      0.00000000000000E+00   2.28050482486289E-13   0.00000000000000E+00   3.06339279060502E-13  -4.81372809705953E-23
     -2.28318800749739E-10  -2.28012461470726E-10  -1.27914121387785E-18  -1.23752059212735E-02  -1.23752059239985E-02
      0.00000000000000E+00   0.00000000000000E+00   2.72504444058185E-09   0.00000000000000E+00   2.72504444058185E-09
      4.16263545235494E-18  -2.44638050594321E-01  -2.43851302816266E-01   0.00000000000000E+00  -1.17503933377745E-10
     -1.33457470532117E-22  -2.37952804573319E-09  -2.49703197911107E-09  -2.88349423847709E-18
      3.89555051234430E-09
      0.00000000000000E+00   1.72300727001320E-13   0.00000000000000E+00   1.31881164112616E-13  -4.81487268917735E-23
     -1.72437595303674E-10  -1.72305714139609E-10  -1.28128209702091E-18  -1.06913371625122E-02  -1.06913371646552E-02
      0.00000000000000E+00   0.00000000000000E+00   2.14300644656559E-09   0.00000000000000E+00   2.14300644656559E-09
      4.20549558128625E-18  -2.69696814672012E-01  -2.69075898977171E-01   0.00000000000000E+00  -1.02223079901197E-10
     -1.37595323576474E-22  -1.86847765252468E-09  -1.97070073242602E-09  -2.92421348426535E-18
      3.91555051234430E-09
      0.00000000000000E+00   1.45114684787892E-13   0.00000000000000E+00   6.55620930101831E-14  -4.81531714600895E-23
     -1.45208605534562E-10  -1.45143043441600E-10  -1.28290034630412E-18  -9.49550233978980E-03  -9.49550234142784E-03
      0.00000000000000E+00   0.00000000000000E+00   1.63804418746298E-09   0.00000000000000E+00   1.63804418746298E-09
      4.23825646503551E-18  -2.88501681709144E-01  -2.88031308964218E-01   0.00000000000000E+00  -8.13433157733929E-11
     -1.40731008430339E-22  -1.41155782824781E-09  -1.49290114402135E-09  -2.95535611873139E-18
      3.93555051234430E-09
      0.00000000000000E+00   1.30419526834688E-13   0.00000000000000E+00   3.68117666934842E-14  -4.81538757214749E-23
     -1.30484933935633E-10  -1.30448122168988E-10  -1.28424043686529E-18  -8.61601424422186E-03  -8.61601424543760E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21574288285291E-09   0.00000000000000E+00   1.21574288285291E-09
      4.26257132269257E-18  -3.01676874733889E-01  -3.01334930091297E-01   0.00000000000000E+00  -5.87795305591163E-11
     -1.42925524338636E-22  -1.02651523012471E-09  -1.08529476068397E-09  -2.97833088582728E-18
      3.95555051234430E-09
      0.00000000000000E+00   1.22337189960426E-13   0.00000000000000E+00   2.14431176176378E-14  -4.81527309787589E-23
     -1.22380989110121E-10  -1.22359545992551E-10  -1.28543047689591E-18  -7.95089848617339E-03  -7.95089848704059E-03
      0.00000000000000E+00   0.00000000000000E+00   8.67201566048271E-10   0.00000000000000E+00   8.67201566048271E-10
      4.27991535401353E-18  -3.09989626321226E-01  -3.09754951937026E-01   0.00000000000000E+00  -3.69385279780416E-11
     -1.44283866637115E-22  -7.07903492077497E-10  -7.44842020055682E-10  -2.99448487711762E-18
      3.97555051234430E-09
      0.00000000000000E+00   1.12142424130390E-13   0.00000000000000E+00   2.80046821724846E-14  -4.81483836388385E-23
     -1.12168109093284E-10  -1.12140104411160E-10  -1.28642544697866E-18  -7.48113337454886E-03  -7.48113337518184E-03
      0.00000000000000E+00   0.00000000000000E+00   6.32980803299027E-10   0.00000000000000E+00   6.32980803299027E-10
      4.29257497007951E-18  -3.15144822105738E-01  -3.14980726568270E-01   0.00000000000000E+00  -2.17016148543289E-11
     -1.45079910812673E-22  -4.99139084033241E-10  -5.20840698887715E-10  -3.00614952310085E-18
      3.99555051234430E-09
      0.00000000000000E+00   9.66206635423181E-14   0.00000000000000E+00   4.32444779482371E-14  -4.81387797847440E-23
     -9.67003706991500E-11  -9.66571262212499E-11  -1.28711998657981E-18  -7.19960607474856E-03  -7.19960607531637E-03
      0.00000000000000E+00   0.00000000000000E+00   5.67811712960177E-10   0.00000000000000E+00   5.67811712960177E-10
      4.30393120433872E-18  -3.19801732785517E-01  -3.19653292296068E-01   0.00000000000000E+00  -1.89268173261906E-11
     -1.45762307704422E-22  -4.52227769412793E-10  -4.71154586739130E-10  -3.01681121775891E-18
      4.01555051234430E-09
      0.00000000000000E+00   8.84464819308483E-14   0.00000000000000E+00   2.63324083675053E-14  -4.81273498700114E-23
     -8.85110563549889E-11  -8.84847239466695E-11  -1.28766081254505E-18  -6.98966166495760E-03  -6.98966166554043E-03
      0.00000000000000E+00   0.00000000000000E+00   5.82831579810060E-10   0.00000000000000E+00   5.82831579810060E-10
      4.31558783593492E-18  -3.24928776624550E-01  -3.24773028513719E-01   0.00000000000000E+00  -2.13297773774788E-11
     -1.46514402944579E-22  -4.73017078485772E-10  -4.94346855863398E-10  -3.02792702338987E-18
      4.01558957484430E-09
      0.00000000000000E+00   8.91812398285085E-14   0.00000000000000E+00  -3.80320563476981E-13  -4.81273673817238E-23
     -8.88185078681268E-11  -8.91988284316519E-11  -1.28766189677753E-18  -6.98921820212801E-03  -6.98921820271072E-03
      0.00000000000000E+00   0.00000000000000E+00   5.82704957641130E-10   0.00000000000000E+00   5.82704957641130E-10
      4.31561059784733E-18  -3.24938450185926E-01  -3.24782967047268E-01   0.00000000000000E+00  -2.08337587473737E-11
     -1.46515838331636E-22  -4.72672370400560E-10  -4.93506129148080E-10  -3.02794870106980E-18
      4.01564230921930E-09
      0.00000000000000E+00   9.12018240470741E-14   0.00000000000000E+00  -1.14674964673684E-12  -4.81274861434925E-23
     -9.00550247975752E-11  -9.12017744443601E-11  -1.28766346618149E-18  -6.98851437463373E-03  -6.98851437521584E-03
      0.00000000000000E+00   0.00000000000000E+00   5.82105240517004E-10   0.00000000000000E+00   5.82105240517004E-10
      4.31564129480337E-18  -3.24950822509955E-01  -3.24796159675447E-01   0.00000000000000E+00  -1.96873551731915E-11
     -1.46517692563424E-22  -4.71216110924166E-10  -4.90903466097504E-10  -3.02797782862188E-18
      4.01571350062555E-09
      0.00000000000000E+00   9.46000793237526E-14   0.00000000000000E+00  -1.84768904836624E-12  -4.81277490886169E-23
     -9.27359569815742E-11  -9.45836460299886E-11  -1.28766582575326E-18  -6.98737104035172E-03  -6.98737104093229E-03
      0.00000000000000E+00   0.00000000000000E+00   5.80573235947189E-10   0.00000000000000E+00   5.80573235947189E-10
      4.31568262662847E-18  -3.24966598613136E-01  -3.24813484456352E-01   0.00000000000000E+00  -1.82246361332343E-11
     -1.46520066297860E-22  -4.67764953811909E-10  -4.85989589945290E-10  -3.02801680087521E-18
      4.01580960902399E-09
      0.00000000000000E+00   9.89167819725063E-14   0.00000000000000E+00  -2.08013081425677E-12  -4.81281200893400E-23
     -9.68040390110356E-11  -9.88841698253405E-11  -1.28766942469537E-18  -6.98556817257333E-03  -6.98556817315097E-03
      0.00000000000000E+00   0.00000000000000E+00   5.77640788153120E-10   0.00000000000000E+00   5.77640788153120E-10
      4.31573814275949E-18  -3.24986894764472E-01  -3.24836059965812E-01   0.00000000000000E+00  -1.69486788273124E-11
     -1.46523129692372E-22  -4.61807939495470E-10  -4.78756618322929E-10  -3.02806871806412E-18
      4.01593935536188E-09
      0.00000000000000E+00   1.03233484621260E-13   0.00000000000000E+00  -1.76620292651904E-12  -4.81284815535123E-23
     -1.01463177284895E-10  -1.03229380211462E-10  -1.28767484740179E-18  -6.98286617311217E-03  -6.98286617368513E-03
      0.00000000000000E+00   0.00000000000000E+00   5.72957596472256E-10   0.00000000000000E+00   5.72957596472256E-10
      4.31581248190940E-18  -3.25013361736273E-01  -3.24865371798239E-01   0.00000000000000E+00  -1.61606145244226E-11
     -1.46527139806046E-22  -4.53567601727891E-10  -4.69728216252460E-10  -3.02813763450761E-18
      4.01611451291803E-09
      0.00000000000000E+00   1.06539895160731E-13   0.00000000000000E+00  -1.12209399987443E-12  -4.81286911283944E-23
     -1.05458779224191E-10  -1.06580873224114E-10  -1.28768275573700E-18  -6.97903125606764E-03  -6.97903125663404E-03
      0.00000000000000E+00   0.00000000000000E+00   5.66399011880441E-10   0.00000000000000E+00   5.66399011880441E-10
      4.31591169097613E-18  -3.25048326964256E-01  -3.24903459438350E-01   0.00000000000000E+00  -1.58512405453023E-11
     -1.46532440200303E-22  -4.43966898122621E-10  -4.59818138668070E-10  -3.02822893523913E-18
      4.01635097561884E-09
      0.00000000000000E+00   1.08009410956051E-13   0.00000000000000E+00  -4.40417301709662E-13  -4.81286528723475E-23
     -1.07580589657684E-10  -1.08021006959441E-10  -1.28769377369149E-18  -6.97388116692943E-03  -6.97388116748762E-03
      0.00000000000000E+00   0.00000000000000E+00   5.58183896503697E-10   0.00000000000000E+00   5.58183896503697E-10
      4.31604368064784E-18  -3.25095046042238E-01  -3.24953220472645E-01   0.00000000000000E+00  -1.58496775606837E-11
     -1.46539476303751E-22  -4.34313211973600E-10  -4.50162889534430E-10  -3.02834990695635E-18
      4.01667020026493E-09
      0.00000000000000E+00   1.06999118846769E-13   0.00000000000000E+00   7.49553499729849E-14  -4.81283552852861E-23
     -1.07109531622277E-10  -1.07034576272352E-10  -1.28770833517240E-18  -6.96735527634733E-03  -6.96735527689631E-03
      0.00000000000000E+00   0.00000000000000E+00   5.48985486242637E-10   0.00000000000000E+00   5.48985486242637E-10
      4.31621893034539E-18  -3.25158135942371E-01  -3.25018897532087E-01   0.00000000000000E+00  -1.59993838730874E-11
     -1.46548850971746E-22  -4.25951526101884E-10  -4.41950909975118E-10  -3.02851059517299E-18
      4.01710115353715E-09
      0.00000000000000E+00   1.03692708307298E-13   0.00000000000000E+00   3.51494442918382E-13  -4.81278569438814E-23
     -1.04062859423867E-10  -1.03711364980997E-10  -1.28772656497511E-18  -6.95957702028045E-03  -6.95957702082040E-03
      0.00000000000000E+00   0.00000000000000E+00   5.39950801349961E-10   0.00000000000000E+00   5.39950801349961E-10
      4.31645162391007E-18  -3.25244224940081E-01  -3.25106785854567E-01   0.00000000000000E+00  -1.62277260639398E-11
     -1.46561422324575E-22  -4.20011710305624E-10  -4.36239436369711E-10  -3.02872505893496E-18
      4.01768294045464E-09
      0.00000000000000E+00   9.87330924980913E-14   0.00000000000000E+00   4.18219257344890E-13  -4.81272321771270E-23
     -9.91745501512816E-11  -9.87563308939848E-11  -1.28774829979412E-18  -6.95084893217426E-03  -6.95084893270683E-03
      0.00000000000000E+00   0.00000000000000E+00   5.32570204630422E-10   0.00000000000000E+00   5.32570204630422E-10
      4.31676146628778E-18  -3.25362862412607E-01  -3.25226187381310E-01   0.00000000000000E+00  -1.65362395162462E-11
     -1.46578448259126E-22  -4.17277634222285E-10  -4.33813873738678E-10  -3.02901316649366E-18
      4.01846835279326E-09
      0.00000000000000E+00   9.32224082656397E-14   0.00000000000000E+00   3.54351319049110E-13  -4.81265139390833E-23
     -9.36099840976207E-11  -9.32556327786197E-11  -1.28777333522871E-18  -6.94152761946592E-03  -6.94152761999435E-03
      0.00000000000000E+00   0.00000000000000E+00   5.28428196429585E-10   0.00000000000000E+00   5.28428196429585E-10
      4.31717650031333E-18  -3.25527806512877E-01  -3.25390703243518E-01   0.00000000000000E+00  -1.69708693258277E-11
     -1.46601802325401E-22  -4.18201694322597E-10  -4.35172563648571E-10  -3.02940316508461E-18
      4.01899850612182E-09
      0.00000000000000E+00   9.04670661494139E-14   0.00000000000000E+00   2.71355270714500E-13  -4.81260948070123E-23
     -9.07523634561550E-11  -9.04810081854886E-11  -1.28778876951023E-18  -6.93602993642440E-03  -6.93602993695169E-03
      0.00000000000000E+00   0.00000000000000E+00   5.27283216386720E-10   0.00000000000000E+00   5.27283216386720E-10
      4.31745604126559E-18  -3.25640830998303E-01  -3.25503214212636E-01   0.00000000000000E+00  -1.71891528453477E-11
     -1.46617722913539E-22  -4.19613055359008E-10  -4.36802208204502E-10  -3.02966727175536E-18
      4.01971421311539E-09
      0.00000000000000E+00   8.75280345587730E-14   0.00000000000000E+00   2.11978925422880E-13  -4.81255500510542E-23
     -8.77643415895720E-11  -8.75523626641973E-11  -1.28780752148215E-18  -6.92972895452266E-03  -6.92972895505074E-03
      0.00000000000000E+00   0.00000000000000E+00   5.28086465629624E-10   0.00000000000000E+00   5.28086465629624E-10
      4.31783399644225E-18  -3.25797090447079E-01  -3.25658297754612E-01   0.00000000000000E+00  -1.75986384977632E-11
     -1.46639660835701E-22  -4.22935464469080E-10  -4.40534102966990E-10  -3.03002647496010E-18
      4.01995576422572E-09
      0.00000000000000E+00   8.68851213983203E-14   0.00000000000000E+00   1.55494031504688E-13  -4.81253872553945E-23
     -8.70335191995492E-11  -8.68780251680927E-11  -1.28781368872708E-18  -6.92767614018773E-03  -6.92767614071618E-03
      0.00000000000000E+00   0.00000000000000E+00   5.28453598368846E-10   0.00000000000000E+00   5.28453598368846E-10
      4.31796164499569E-18  -3.25850024888578E-01  -3.25710904050083E-01   0.00000000000000E+00  -1.76567461356878E-11
     -1.46647090800756E-22  -4.23918827067015E-10  -4.41575573202850E-10  -3.03014795626861E-18
      4.02028185822466E-09
      0.00000000000000E+00   8.60585187634526E-14   0.00000000000000E+00   1.37904463598277E-13  -4.81251628835513E-23
     -8.61640125662770E-11  -8.60261081027268E-11  -1.28782173915930E-18  -6.92504809695871E-03  -6.92504809748794E-03
      0.00000000000000E+00   0.00000000000000E+00   5.29219515772283E-10   0.00000000000000E+00   5.29219515772283E-10
      4.31813422030390E-18  -3.25922105945626E-01  -3.25782475343560E-01   0.00000000000000E+00  -1.78111795254750E-11
     -1.46657204022356E-22  -4.25382228143462E-10  -4.43193407669083E-10  -3.03031248114461E-18
      4.02072208512324E-09
      0.00000000000000E+00   8.49563819169622E-14   0.00000000000000E+00   1.30409256233744E-13  -4.81248453877849E-23
     -8.50586938255996E-11  -8.49282845694140E-11  -1.28783212846233E-18  -6.92175185225894E-03  -6.92175185278973E-03
      0.00000000000000E+00   0.00000000000000E+00   5.30788821271784E-10   0.00000000000000E+00   5.30788821271784E-10
      4.31836788782049E-18  -3.26020733656431E-01  -3.25880262660745E-01   0.00000000000000E+00  -1.80784659475555E-11
     -1.46671042999800E-22  -4.27782070758349E-10  -4.45860536706051E-10  -3.03053575935816E-18
      4.02131639143631E-09
      0.00000000000000E+00   8.36705555960569E-14   0.00000000000000E+00   1.11966576834568E-13  -4.81244116895772E-23
     -8.37915317792800E-11  -8.36795652024936E-11  -1.28784542020150E-18  -6.91766616309138E-03  -6.91766616362507E-03
      0.00000000000000E+00   0.00000000000000E+00   5.33687912964155E-10   0.00000000000000E+00   5.33687912964155E-10
      4.31868506191638E-18  -3.26156333205733E-01  -3.26014555275044E-01   0.00000000000000E+00  -1.84600467184686E-11
     -1.46690092293857E-22  -4.31548301042847E-10  -4.50008347761462E-10  -3.03083964171488E-18
      4.02211870495896E-09
      0.00000000000000E+00   8.24765740123590E-14   0.00000000000000E+00   8.44769882391944E-14  -4.81238325130702E-23
     -8.25317780241771E-11  -8.24473010359860E-11  -1.28786239069535E-18  -6.91258840100292E-03  -6.91258840154144E-03
      0.00000000000000E+00   0.00000000000000E+00   5.38521966314726E-10   0.00000000000000E+00   5.38521966314726E-10
      4.31911712537220E-18  -3.26343754931170E-01  -3.26200065578155E-01   0.00000000000000E+00  -1.89788308393207E-11
     -1.46716500843340E-22  -4.37095834441418E-10  -4.56074665280885E-10  -3.03125473467685E-18
      4.02266026658675E-09
      0.00000000000000E+00   8.20173503263214E-14   0.00000000000000E+00   4.70637617344448E-14  -4.81234669818161E-23
     -8.20933819087307E-11  -8.20463181470443E-11  -1.28787363563326E-18  -6.90921492916543E-03  -6.90921492970723E-03
      0.00000000000000E+00   0.00000000000000E+00   5.41794711496731E-10   0.00000000000000E+00   5.41794711496731E-10
      4.31941054059808E-18  -3.26471726533832E-01  -3.26326879651871E-01   0.00000000000000E+00  -1.92450092179609E-11
     -1.46734581650986E-22  -4.40503384132293E-10  -4.59748393350400E-10  -3.03153690496482E-18
      4.02339137478426E-09
      0.00000000000000E+00   8.14662819030762E-14   0.00000000000000E+00   4.65806117606229E-14  -4.81229532146397E-23
     -8.15097350056142E-11  -8.14631543939017E-11  -1.28788840283084E-18  -6.90481341921357E-03  -6.90481341976011E-03
      0.00000000000000E+00   0.00000000000000E+00   5.46549340989322E-10   0.00000000000000E+00   5.46549340989322E-10
      4.31981012730162E-18  -3.26647795876978E-01  -3.26501267126100E-01   0.00000000000000E+00  -1.96963973966984E-11
     -1.46759543575986E-22  -4.45389789197784E-10  -4.65086186594629E-10  -3.03192172447078E-18
      4.02388487281759E-09
      0.00000000000000E+00   8.12825924286612E-14   0.00000000000000E+00   2.57613097523318E-14  -4.81226206511227E-23
     -8.13245509943489E-11  -8.12987896846446E-11  -1.28789829547156E-18  -6.90183640893667E-03  -6.90183640948636E-03
      0.00000000000000E+00   0.00000000000000E+00   5.49683048497812E-10   0.00000000000000E+00   5.49683048497812E-10
      4.32008139480501E-18  -3.26767804083747E-01  -3.26620236165507E-01   0.00000000000000E+00  -1.99395846865068E-11
     -1.46776602657635E-22  -4.48444674125267E-10  -4.68384258811921E-10  -3.03218309933345E-18
      4.02455109516257E-09
      0.00000000000000E+00   8.09152134798311E-14   0.00000000000000E+00   3.47362460370055E-14  -4.81221508410930E-23
     -8.09537103918119E-11  -8.09189741458230E-11  -1.28791140831751E-18  -6.89789235054561E-03  -6.89789235109972E-03
      0.00000000000000E+00   0.00000000000000E+00   5.54104945949094E-10   0.00000000000000E+00   5.54104945949094E-10
      4.32045055190147E-18  -3.26932492101864E-01  -3.26783411225683E-01   0.00000000000000E+00  -2.03491116251888E-11
     -1.46800085950629E-22  -4.52836860177332E-10  -4.73185971802668E-10  -3.03253914358395E-18
      4.02545049532830E-09
      0.00000000000000E+00   8.03641450565859E-14   0.00000000000000E+00   3.68247659725066E-14  -4.81215054977695E-23
     -8.04163549876003E-11  -8.03795302216759E-11  -1.28792864540681E-18  -6.89270176356993E-03  -6.89270176413035E-03
      0.00000000000000E+00   0.00000000000000E+00   5.60421107036638E-10   0.00000000000000E+00   5.60421107036638E-10
      4.32095459473802E-18  -3.27159870310721E-01  -3.27008629324158E-01   0.00000000000000E+00  -2.09234469551320E-11
     -1.46832647020352E-22  -4.59118129859459E-10  -4.80041576814737E-10  -3.03302594933121E-18
      4.02666468555204E-09
      0.00000000000000E+00   7.98130766333407E-14   0.00000000000000E+00   3.17142912799759E-14  -4.81206342308571E-23
     -7.98187687914644E-11  -7.97870545002325E-11  -1.28795123288123E-18  -6.88582520981397E-03  -6.88582521038323E-03
      0.00000000000000E+00   0.00000000000000E+00   5.69258332298979E-10   0.00000000000000E+00   5.69258332298979E-10
      4.32164578263988E-18  -3.27475919633292E-01  -3.27321707481195E-01   0.00000000000000E+00  -2.16932045352962E-11
     -1.46878170165343E-22  -4.67778073264118E-10  -4.89471277799561E-10  -3.03369454975864E-18
      4.02830384235408E-09
      0.00000000000000E+00   7.91701634728881E-14   0.00000000000000E+00   2.69541078088048E-14  -4.81194543380211E-23
     -7.91728140923838E-11  -7.91458599846232E-11  -1.28798074310944E-18  -6.87662985485065E-03  -6.87662985543199E-03
      0.00000000000000E+00   0.00000000000000E+00   5.81337248928200E-10   0.00000000000000E+00   5.81337248928200E-10
      4.32259868554574E-18  -3.27918886138598E-01  -3.27760666064299E-01   0.00000000000000E+00  -2.27229001477653E-11
     -1.46942454636087E-22  -4.79468488795312E-10  -5.02191388943225E-10  -3.03461794243629E-18
      4.03051670403684E-09
      0.00000000000000E+00   7.83435608380203E-14   0.00000000000000E+00   2.63680838471817E-14  -4.81178378227773E-23
     -7.83313019939720E-11  -7.83049339101730E-11  -1.28801884804492E-18  -6.86435574981187E-03  -6.86435575040959E-03
      0.00000000000000E+00   0.00000000000000E+00   5.97721571481362E-10   0.00000000000000E+00   5.97721571481362E-10
      4.32392136070823E-18  -3.28546702424452E-01  -3.28383054925199E-01   0.00000000000000E+00  -2.41223544809716E-11
     -1.47034398982940E-22  -4.95294283090717E-10  -5.19416637571836E-10  -3.03590251266330E-18
      4.03350406730856E-09
      0.00000000000000E+00   7.68740450426999E-14   0.00000000000000E+00   3.06855127941703E-14  -4.81155819883732E-23
     -7.69438855046823E-11  -7.69131999919363E-11  -1.28806637080895E-18  -6.84845262649293E-03  -6.84845262711346E-03
      0.00000000000000E+00   0.00000000000000E+00   6.20528291870507E-10   0.00000000000000E+00   6.20528291870507E-10
      4.32577510413643E-18  -3.29451476914438E-01  -3.29280204830188E-01   0.00000000000000E+00  -2.61081354538264E-11
     -1.47168332082327E-22  -5.17506956424236E-10  -5.43615091878210E-10  -3.03770873332748E-18
      4.03753700772539E-09
      0.00000000000000E+00   7.43942371380967E-14   0.00000000000000E+00   3.95247851749561E-14  -4.81123368318635E-23
     -7.43757184536320E-11  -7.43361936685051E-11  -1.28812058970792E-18  -6.82953713314116E-03  -6.82953713379590E-03
      0.00000000000000E+00   0.00000000000000E+00   6.54746433011606E-10   0.00000000000000E+00   6.54746433011606E-10
      4.32841565748889E-18  -3.30792263422254E-01  -3.30609397704380E-01   0.00000000000000E+00  -2.91625731671565E-11
     -1.47369374028608E-22  -5.51247666175572E-10  -5.80410239342876E-10  -3.04029506778098E-18
      4.04298147728811E-09
      0.00000000000000E+00   6.96183108033053E-14   0.00000000000000E+00   5.11361476237893E-14  -4.81074844858646E-23
     -6.97055706521862E-11  -6.96544345046105E-11  -1.28816919260032E-18  -6.81117680394824E-03  -6.81117680466002E-03
      0.00000000000000E+00   0.00000000000000E+00   7.11779091446604E-10   0.00000000000000E+00   7.11779091446604E-10
      4.33229091708765E-18  -3.32874794645415E-01  -3.32672483589131E-01   0.00000000000000E+00  -3.43282442212220E-11
     -1.47686718398844E-22  -6.07796412720733E-10  -6.42124656942103E-10  -3.04412172448734E-18
      4.05033151119778E-09
      0.00000000000000E+00   6.23625765639107E-14   0.00000000000000E+00   5.88553796133909E-14  -4.81000166503208E-23
     -6.24156966655521E-11  -6.23568412859869E-11  -1.28818300727942E-18  -6.80005037164758E-03  -6.80005037245889E-03
      0.00000000000000E+00   0.00000000000000E+00   8.11304159185210E-10   0.00000000000000E+00   8.11304159185210E-10
      4.33825403016872E-18  -3.36318969674278E-01  -3.36083000312365E-01   0.00000000000000E+00  -4.33259446437930E-11
     -1.48222840155332E-22  -7.05621373255169E-10  -7.48947317899110E-10  -3.05007102288930E-18
      4.06025405697583E-09
      0.00000000000000E+00   5.49231528501010E-14   0.00000000000000E+00   4.81548204357871E-14  -4.80889572537020E-23
     -5.49422880953781E-11  -5.48941332749904E-11  -1.28813147352616E-18  -6.79257672650101E-03  -6.79257672746287E-03
      0.00000000000000E+00   0.00000000000000E+00   9.61865483907913E-10   0.00000000000000E+00   9.61865483907913E-10
      4.34779818446512E-18  -3.42207056603715E-01  -3.41921296170463E-01   0.00000000000000E+00  -5.68506853025318E-11
     -1.49162631285560E-22  -8.50120665330211E-10  -9.06971350632892E-10  -3.05966671093896E-18
      4.07364949377621E-09
      0.00000000000000E+00   5.28107238943279E-14   0.00000000000000E+00   1.87529048889329E-14  -4.80743898287351E-23
     -5.28431483054087E-11  -5.28243954005678E-11  -1.28804205488608E-18  -6.74684205133421E-03  -6.74684205245306E-03
      0.00000000000000E+00   0.00000000000000E+00   1.11884751167268E-09   0.00000000000000E+00   1.11884751167268E-09
      4.36278563559699E-18  -3.51789980338560E-01  -3.51454105098162E-01   0.00000000000000E+00  -7.12936076319816E-11
     -1.50731582068147E-22  -9.94729508639994E-10  -1.06602311627213E-09  -3.07474358071091E-18
      4.09173333345671E-09
      0.00000000000000E+00   5.85050976011945E-14   0.00000000000000E+00  -5.75673914624520E-15  -4.80576788598662E-23
     -5.84612185534864E-11  -5.84669752926807E-11  -1.28803823502295E-18  -6.57828342074079E-03  -6.57828342194929E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20850416187899E-09   0.00000000000000E+00   1.20850416187899E-09
      4.38464003111363E-18  -3.65837045061316E-01  -3.65474698312731E-01   0.00000000000000E+00  -8.09654153305881E-11
     -1.53089267348483E-22  -1.06907177125540E-09  -1.15003718658614E-09  -3.09660179609068E-18
      4.11173333345671E-09
      0.00000000000000E+00   7.09959818614182E-14   0.00000000000000E+00  -2.38478368851351E-14  -4.80446835856735E-23
     -7.09317046631095E-11  -7.09555525000427E-11  -1.28830123948896E-18  -6.22635169462563E-03  -6.22635169584750E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22187103153628E-09   0.00000000000000E+00   1.22187103153628E-09
      4.40907745174436E-18  -3.81295862799197E-01  -3.80933239126340E-01   0.00000000000000E+00  -8.47931343722299E-11
     -1.55753848461430E-22  -1.06612234466382E-09  -1.15091547903621E-09  -3.12077621225539E-18
      4.13173333345671E-09
      0.00000000000000E+00   8.89975503540934E-14   0.00000000000000E+00  -4.10910704996674E-14  -4.80389776662337E-23
     -8.89488896598119E-11  -8.89899807303596E-11  -1.28894096810889E-18  -5.65888878505866E-03  -5.65888878626677E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20811501487088E-09   0.00000000000000E+00   1.20811501487088E-09
      4.43323975204178E-18  -3.96131337274855E-01  -3.95778729984856E-01   0.00000000000000E+00  -8.59594841994008E-11
     -1.58389363458032E-22  -1.03316554994096E-09  -1.11912503414052E-09  -3.14429878393288E-18
      4.15173333345671E-09
      0.00000000000000E+00   1.03784553044505E-13   0.00000000000000E+00  -3.60958223907298E-14  -4.80387587814399E-23
     -1.03749593322297E-10  -1.03785689144735E-10  -1.28989124625525E-18  -4.91978816501725E-03  -4.91978816620081E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18356688243410E-09   0.00000000000000E+00   1.18356688243410E-09
      4.45691108969046E-18  -4.10260287605506E-01  -4.09920076720303E-01   0.00000000000000E+00  -8.61354314939839E-11
     -1.60970323333904E-22  -9.93645761795262E-10  -1.07978119328941E-09  -3.16701984343521E-18
      4.17173333345671E-09
      0.00000000000000E+00   1.05713292525863E-13   0.00000000000000E+00  -5.17617606940351E-15  -4.80388487875837E-23
     -1.05752648064606E-10  -1.05757824240724E-10  -1.29089480347565E-18  -4.16375730847198E-03  -4.16375730961429E-03
      0.00000000000000E+00   0.00000000000000E+00   1.14230637942713E-09   0.00000000000000E+00   1.14230637942713E-09
      4.47975721727900E-18  -4.23756397085298E-01  -4.23429808001023E-01   0.00000000000000E+00  -8.55052099654541E-11
     -1.63478489016767E-22  -9.51043345220757E-10  -1.03654855518637E-09  -3.18886241380335E-18
      4.19173333345671E-09
      0.00000000000000E+00   9.33142530028472E-14   0.00000000000000E+00   3.23241925212614E-14  -4.80340766333915E-23
     -9.33297969439544E-11  -9.32974727514812E-11  -1.29166294141313E-18  -3.56274747495996E-03  -3.56274747604322E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08326047112677E-09   0.00000000000000E+00   1.08326047112677E-09
      4.50142242670153E-18  -4.36716929130624E-01  -4.36405018415402E-01   0.00000000000000E+00  -8.40360940070326E-11
     -1.65895439176245E-22  -9.05926904368082E-10  -9.89962998375281E-10  -3.20975948528841E-18
      4.21173333345671E-09
      0.00000000000000E+00   3.61868264597655E-14   0.00000000000000E+00   1.51967562033700E-13  -4.80069278174360E-23
     -3.63237383725189E-11  -3.61717708105332E-11  -1.29130462784972E-18  -3.65191584734873E-03  -3.65191584830589E-03
      0.00000000000000E+00   0.00000000000000E+00   9.57162797912629E-10   0.00000000000000E+00   9.57162797912629E-10
      4.52056568265979E-18  -4.49269211604263E-01  -4.48979033214718E-01   0.00000000000000E+00  -7.93553955700151E-11
     -1.68136292669632E-22  -8.41635631531954E-10  -9.20991027102137E-10  -3.22926105481007E-18
      4.23173333345671E-09
      0.00000000000000E+00  -4.09351993733947E-13   0.00000000000000E+00   1.18300157401872E-12  -4.77999563222182E-23
      4.08117051518661E-10   4.09300053092632E-10  -1.28207871256254E-18  -9.07765624058822E-03  -9.07765624080059E-03
      0.00000000000000E+00   0.00000000000000E+00   2.12370331757587E-10   0.00000000000000E+00   2.12370331757587E-10
      4.52481308929494E-18  -4.61996005822899E-01  -4.61800142104722E-01   0.00000000000000E+00  -4.52793874535719E-11
     -1.69387393763026E-22  -5.76390997396454E-10  -6.21670384850195E-10  -3.24273437673240E-18
      4.25173333345671E-09
      0.00000000000000E+00  -1.31484925786295E-12   0.00000000000000E+00   2.45708491804942E-12  -4.72522199870103E-23
      1.31240966066892E-09   1.31486674558692E-09  -1.25488040946582E-18  -2.50692087267502E-02  -2.50692087254922E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.25796435367720E-09   0.00000000000000E+00  -1.25796435367720E-09
      4.49965380222139E-18  -4.75441344357352E-01  -4.75423437925533E-01   0.00000000000000E+00   2.34715150173295E-11
     -1.68697613396387E-22  -8.03739069268878E-11  -5.69023919097270E-11  -3.24477339275558E-18
      4.26173333345671E-09
      0.00000000000000E+00  -1.81117821773243E-12   0.00000000000000E+00   2.73176653945439E-12  -4.68925269399471E-23
      1.80852455577891E-09   1.81125632231831E-09  -1.23638883801850E-18  -3.57784641266970E-02  -3.57784641246458E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.05125338249784E-09   0.00000000000000E+00  -2.05125338249784E-09
      4.47914126839641E-18  -4.82283463332690E-01  -4.82359109502081E-01   0.00000000000000E+00   5.90756724083688E-11
     -1.67848035079234E-22   1.80921387771592E-10   2.39997060179793E-10  -3.24275243037792E-18
      4.27523333345671E-09
      0.00000000000000E+00  -2.24542013524961E-12   0.00000000000000E+00   1.91048114126764E-12  -4.63302822138665E-23
      2.24352201672996E-09   2.24543249787119E-09  -1.20581017407233E-18  -5.31522597103893E-02  -5.31522597076670E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.72232176102281E-09   0.00000000000000E+00  -2.72232176102281E-09
      4.44238992462261E-18  -4.91589222903104E-01  -4.91739514020662E-01   0.00000000000000E+00   8.63622085850582E-11
     -1.66165816601978E-22   3.90527054566683E-10   4.76889263151575E-10  -3.23657975055028E-18
      4.29345833345671E-09
      0.00000000000000E+00  -2.76131202414429E-12   0.00000000000000E+00   1.73447530790424E-12  -4.54507298327402E-23
      2.75953844658656E-09   2.76127292189442E-09  -1.15619486664391E-18  -8.05024033084776E-02  -8.05024033050306E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.44702542355162E-09   0.00000000000000E+00  -3.44702542355162E-09
      4.37956788627838E-18  -5.04059324755984E-01  -5.04275432539583E-01   0.00000000000000E+00   1.11541684683251E-10
     -1.63208944390506E-22   5.74210816973921E-10   6.85752501657009E-10  -3.22337301963447E-18
      4.29845833345671E-09
      0.00000000000000E+00  -3.05493964899675E-12   0.00000000000000E+00   3.21612429280039E-12  -4.51817495097399E-23
      3.05171071494022E-09   3.05492683923298E-09  -1.14126005991258E-18  -8.85575628380272E-02  -8.85575628341806E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.84653738972669E-09   0.00000000000000E+00  -3.84653738972669E-09
      4.36033519932975E-18  -5.07470088626574E-01  -5.07719552923214E-01   0.00000000000000E+00   1.22453856885935E-10
     -1.62312965487684E-22   6.69156693607626E-10   7.91610550493399E-10  -3.21907513941716E-18
      4.30520833345671E-09
      0.00000000000000E+00  -3.37860050291608E-12   0.00000000000000E+00   2.71172638440200E-12  -4.47967298049118E-23
      3.37589794338552E-09   3.37860966976987E-09  -1.11929325872815E-18  -1.00242017983630E-01  -1.00242017979366E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.26397190193896E-09   0.00000000000000E+00  -4.26397190193896E-09
      4.33155338899166E-18  -5.12078451564500E-01  -5.12357461195100E-01   0.00000000000000E+00   1.34877227549891E-10
     -1.60973426797394E-22   7.50485004619831E-10   8.85362232169560E-10  -3.21226013026350E-18
      4.31432083345671E-09
      0.00000000000000E+00  -3.82395563363538E-12   0.00000000000000E+00   2.75561159321068E-12  -4.42153564429851E-23
      3.82116566678666E-09   3.82392127837983E-09  -1.08672633010808E-18  -1.17230601218155E-01  -1.17230601213391E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.76447315577183E-09   0.00000000000000E+00  -4.76447315577183E-09
      4.28813712735969E-18  -5.18232087579095E-01  -5.18528498265267E-01   0.00000000000000E+00   1.47869384639480E-10
     -1.58974521528349E-22   7.92682492752689E-10   9.40551877392010E-10  -3.20141079725161E-18
      4.32662270845671E-09
      0.00000000000000E+00  -4.45492897825108E-12   0.00000000000000E+00   2.86060159285733E-12  -4.31695563840464E-23
      4.45208248481167E-09   4.45494308640449E-09  -1.03907159516967E-18  -1.41400176901414E-01  -1.41400176896163E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.25145604568935E-09   0.00000000000000E+00  -5.25145604568935E-09
      4.22353437151762E-18  -5.26142852844715E-01  -5.26393907753388E-01   0.00000000000000E+00   1.56456624202342E-10
     -1.56078163215708E-22   6.40056335082686E-10   7.96512959284872E-10  -3.18446277634796E-18
      4.34323023970671E-09
      0.00000000000000E+00  -5.63990977770260E-12   0.00000000000000E+00   3.80601413857501E-12  -3.99207324071056E-23
      5.63609406339357E-09   5.63990007753211E-09  -9.72191240744114E-19  -1.74035840544105E-01  -1.74035840538511E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.59394044767961E-09   0.00000000000000E+00  -5.59394044767961E-09
      4.13063283072215E-18  -5.35096319056079E-01  -5.35082008924484E-01   0.00000000000000E+00   1.56866958123682E-10
     -1.52051564543005E-22  -2.02826587976011E-10  -4.59596298524813E-11  -3.15844158997803E-18
      4.36323023970671E-09
      0.00000000000000E+00  -8.56654232882043E-12   0.00000000000000E+00   7.43624066763888E-12  -2.66551800890855E-23
      8.55914020151545E-09   8.56657644218306E-09  -8.93639624862860E-19  -2.10652051442076E-01  -2.10652051436264E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.81209226510717E-09   0.00000000000000E+00  -5.81209226510717E-09
      4.01439098542000E-18  -5.40297721586492E-01  -5.39430227261438E-01   0.00000000000000E+00   1.55248577556111E-10
     -1.46988347262354E-22  -2.90973275463185E-09  -2.75448417707589E-09  -3.12075136055714E-18
      4.38323023970671E-09
      0.00000000000000E+00  -1.42864488726308E-11   0.00000000000000E+00   1.42582006409419E-11   8.03517552391636E-24
      1.42722635469924E-08   1.42865217476333E-08  -8.22746443403395E-19  -2.42390476323595E-01  -2.42390476317559E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.03661754855034E-09   0.00000000000000E+00  -6.03661754855034E-09
      3.89365863444900E-18  -5.34810150862174E-01  -5.32211535433855E-01   0.00000000000000E+00   1.60018549424176E-10
     -1.41246751228898E-22  -8.40992274850710E-09  -8.24990419908307E-09  -3.07091219104560E-18
      4.40323023970671E-09
      0.00000000000000E+00  -2.25274016080505E-11   0.00000000000000E+00   2.04416515596654E-11   6.04085545283655E-23
      2.25069920474384E-08   2.25274336989981E-08  -7.64399493332149E-19  -2.67955643238029E-01  -2.67955643231720E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.30944558933613E-09   0.00000000000000E+00  -6.30944558933613E-09
      3.76746972266227E-18  -5.13719249191812E-01  -5.08610467679311E-01   0.00000000000000E+00   1.70452385241017E-10
     -1.34219549403878E-22  -1.63884404949028E-08  -1.62179881096620E-08  -3.00307022933012E-18
      4.42323023970671E-09
      0.00000000000000E+00  -3.10132124128656E-11   0.00000000000000E+00   2.10434064325855E-11   1.14411754202017E-22
      3.09921546734093E-08   3.10131980798420E-08  -7.20621759241401E-19  -2.87235814260413E-01  -2.87235814253813E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.59952596591237E-09   0.00000000000000E+00  -6.59952596591237E-09
      3.63547920334403E-18  -4.74908530355513E-01  -4.67217702248614E-01   0.00000000000000E+00   1.76335776930994E-10
     -1.25643791215691E-22  -2.45900078908604E-08  -2.44136721139296E-08  -2.91485744410262E-18
      4.44323023970671E-09
      0.00000000000000E+00  -3.69285645574535E-11   0.00000000000000E+00   1.46945146035804E-11   1.53126505851745E-22
      3.69138999235922E-08   3.69285944381959E-08  -6.90999593960275E-19  -3.00830796758431E-01  -3.00830796751554E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.87661596838631E-09   0.00000000000000E+00  -6.87661596838631E-09
      3.49794688397630E-18  -4.19059254812473E-01  -4.09591889186771E-01   0.00000000000000E+00   1.71361631131697E-10
     -1.15955374454976E-22  -3.02233401009412E-08  -3.00519784698097E-08  -2.80694729001603E-18
      4.46323023970671E-09
      0.00000000000000E+00  -3.84495134056102E-11   0.00000000000000E+00   3.81445495705025E-12   1.65944128154337E-22
      3.84456910122968E-08   3.84495054672541E-08  -6.74149910355244E-19  -3.09489901556497E-01  -3.09489901549360E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.13621726556577E-09   0.00000000000000E+00  -7.13621726556577E-09
      3.35522253866498E-18  -3.48732672991859E-01  -3.38867660054549E-01   0.00000000000000E+00   1.55790281203057E-10
     -1.06058803255857E-22  -3.14690784828912E-08  -3.13132882016882E-08  -2.68107262830974E-18
      4.48323023970671E-09
      0.00000000000000E+00  -3.62847329496288E-11   0.00000000000000E+00  -5.32647218971757E-12   1.55669627165157E-22
      3.62900744853453E-08   3.62847480131558E-08  -6.66219441879270E-19  -3.14789328678581E-01  -3.14789328671260E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32036892587239E-09   0.00000000000000E+00  -7.32036892587239E-09
      3.20881516014754E-18  -2.71848634042624E-01  -2.62723412649408E-01   0.00000000000000E+00   1.25901506569719E-10
     -9.60938731062335E-23  -2.90902805938530E-08  -2.89643790872834E-08  -2.54259571826827E-18
      4.50323023970671E-09
      0.00000000000000E+00  -3.34634463120880E-11   0.00000000000000E+00  -6.97003566501949E-12   1.37376101769797E-22
      3.34704032765022E-08   3.34634332408373E-08  -6.60217605755063E-19  -3.19423912689107E-01  -3.19423912681772E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.33505272502516E-09   0.00000000000000E+00  -7.33505272502516E-09
      3.06211410564703E-18  -2.00449517289799E-01  -1.92217625784248E-01   0.00000000000000E+00   8.60634207582426E-11
     -8.63159368892886E-23  -2.62144439365703E-08  -2.61283805158122E-08  -2.40189649989197E-18
      4.52323023970671E-09
      0.00000000000000E+00  -3.12418139637751E-11   0.00000000000000E+00  -5.48986049133897E-12   1.19606932955846E-22
      3.12473268070423E-08   3.12418369465511E-08  -6.53166699097173E-19  -3.24505797140050E-01  -3.24505797132787E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.26320702341784E-09   0.00000000000000E+00  -7.26320702341784E-09
      2.91684996517868E-18  -1.37745628853066E-01  -1.30190931570203E-01   0.00000000000000E+00   5.63441318768141E-11
     -8.01312626378812E-23  -2.40349740550100E-08  -2.39786299231332E-08  -2.26368326608150E-18
      4.53323023970671E-09
      0.00000000000000E+00  -3.00087065220268E-11   0.00000000000000E+00  -6.07926947211109E-12   1.10472468732187E-22
      3.00147188653427E-08   3.00086395958707E-08  -6.49631537985048E-19  -3.27056175046364E-01  -3.27056175039126E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.23810184024095E-09   0.00000000000000E+00  -7.23810184024095E-09
      2.84446894677627E-18  -1.08778232560881E-01  -1.01604122437923E-01   0.00000000000000E+00   4.38528678778841E-11
     -7.68389362873857E-23  -2.28143906235075E-08  -2.27705377556297E-08  -2.19483740879122E-18
      4.54673023970671E-09
      0.00000000000000E+00  -2.85632540478548E-11   0.00000000000000E+00  -5.19304955801631E-12   1.01305975528427E-22
      2.85685657999314E-08   2.85633727503735E-08  -6.42715576761863E-19  -3.31290982021703E-01  -3.31290982014577E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.12607969778174E-09   0.00000000000000E+00  -7.12607969778174E-09
      2.74826687085621E-18  -7.50773150385828E-02  -6.83232498902376E-02   0.00000000000000E+00   3.36863020026184E-11
     -6.50199193466433E-23  -2.14709793545944E-08  -2.14372930525919E-08  -2.10555129409435E-18
      4.55584273970671E-09
      0.00000000000000E+00  -2.71116479762898E-11   0.00000000000000E+00  -7.84204894621193E-12   9.72396925714413E-23
      2.71195355574054E-08   2.71116935084593E-08  -6.36062562638008E-19  -3.34825212352925E-01  -3.34825212345923E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.00179116143868E-09   0.00000000000000E+00  -7.00179116143868E-09
      2.68446304889760E-18  -5.61200809054586E-02  -4.97841805047776E-02   0.00000000000000E+00   2.89994637778248E-11
     -4.52810877556277E-23  -2.01389018107984E-08  -2.01099023470206E-08  -2.04840048625960E-18
      4.56814461470671E-09
      0.00000000000000E+00  -2.50252110811464E-11   0.00000000000000E+00  -8.34926889753446E-12   9.85010164795347E-23
      2.50335877430189E-08   2.50252384741215E-08  -6.21537876864160E-19  -3.41502157554721E-01  -3.41502157547978E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.74270458235243E-09   0.00000000000000E+00  -6.74270458235243E-09
      2.60151513996358E-18  -3.83084647921512E-02  -3.25482855854466E-02   0.00000000000000E+00   2.27545366227937E-11
     -1.49697869688501E-24  -1.83052884283918E-08  -1.82825338917690E-08  -1.97997726309942E-18
      4.58475214595671E-09
      0.00000000000000E+00  -2.27388281931023E-11   0.00000000000000E+00  -6.76622807743739E-12   1.10089559564789E-22
      2.27456215251787E-08   2.27388552971014E-08  -5.94021402000397E-19  -3.53184307701953E-01  -3.53184307695535E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.41836832776228E-09   0.00000000000000E+00  -6.41836832776228E-09
      2.49492188738625E-18  -2.52850864093339E-02  -2.01430644921816E-02   0.00000000000000E+00   1.57310570853543E-11
      6.37829759094592E-23  -1.63362180264245E-08  -1.63204869693391E-08  -1.90090048538586E-18
      4.60475214595671E-09
      0.00000000000000E+00  -2.10957258444596E-11   0.00000000000000E+00  -4.02213760903162E-12   1.27295808427679E-22
      2.10997250518190E-08   2.10957029142101E-08  -5.56474416271966E-19  -3.68656607794535E-01  -3.68656607788367E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.16797449275731E-09   0.00000000000000E+00  -6.16797449275731E-09
      2.37156239753111E-18  -1.79258435798942E-02  -1.32226213679817E-02   0.00000000000000E+00   9.98224658578977E-12
      1.26781873678892E-22  -1.49377106680387E-08  -1.49277284214528E-08  -1.81508798125914E-18
      4.62475214595671E-09
      0.00000000000000E+00  -2.01007718062905E-11   0.00000000000000E+00  -2.42141339992230E-12   1.39134200426048E-22
      2.01031689304405E-08   2.01007475170407E-08  -5.18978494562398E-19  -3.84009662200440E-01  -3.84009662194425E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.01502692862654E-09   0.00000000000000E+00  -6.01502692862654E-09
      2.25126185895858E-18  -1.41571882325290E-02  -9.71924740199847E-03   0.00000000000000E+00   6.91767162339888E-12
      1.69186950435816E-22  -1.40926382600378E-08  -1.40857205884142E-08  -1.73228336439618E-18
      4.64475214595671E-09
      0.00000000000000E+00  -1.93546251612165E-11   0.00000000000000E+00  -1.80833180711928E-12   1.41187654098875E-22
      1.93564685874687E-08   1.93546602556617E-08  -4.83174300714941E-19  -3.98723480582899E-01  -3.98723480576999E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.90021086266690E-09   0.00000000000000E+00  -5.90021086266690E-09
      2.13325764170524E-18  -1.18860563220635E-02  -7.64700336649934E-03   0.00000000000000E+00   5.45216024369386E-12
      1.88651950575024E-22  -1.34599015532386E-08  -1.34544493929947E-08  -1.65008334099030E-18
      4.66475214595672E-09
      0.00000000000000E+00  -1.87043644217872E-11   0.00000000000000E+00  -1.57508448968535E-12   1.33279308630867E-22
      1.87059645461175E-08   1.87043894616280E-08  -4.49308840533997E-19  -4.12738394426189E-01  -4.12738394420389E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.79995586802287E-09   0.00000000000000E+00  -5.79995586802287E-09
      2.01725852434478E-18  -1.03469495948963E-02  -6.28118476491675E-03   0.00000000000000E+00   4.64551017236669E-12
      1.87564245154401E-22  -1.29090791037777E-08  -1.29044335936052E-08  -1.56794968381078E-18
      4.68475214595672E-09
      0.00000000000000E+00  -1.81413561827051E-11   0.00000000000000E+00  -1.36293133286569E-12   1.17543952652018E-22
      1.81426752462198E-08   1.81413123148870E-08  -4.17162922422764E-19  -4.26136250310383E-01  -4.26136250304673E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.70988012570641E-09   0.00000000000000E+00  -5.70988012570641E-09
      1.90306092183065E-18  -9.24421258220109E-03  -5.32747209799195E-03   0.00000000000000E+00   4.02954297116857E-12
      1.69919808856108E-22  -1.24354617321519E-08  -1.24314321891805E-08  -1.48589799940789E-18
      4.70475214595672E-09
      0.00000000000000E+00  -1.76650493755469E-11   0.00000000000000E+00  -1.15119803471203E-12   9.71592942379493E-23
      1.76661931350899E-08   1.76650419370553E-08  -3.86444070289334E-19  -4.39013546041304E-01  -4.39013546035675E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.62860326364415E-09   0.00000000000000E+00  -5.62860326364415E-09
      1.79048885655777E-18  -8.42665913405551E-03  -4.63436580772564E-03   0.00000000000000E+00   3.51997529874716E-12
      1.41958898951068E-22  -1.20399586487101E-08  -1.20364386734112E-08  -1.40404478626844E-18
      4.72475214595672E-09
      0.00000000000000E+00  -1.73031811109492E-11   0.00000000000000E+00  -8.70864874200281E-13   7.54454398633220E-23
      1.73040835638748E-08   1.73032126990007E-08  -3.56725882725553E-19  -4.51528943215210E-01  -4.51528943209622E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58795720884155E-09   0.00000000000000E+00  -5.58795720884155E-09
      1.67872971238094E-18  -7.80893399764101E-03  -4.11783299589086E-03   0.00000000000000E+00   3.10287385065098E-12
      1.09882175346699E-22  -1.17183583640098E-08  -1.17152554901590E-08  -1.32200382965539E-18
      4.74475214595672E-09
      0.00000000000000E+00  -1.73563592137924E-11   0.00000000000000E+00   1.50909830829175E-13   5.53636935595856E-23
      1.73562431470423E-08   1.73563940568732E-08  -3.26369972015475E-19  -4.64378118878683E-01  -4.64378118872855E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.82818028636845E-09   0.00000000000000E+00  -5.82818028636845E-09
      1.56216610665357E-18  -7.39405312244816E-03  -3.76188103349400E-03   0.00000000000000E+00   2.67868163437363E-12
      7.90053737582224E-23  -1.15308924521393E-08  -1.15282137705048E-08  -1.23579613463809E-18
      4.76475214595672E-09
      0.00000000000000E+00  -1.77472504153476E-11   0.00000000000000E+00   9.84609990838871E-13   3.84288101551942E-23
      1.77462468478477E-08   1.77472314578386E-08  -2.94645137218294E-19  -4.77903647826492E-01  -4.77903647820242E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.25034046272520E-09   0.00000000000000E+00  -6.25034046272520E-09
      1.43715929739907E-18  -7.14073091176932E-03  -3.51842576333563E-03   0.00000000000000E+00   2.26208941874859E-12
      5.24128017303719E-23  -1.14991530845321E-08  -1.14968909951133E-08  -1.14251416018077E-18
      4.78475214595672E-09
      0.00000000000000E+00  -1.80229683164446E-11   0.00000000000000E+00   7.02476662765180E-13   2.52325053903049E-23
      1.80222900252152E-08   1.80229925018780E-08  -2.62771799175347E-19  -4.91623497882699E-01  -4.91623497876196E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.50223162939529E-09   0.00000000000000E+00  -6.50223162939529E-09
      1.30711466481116E-18  -6.94012469162219E-03  -3.31029713976109E-03   0.00000000000000E+00   2.02502582127420E-12
      3.16445396478544E-23  -1.15227858983041E-08  -1.15207608724827E-08  -1.04434286563581E-18
      4.78975214595672E-09
      0.00000000000000E+00  -1.81036079957128E-11   0.00000000000000E+00   8.15029141228961E-13   2.20004959735183E-23
      1.81027789505264E-08   1.81035939796676E-08  -2.54887121724548E-19  -4.95049343003507E-01  -4.95049342996903E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.60466312343721E-09   0.00000000000000E+00  -6.60466312343721E-09
      1.27409134919397E-18  -6.88667499588931E-03  -3.26372503885778E-03   0.00000000000000E+00   2.21455693981917E-12
      2.64916715099969E-23  -1.15011454131706E-08  -1.14989308562308E-08  -1.01920422746943E-18
      4.79650214595672E-09
      0.00000000000000E+00  -1.81946261302855E-11   0.00000000000000E+00   6.86734521082510E-13   1.83188797837169E-23
      1.81939341168849E-08   1.81946208514060E-08  -2.44254035339789E-19  -4.99684112404030E-01  -4.99684112397366E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66470953839129E-09   0.00000000000000E+00  -6.66470953839129E-09
      1.22910455980983E-18  -6.84049438556881E-03  -3.20778276120807E-03   0.00000000000000E+00   1.74535597933302E-12
      2.07088368280056E-23  -1.15316566689938E-08  -1.15299113130145E-08  -9.84850524470043E-19
      4.80561464595672E-09
      0.00000000000000E+00  -1.83193512834133E-11   0.00000000000000E+00   6.95076694770619E-13   1.44562895038446E-23
      1.83186176819291E-08   1.83193127586239E-08  -2.29998148437311E-19  -5.05930858096425E-01  -5.05930858089709E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.71541213503891E-09   0.00000000000000E+00  -6.71541213503891E-09
      1.16791036672929E-18  -6.79742480873368E-03  -3.14140069123427E-03   0.00000000000000E+00   1.51992537814411E-12
      1.46795149791772E-23  -1.16054205489632E-08  -1.16039006235850E-08  -9.37912218291980E-19
      4.81176558345672E-09
      0.00000000000000E+00  -1.84383820628342E-11   0.00000000000000E+00   9.72529573166135E-13   1.22627771902371E-23
      1.84374049927448E-08   1.84383775223180E-08  -2.20451731070535E-19  -5.10140436688839E-01  -5.10140436682077E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.76198097905431E-09   0.00000000000000E+00  -6.76198097905431E-09
      1.12631784435094E-18  -6.78490587089460E-03  -3.10604000558920E-03   0.00000000000000E+00   1.29164905758445E-12
      1.12481519599920E-23  -1.16776881923215E-08  -1.16763965432639E-08  -9.05866113280406E-19
      4.82006934908172E-09
      0.00000000000000E+00  -1.85904769476499E-11   0.00000000000000E+00   9.23415307461062E-13   9.99779384529487E-24
      1.85895823760341E-08   1.85905057913416E-08  -2.07711487954410E-19  -5.15789051028971E-01  -5.15789051022191E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.77942716810069E-09   0.00000000000000E+00  -6.77942716810069E-09
      1.07002307007527E-18  -6.78596145394177E-03  -3.06466075404636E-03   0.00000000000000E+00   1.02297141532587E-12
      7.74312981082618E-24  -1.18121015946562E-08  -1.18110786232408E-08  -8.62311582120863E-19
      4.83127943267547E-09
      0.00000000000000E+00  -1.86393383478443E-11   0.00000000000000E+00   2.35837140102774E-13   7.84034961776216E-24
      1.86391078598415E-08   1.86393436969816E-08  -1.91151099092048E-19  -5.23181367150883E-01  -5.23181367144222E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.66071198014807E-09   0.00000000000000E+00  -6.66071198014807E-09
      9.95355931983922E-19  -6.77315637727129E-03  -2.99906410286931E-03   0.00000000000000E+00   9.86494226092109E-13
      4.49947273307569E-24  -1.19796182110598E-08  -1.19786317168337E-08  -8.04204832891874E-19
      4.84641304552703E-09
      0.00000000000000E+00  -1.81742365986254E-11   0.00000000000000E+00  -1.49617865222893E-12   5.91761342752839E-24
      1.81756995550793E-08   1.81742033764271E-08  -1.71335363841854E-19  -5.32091059409510E-01  -5.32091059403444E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.06498675737023E-09   0.00000000000000E+00  -6.06498675737023E-09
      9.03570770448027E-19  -6.68247460013544E-03  -2.86723812661492E-03   0.00000000000000E+00   1.07410484635794E-12
      1.83448185176481E-24  -1.21102907239031E-08  -1.21092166190568E-08  -7.32235406606173E-19
      4.86641304552703E-09
      0.00000000000000E+00  -1.61285787668022E-11   0.00000000000000E+00  -5.02999449510023E-12   4.18068761931586E-24
      1.61335608109204E-08   1.61285308164253E-08  -1.54740608307922E-19  -5.39543544718487E-01  -5.39543544714516E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.97103878434739E-09   0.00000000000000E+00  -3.97103878434739E-09
      8.24149994761080E-19  -6.41900854496054E-03  -2.58856093351679E-03   0.00000000000000E+00   8.23652987189144E-13
     -1.43504322831867E-25  -1.21583156850651E-08  -1.21574920320780E-08  -6.69409386453158E-19
      4.88641304552703E-09
      0.00000000000000E+00  -1.15939285566549E-11   0.00000000000000E+00  -1.11721467115692E-11   2.53555468663724E-24
      1.16050859484698E-08   1.15939138017583E-08  -1.57464993166378E-19  -5.38050071044787E-01  -5.38050071045349E-01
      0.00000000000000E+00   0.00000000000000E+00   5.62575404795368E-10   0.00000000000000E+00   5.62575404795368E-10
      8.35401502856986E-19  -5.95704843944831E-03  -2.12691571656378E-03   0.00000000000000E+00  -1.13359174642168E-13
     -1.55402731400956E-24  -1.21563758473789E-08  -1.21564892065535E-08  -6.77936509690609E-19
      4.90641304552703E-09
      0.00000000000000E+00  -4.38916814641050E-12   0.00000000000000E+00  -1.77632431548150E-11   3.80914400286157E-25
      4.40697798398037E-09   4.38921474082555E-09  -1.91430623538873E-19  -5.22298074668079E-01  -5.22298074675834E-01
      0.00000000000000E+00   0.00000000000000E+00   7.75488289380230E-09   0.00000000000000E+00   7.75488289380230E-09
      9.90499160733033E-19  -5.28590135886391E-03  -1.45967215454944E-03   0.00000000000000E+00  -1.82224204046955E-12
     -3.35305682388979E-24  -1.21422753925874E-08  -1.21440976346279E-08  -7.99068537194161E-19
      4.92641304552703E-09
      0.00000000000000E+00   3.74000954382770E-12   0.00000000000000E+00  -2.00641988047937E-11  -3.31815247363438E-24
     -3.71993555240257E-09  -3.73999975120736E-09  -2.66265496686520E-19  -4.89135828909142E-01  -4.89135828925001E-01
      0.00000000000000E+00   0.00000000000000E+00   1.58591995218420E-08   0.00000000000000E+00   1.58591995218420E-08
      1.30768315116987E-18  -4.51542878789418E-03  -6.97045477368516E-04   0.00000000000000E+00  -4.34089098655139E-12
     -7.71824048418007E-24  -1.21148588796480E-08  -1.21191997706346E-08  -1.04141765448335E-18
      4.94641304552703E-09
      0.00000000000000E+00   9.99307478712774E-12   0.00000000000000E+00  -1.55103185513682E-11  -1.17148252317642E-23
     -9.97760445340081E-09  -9.99311477195219E-09  -3.87576839972836E-19  -4.38509605140127E-01  -4.38509605162196E-01
      0.00000000000000E+00   0.00000000000000E+00   2.20685987039301E-08   0.00000000000000E+00   2.20685987039301E-08
      1.74905512524847E-18  -3.81903808427578E-03  -1.44290859252192E-05   0.00000000000000E+00  -8.14060559511891E-12
     -2.13290416682063E-23  -1.20673433263829E-08  -1.20754839319780E-08  -1.36147828527564E-18
      4.96641304552703E-09
      0.00000000000000E+00   1.21351695930189E-11   0.00000000000000E+00  -5.46427529458172E-12  -2.80084630287834E-23
     -1.21296597256034E-08  -1.21351240008981E-08  -5.53916134267924E-19  -3.72307823145845E-01  -3.72307823169985E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41399033317933E-08   0.00000000000000E+00   2.41399033317933E-08
      2.23185319188434E-18  -3.41328194737793E-03   3.69046079693087E-04   0.00000000000000E+00  -1.47782595661194E-11
     -5.15618718041172E-23  -1.19900010713290E-08  -1.20047793308951E-08  -1.67793705761642E-18
      4.98641304552703E-09
      0.00000000000000E+00   1.02022052537493E-11   0.00000000000000E+00   4.46729988031462E-12  -3.94670330094798E-23
     -1.02066903312237E-08  -1.02022230313435E-08  -7.39761787294972E-19  -2.96108823078109E-01  -2.96108823099971E-01
      0.00000000000000E+00   0.00000000000000E+00   2.18620253053932E-08   0.00000000000000E+00   2.18620253053932E-08
      2.66909369799220E-18  -5.21591250845051E-03  -1.54228076805098E-03   0.00000000000000E+00  -2.59625894156918E-11
     -7.35755768101226E-23  -1.16338396846340E-08  -1.16598022740497E-08  -1.92933191069723E-18
      5.00641304552703E-09
      0.00000000000000E+00   7.90296410249605E-12   0.00000000000000E+00   5.27947570743441E-12  -4.25545199243880E-23
     -7.90829660813481E-09  -7.90301713242742E-09  -9.02142645281377E-19  -2.22138170891845E-01  -2.22138170910027E-01
      0.00000000000000E+00   0.00000000000000E+00   1.81826508854245E-08   0.00000000000000E+00   1.81826508854245E-08
      3.03274671570069E-18  -1.62292465266221E-02  -1.29904649602464E-02   0.00000000000000E+00  -4.14106229065124E-11
     -8.16604623800953E-23  -1.02382231300904E-08  -1.02796337529970E-08  -2.13060407041932E-18
      5.02641304552703E-09
      0.00000000000000E+00   6.43546889139419E-12   0.00000000000000E+00   3.15540945851341E-12  -4.44218985065591E-23
     -6.43855704051520E-09  -6.43540163105673E-09  -1.03192220453268E-18  -1.56725168071261E-01  -1.56725168086424E-01
      0.00000000000000E+00   0.00000000000000E+00   1.51634190559340E-08   0.00000000000000E+00   1.51634190559340E-08
      3.33601509681937E-18  -3.66593339613007E-02  -3.39094157964870E-02   0.00000000000000E+00  -6.41831490758083E-11
     -9.00346928823777E-23  -8.66383427580148E-09  -8.72801742487738E-09  -2.30409289228669E-18
      5.03141304552703E-09
      0.00000000000000E+00   5.95668227633135E-12   0.00000000000000E+00   4.17032248638252E-12  -4.48688712645823E-23
     -5.96081598054221E-09  -5.95664565805587E-09  -1.06182900261855E-18  -1.40843224612727E-01  -1.40843224626886E-01
      0.00000000000000E+00   0.00000000000000E+00   1.41596455422333E-08   0.00000000000000E+00   1.41596455422333E-08
      3.40681332453054E-18  -4.25302700819927E-02  -3.99457566779456E-02   0.00000000000000E+00  -8.22995943214558E-11
     -9.22591485251972E-23  -8.12070028985551E-09  -8.20299988417706E-09  -2.34498432191199E-18
      5.03816304552703E-09
      0.00000000000000E+00   5.47954886653825E-12   0.00000000000000E+00   2.94592205657092E-12  -4.54476413305822E-23
     -5.48245082490329E-09  -5.47950490284676E-09  -1.09870340060805E-18  -1.20770955526871E-01  -1.20770955540090E-01
      0.00000000000000E+00   0.00000000000000E+00   1.32185210495649E-08   0.00000000000000E+00   1.32185210495649E-08
      3.49603834161510E-18  -5.12653554684607E-02  -4.88270271759181E-02   0.00000000000000E+00  -9.27031889105430E-11
     -9.52588407995890E-23  -7.64631295780750E-09  -7.73901614671813E-09  -2.39733494100706E-18
      5.04727554552703E-09
      0.00000000000000E+00   4.90735615373536E-12   0.00000000000000E+00   2.54706973770801E-12  -4.61570166806402E-23
     -4.90984941694929E-09  -4.90730234721163E-09  -1.14299057460052E-18  -9.59486629589327E-02  -9.59486629710441E-02
      0.00000000000000E+00   0.00000000000000E+00   1.21113996264281E-08   0.00000000000000E+00   1.21113996264281E-08
      3.60640347071093E-18  -6.41837671690939E-02  -6.19139742942364E-02   0.00000000000000E+00  -1.04385841139040E-10
     -9.92726633977004E-23  -7.09971143807730E-09  -7.20409727921644E-09  -2.46341289611041E-18
      5.05957742052703E-09
      0.00000000000000E+00   4.08213118992573E-12   0.00000000000000E+00   2.78280761882019E-12  -4.69499654302843E-23
     -4.08486245552296E-09  -4.08207964790419E-09  -1.19241186088349E-18  -6.72809122762050E-02  -6.72809122867813E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05762744590910E-08   0.00000000000000E+00   1.05762744590910E-08
      3.73651147707236E-18  -8.34603634186764E-02  -8.14142384280587E-02   0.00000000000000E+00  -1.17092042404553E-10
     -1.04580247069491E-22  -6.37710276878227E-09  -6.49419481118693E-09  -2.54409961618887E-18
      5.06372930333953E-09
      0.00000000000000E+00   3.63126537497399E-12   0.00000000000000E+00   4.81990261679146E-12  -4.71768135255236E-23
     -3.63604369554191E-09  -3.63122379292517E-09  -1.20720810404465E-18  -5.85085304164342E-02  -5.85085304261871E-02
      0.00000000000000E+00   0.00000000000000E+00   9.75287803719527E-09   0.00000000000000E+00   9.75287803719527E-09
      3.77700428376740E-18  -9.03113737601187E-02  -8.83826183059667E-02   0.00000000000000E+00  -1.26485030255817E-10
     -1.06376450634552E-22  -5.99516921401402E-09  -6.12165424426995E-09  -2.56979617972275E-18
      5.06933434513641E-09
      0.00000000000000E+00   3.04226507526212E-12   0.00000000000000E+00   4.73679928865892E-12  -4.74280386068287E-23
     -3.04699840660358E-09  -3.04226160731497E-09  -1.22386834939153E-18  -4.84880329564979E-02  -4.84880329652208E-02
      0.00000000000000E+00   0.00000000000000E+00   8.72291431222596E-09   0.00000000000000E+00   8.72291431222596E-09
      3.82589658307799E-18  -1.00108795526133E-01  -9.83189861933883E-02   0.00000000000000E+00  -1.27976098458142E-10
     -1.08714219292347E-22  -5.55267660645266E-09  -5.68065270491091E-09  -2.60202823368646E-18
      5.07690115156219E-09
      0.00000000000000E+00   2.30034328809971E-12   0.00000000000000E+00   4.48885270708077E-12  -4.76717557937508E-23
     -2.30480498350889E-09  -2.30031613080186E-09  -1.24073464639604E-18  -3.81544751828527E-02  -3.81544751902728E-02
      0.00000000000000E+00   0.00000000000000E+00   7.42017747734645E-09   0.00000000000000E+00   7.42017747734645E-09
      3.88204362969401E-18  -1.14185026960510E-01  -1.12571906428609E-01   0.00000000000000E+00  -1.27272700062279E-10
     -1.11689457115342E-22  -4.99258864648234E-09  -5.11986134654473E-09  -2.64130898329796E-18
      5.08711634023699E-09
      0.00000000000000E+00   1.51121330601265E-12   0.00000000000000E+00   3.58306116293142E-12  -4.78713122816938E-23
     -1.51483227512784E-09  -1.51124921396496E-09  -1.25544091474590E-18  -2.89016754671078E-02  -2.89016754731015E-02
      0.00000000000000E+00   0.00000000000000E+00   5.99371540591110E-09   0.00000000000000E+00   5.99371540591110E-09
      3.94327056342848E-18  -1.34176756121719E-01  -1.32764459846808E-01   0.00000000000000E+00  -1.25514269428447E-10
     -1.15406014167287E-22  -4.35695192251748E-09  -4.48246619194604E-09  -2.68782964868258E-18
      5.10090684494798E-09
      0.00000000000000E+00   8.64718200808864E-13   0.00000000000000E+00   2.19176318904265E-12  -4.80084603401670E-23
     -8.66877590159969E-10  -8.64685826970974E-10  -1.26638954341299E-18  -2.17092277813153E-02  -2.17092277860430E-02
      0.00000000000000E+00   0.00000000000000E+00   4.72769578375895E-09   0.00000000000000E+00   4.72769578375895E-09
      4.00846787440651E-18  -1.61566692558327E-01  -1.60349568198686E-01   0.00000000000000E+00  -1.24600120115399E-10
     -1.20022944664275E-22  -3.73840983667248E-09  -3.86300995678800E-09  -2.74207833099352E-18
      5.11952402630781E-09
      0.00000000000000E+00   4.61611649205029E-13   0.00000000000000E+00   1.01475517027124E-12  -4.80902447452134E-23
     -4.62604098449221E-10  -4.61589343278998E-10  -1.27369724056625E-18  -1.65581362227263E-02  -1.65581362264750E-02
      0.00000000000000E+00   0.00000000000000E+00   3.74872034656809E-09   0.00000000000000E+00   3.74872034656809E-09
      4.07825848096586E-18  -1.96914897875230E-01  -1.95879215239437E-01   0.00000000000000E+00  -1.24600505517635E-10
     -1.25727400234393E-22  -3.16253049777131E-09  -3.28713100328907E-09  -2.80456124039962E-18
      5.13952402630781E-09
      0.00000000000000E+00   2.73421782666807E-13   0.00000000000000E+00   4.42191710219596E-13  -4.81277560093130E-23
     -2.73851383201010E-10  -2.73409191490839E-10  -1.27781921049903E-18  -1.34154952907861E-02  -1.34154952938062E-02
      0.00000000000000E+00   0.00000000000000E+00   3.02015251346849E-09   0.00000000000000E+00   3.02015251346849E-09
      4.13866153123523E-18  -2.30764119804037E-01  -2.29898695763184E-01   0.00000000000000E+00  -1.21618697061246E-10
     -1.31194635535284E-22  -2.62512462491635E-09  -2.74674332197773E-09  -2.86084232073620E-18
      5.15952402630781E-09
      0.00000000000000E+00   1.92873948135806E-13   0.00000000000000E+00   1.89832299659084E-13  -4.81445362638622E-23
     -1.93079790388218E-10  -1.92889958088607E-10  -1.28036014699484E-18  -1.14047581277526E-02  -1.14047581301582E-02
      0.00000000000000E+00   0.00000000000000E+00   2.40561921697097E-09   0.00000000000000E+00   2.40561921697097E-09
      4.18677391557465E-18  -2.58798742859247E-01  -2.58101570561626E-01   0.00000000000000E+00  -1.10324600413081E-10
     -1.35791661215276E-22  -2.10240465846905E-09  -2.21272925888227E-09  -2.90641376857981E-18
      5.17952402630781E-09
      0.00000000000000E+00   1.55768674303965E-13   0.00000000000000E+00   8.84819298834838E-14  -4.81517897526026E-23
     -1.55883196292922E-10  -1.55794714363086E-10  -1.28218239998295E-18  -1.00081073425859E-02  -1.00081073444493E-02
      0.00000000000000E+00   0.00000000000000E+00   1.86344441510812E-09   0.00000000000000E+00   1.86344441510812E-09
      4.22404280387681E-18  -2.80466419576831E-01  -2.79928384606926E-01   0.00000000000000E+00  -9.15036768766755E-11
     -1.39392275518209E-22  -1.61614602386823E-09  -1.70764970074505E-09  -2.94186040389387E-18
      5.19952402630781E-09
      0.00000000000000E+00   1.36297590015970E-13   0.00000000000000E+00   4.79696641442804E-14  -4.81539520506830E-23
     -1.36313886840013E-10  -1.36265917175917E-10  -1.28363198340297E-18  -8.99649109850145E-03  -8.99649109990485E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40340233726084E-09   0.00000000000000E+00   1.40340233726084E-09
      4.25211085062203E-18  -2.96182336340859E-01  -2.95783097110575E-01   0.00000000000000E+00  -6.93699746888294E-11
     -1.42015655110325E-22  -1.19776644539592E-09  -1.26713642008489E-09  -2.96847886721906E-18
      5.21952402630781E-09
      0.00000000000000E+00   1.25735445237104E-13   0.00000000000000E+00   2.71390029000334E-14  -4.81535715596490E-23
     -1.25750431993727E-10  -1.25723292990875E-10  -1.28488419653166E-18  -8.23956026032980E-03  -8.23956026135057E-03
      0.00000000000000E+00   0.00000000000000E+00   1.02076463264072E-09   0.00000000000000E+00   1.02076463264072E-09
      4.27252614327484E-18  -3.06652889683068E-01  -3.06370890236539E-01   0.00000000000000E+00  -4.68692697156255E-11
     -1.43747467017765E-22  -8.48172069934138E-10  -8.95041339649907E-10  -2.98764194674318E-18
      5.23952402630781E-09
      0.00000000000000E+00   1.18020487311672E-13   0.00000000000000E+00   2.09477569826985E-14  -4.81512168130222E-23
     -1.18062969159867E-10  -1.18042021402932E-10  -1.28599291604639E-18  -7.67384883603412E-03  -7.67384883675603E-03
      0.00000000000000E+00   0.00000000000000E+00   7.21910062933045E-10   0.00000000000000E+00   7.21910062933045E-10
      4.28696434453350E-18  -3.12948723905632E-01  -3.12758467928298E-01   0.00000000000000E+00  -2.73403181090305E-11
     -1.44751278937087E-22  -5.76527723420973E-10  -6.03868041530148E-10  -3.00097142848712E-18
      5.25952402630781E-09
      0.00000000000000E+00   1.03600863570090E-13   0.00000000000000E+00   3.98102070769473E-14  -4.81438452893565E-23
     -1.03589856290360E-10  -1.03550046083331E-10  -1.28682087368418E-18  -7.31568114553134E-03  -7.31568114611193E-03
      0.00000000000000E+00   0.00000000000000E+00   5.80591289436502E-10   0.00000000000000E+00   5.80591289436502E-10
      4.29857617032224E-18  -3.17586027496335E-01  -3.17435732328642E-01   0.00000000000000E+00  -1.89606918525491E-11
     -1.45442037183656E-22  -4.58080551500448E-10  -4.77041243353143E-10  -3.01175529663806E-18
      5.27952402630781E-09
      0.00000000000000E+00   9.14773582586966E-14   0.00000000000000E+00   3.55755405621268E-14  -4.81329396277916E-23
     -9.15231851665355E-11  -9.14876096260215E-11  -1.28741707535110E-18  -7.08339221876110E-03  -7.08339221933304E-03
      0.00000000000000E+00   0.00000000000000E+00   5.71930613726573E-10   0.00000000000000E+00   5.71930613726573E-10
      4.31001478259677E-18  -3.22461642906437E-01  -3.22310275717396E-01   0.00000000000000E+00  -2.00029936490263E-11
     -1.46154297980151E-22  -4.60440010451389E-10  -4.80443004100561E-10  -3.02259770724567E-18
      5.28952402630781E-09
      0.00000000000000E+00   8.88138608796784E-14   0.00000000000000E+00   1.91242495400992E-14  -4.81273836351036E-23
     -8.88754166974558E-11  -8.88562924479639E-11  -1.28769123401046E-18  -6.97998547308167E-03  -6.97998547364493E-03
      0.00000000000000E+00   0.00000000000000E+00   5.63257253131387E-10   0.00000000000000E+00   5.63257253131387E-10
      4.31564735512808E-18  -3.24868927925442E-01  -3.24719464435991E-01   0.00000000000000E+00  -1.98033060547339E-11
     -1.46503336015425E-22  -4.54597654628595E-10  -4.74400960683475E-10  -3.02795612111762E-18
      5.30302402630781E-09
      0.00000000000000E+00   8.27521082239816E-14   0.00000000000000E+00   2.90331070614923E-14  -4.81185505882646E-23
     -8.27979185125125E-11  -8.27688854054991E-11  -1.28798384355168E-18  -6.86847515969907E-03  -6.86847516030662E-03
      0.00000000000000E+00   0.00000000000000E+00   6.07552590940721E-10   0.00000000000000E+00   6.07552590940721E-10
      4.32384931510578E-18  -3.28698009665891E-01  -3.28532671257774E-01   0.00000000000000E+00  -2.42120116139664E-11
     -1.47069746167673E-22  -5.00571693921082E-10  -5.24783705535196E-10  -3.03586547155410E-18
      5.32124902630781E-09
      0.00000000000000E+00   7.27410318683612E-14   0.00000000000000E+00   3.53794016075243E-14  -4.81038096529660E-23
     -7.27498483767489E-11  -7.27144689751895E-11  -1.28820566322175E-18  -6.76589541328704E-03  -6.76589541401331E-03
      0.00000000000000E+00   0.00000000000000E+00   7.26264296309015E-10   0.00000000000000E+00   7.26264296309015E-10
      4.33708548190601E-18  -3.35764134803656E-01  -3.35558224131737E-01   0.00000000000000E+00  -3.50471091804494E-11
     -1.48154877391388E-22  -6.18502718153254E-10  -6.53549827333852E-10  -3.04887981868426E-18
      5.32624902630781E-09
      0.00000000000000E+00   6.22707318267031E-14   0.00000000000000E+00   1.12250048208528E-13  -4.80983822104516E-23
     -6.23697687454152E-11  -6.22575186972548E-11  -1.28821506726772E-18  -6.76101800731774E-03  -6.76101800810350E-03
      0.00000000000000E+00   0.00000000000000E+00   7.85752597168040E-10   0.00000000000000E+00   7.85752597168040E-10
      4.34101424489185E-18  -3.38012296991809E-01  -3.37784347244697E-01   0.00000000000000E+00  -4.15584412005335E-11
     -1.48503069103601E-22  -6.81936637269825E-10  -7.23495078470507E-10  -3.05279917762413E-18
      5.33299902630781E-09
      0.00000000000000E+00   5.17085870478376E-14   0.00000000000000E+00   8.86008306514933E-14  -4.80901276896040E-23
     -5.18291381894961E-11  -5.17405373588927E-11  -1.28815852275601E-18  -6.77495296654212E-03  -6.77495296745866E-03
      0.00000000000000E+00   0.00000000000000E+00   9.16534824253248E-10   0.00000000000000E+00   9.16534824253248E-10
      4.34720085495556E-18  -3.41827729718223E-01  -3.41555258472786E-01   0.00000000000000E+00  -5.38060065162862E-11
     -1.49106445033759E-22  -8.10988280377966E-10  -8.64794286894402E-10  -3.05904233219955E-18
      5.34211152630781E-09
      0.00000000000000E+00   4.99635370408946E-14   0.00000000000000E+00   2.18223474510897E-14  -4.80796301131326E-23
     -4.99579236573359E-11  -4.99361013099329E-11  -1.28806930192311E-18  -6.77091196342917E-03  -6.77091196449549E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06632433919679E-09   0.00000000000000E+00   1.06632433919679E-09
      4.35691773549649E-18  -3.48029955778900E-01  -3.47709719525094E-01   0.00000000000000E+00  -6.69832780513018E-11
     -1.50112261393860E-22  -9.49404959835371E-10  -1.01638823788682E-09  -3.06884843357338E-18
      5.35441340130781E-09
      0.00000000000000E+00   5.40965502152333E-14   0.00000000000000E+00  -6.05172973896332E-15  -4.80670805285424E-23
     -5.41164453272764E-11  -5.41224970570634E-11  -1.28800721810489E-18  -6.70023941266848E-03  -6.70023941384790E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17942402790768E-09   0.00000000000000E+00   1.17942402790768E-09
      4.37142686245981E-18  -3.57383189571378E-01  -3.57028636419851E-01   0.00000000000000E+00  -7.75170584795911E-11
     -1.51663682246293E-22  -1.04778447237098E-09  -1.12530153085072E-09  -3.08341964435492E-18
      5.37102093255781E-09
      0.00000000000000E+00   6.24544213011182E-14   0.00000000000000E+00  -1.60906553745980E-14  -4.80532825750200E-23
     -6.24710491435273E-11  -6.24871397989499E-11  -1.28807479850086E-18  -6.49720014347388E-03  -6.49720014469946E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22557498851418E-09   0.00000000000000E+00   1.22557498851418E-09
      4.39178063738078E-18  -3.70423857829913E-01  -3.70057398823814E-01   0.00000000000000E+00  -8.33656398640082E-11
     -1.53874273287798E-22  -1.07972220885111E-09  -1.16308784871527E-09  -3.10370583887992E-18
      5.39102093255781E-09
      0.00000000000000E+00   7.62311318822472E-14   0.00000000000000E+00  -2.78785366958684E-14  -4.80423805266793E-23
     -7.61552431070715E-11  -7.61831216438154E-11  -1.28844719403904E-18  -6.08136266064495E-03  -6.08136266186615E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22120187593353E-09   0.00000000000000E+00   1.22120187593353E-09
      4.41620467489944E-18  -3.85751828483892E-01  -3.85391062686241E-01   0.00000000000000E+00  -8.54641764896820E-11
     -1.56540040291930E-22  -1.05955457779993E-09  -1.14501875428977E-09  -3.12775748086040E-18
      5.41102093255782E-09
      0.00000000000000E+00   9.43245451121300E-14   0.00000000000000E+00  -4.22642636269455E-14  -4.80386809687687E-23
     -9.42318578045444E-11  -9.42741220682194E-11  -1.28919699953398E-18  -5.45203905495520E-03  -5.45203905615780E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20259389788421E-09   0.00000000000000E+00   1.20259389788421E-09
      4.44025655285713E-18  -4.00381458363622E-01  -4.00032255568153E-01   0.00000000000000E+00  -8.61277075976196E-11
     -1.59162319162087E-22  -1.02219206821807E-09  -1.10831977581585E-09  -3.15105955332315E-18
      5.43102093255782E-09
      0.00000000000000E+00   1.05896982000278E-13   0.00000000000000E+00  -2.89155536540733E-14  -4.80391501621356E-23
     -1.05931794405324E-10  -1.05960709959026E-10  -1.29019485906683E-18  -4.68901032701481E-03  -4.68901032818827E-03
      0.00000000000000E+00   0.00000000000000E+00   1.17345797673511E-09   0.00000000000000E+00   1.17345797673511E-09
      4.46372571239183E-18  -4.14314453756166E-01  -4.13978113295989E-01   0.00000000000000E+00  -8.60499632175078E-11
     -1.61724058456252E-22  -9.81447303558427E-10  -1.06749726677610E-09  -3.17353085332501E-18
      5.45102093255782E-09
      0.00000000000000E+00   1.03600863570090E-13   0.00000000000000E+00   5.72977289965927E-15  -4.80383344214746E-23
     -1.03634128459529E-10  -1.03628398686678E-10  -1.29115981208401E-18  -3.96050726548101E-03  -3.96050726660783E-03
      0.00000000000000E+00   0.00000000000000E+00   1.12681779797282E-09   0.00000000000000E+00   1.12681779797282E-09
      4.48626206835129E-18  -4.27642762749494E-01  -4.27320382910513E-01   0.00000000000000E+00  -8.51722347982959E-11
     -1.64207492146528E-22  -9.38017164487721E-10  -1.02318939928618E-09  -3.19510225626728E-18
      5.47102093255782E-09
      0.00000000000000E+00   8.61503635006601E-14   0.00000000000000E+00   4.58476405900265E-14  -4.80308659751790E-23
     -8.62064563563292E-11  -8.61606087157872E-11  -1.29178936882410E-18  -3.44658895286895E-03  -3.44658895393014E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06118712348513E-09   0.00000000000000E+00   1.06118712348513E-09
      4.50748581082099E-18  -4.40462751720733E-01  -4.40155547285865E-01   0.00000000000000E+00  -8.33726887028719E-11
     -1.66592026327605E-22  -8.91653826066348E-10  -9.75026514769387E-10  -3.21569644199689E-18
      5.49102093255782E-09
      0.00000000000000E+00  -2.28693395646742E-14   0.00000000000000E+00   2.89915288073889E-13  -4.79798764910417E-23
      2.26184409710348E-11   2.29083562590607E-11  -1.29025652234966E-18  -4.24681554148804E-03  -4.24681554234095E-03
      0.00000000000000E+00   0.00000000000000E+00   8.52912978807855E-10   0.00000000000000E+00   8.52912978807855E-10
      4.52454407039715E-18  -4.52963584764415E-01  -4.52687639059837E-01   0.00000000000000E+00  -7.48110889021261E-11
     -1.68693315390979E-22  -8.01010246164652E-10  -8.75821335066947E-10  -3.23428754804749E-18
      5.51102093255782E-09
      0.00000000000000E+00  -6.63027157901136E-13   0.00000000000000E+00   1.70383980891426E-12  -4.76724040455826E-23
      6.61362232999701E-10   6.63066072808567E-10  -1.27598124027383E-18  -1.26845677470208E-02  -1.26845677468188E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.01997495635492E-10   0.00000000000000E+00  -2.01997495635492E-10
      4.52050412048444E-18  -4.65902971075282E-01  -4.65757712579769E-01   0.00000000000000E+00  -2.58429175297184E-11
     -1.69394345801950E-22  -4.35225659643164E-10  -4.61068577173052E-10  -3.24452288021061E-18
      5.53102093255782E-09
      0.00000000000000E+00  -1.54822673510728E-12   0.00000000000000E+00   2.43831563890063E-12  -4.70478668764253E-23
      1.54581373015975E-09   1.54825204579860E-09  -1.24419140042012E-18  -3.12684748878153E-02  -3.12684748861827E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.63260121544043E-09   0.00000000000000E+00  -1.63260121544043E-09
      4.48785209617563E-18  -4.79475412178369E-01  -4.79502013985241E-01   0.00000000000000E+00   4.05439561729291E-11
     -1.68220819469208E-22   4.38052134690570E-11   8.43491696418179E-11  -3.24366069575552E-18
      5.54102093255782E-09
      0.00000000000000E+00  -2.00662381851004E-12   0.00000000000000E+00   2.56205202097391E-12  -4.66594844254058E-23
      2.00407003614359E-09   2.00663208816452E-09  -1.22380969451197E-18  -4.29699869031991E-02  -4.29699869008427E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.35641498829980E-09   0.00000000000000E+00  -2.35641498829980E-09
      4.46428794629263E-18  -4.86339125266225E-01  -4.86449364901015E-01   0.00000000000000E+00   7.18183751418231E-11
     -1.67187429737955E-22   2.77964524993800E-10   3.49782900135456E-10  -3.24047825178066E-18
      5.55452093255782E-09
      0.00000000000000E+00  -2.41790455172535E-12   0.00000000000000E+00   1.83383194787565E-12  -4.60651604974828E-23
      2.41606952903253E-09   2.41790336098036E-09  -1.19107561800389E-18  -6.13791202209529E-02  -6.13791202179768E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.97612022367614E-09   0.00000000000000E+00  -2.97612022367614E-09
      4.42411032327300E-18  -4.95631636153391E-01  -4.95807554140319E-01   0.00000000000000E+00   9.56813745845750E-11
     -1.65319247982276E-22   4.62535488111367E-10   5.58216862695777E-10  -3.23303470526912E-18
      5.57274593255782E-09
      0.00000000000000E+00  -2.97117724866349E-12   0.00000000000000E+00   1.83831931771923E-12  -4.51384598436866E-23
      2.96931921571055E-09   2.97115753502822E-09  -1.13827801523128E-18  -9.01399955711655E-02  -9.01399955674454E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.72013660974663E-09   0.00000000000000E+00  -3.72013660974663E-09
      4.35631083356037E-18  -5.08055473594297E-01  -5.08291506783770E-01   0.00000000000000E+00   1.20002743119797E-10
     -1.62126923897786E-22   6.28976331598860E-10   7.48979074718495E-10  -3.21803281832910E-18
      5.57774593255782E-09
      0.00000000000000E+00  -3.29713422101300E-12   0.00000000000000E+00   3.53404011967212E-12  -4.48533299955669E-23
      3.29358438040560E-09   3.29711842052523E-09  -1.12236845002835E-18  -9.86091204962933E-02  -9.86091204921453E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.14797211328446E-09   0.00000000000000E+00  -4.14797211328446E-09
      4.33557097299395E-18  -5.11454232765534E-01  -5.11722368103986E-01   0.00000000000000E+00   1.30718668626165E-10
     -1.61166042568240E-22   7.20135024133023E-10   8.50853692759027E-10  -3.21320252296560E-18
      5.58449593255782E-09
      0.00000000000000E+00  -3.65734928034092E-12   0.00000000000000E+00   2.97875986521860E-12  -4.44399415265933E-23
      3.65432882743315E-09   3.65730758729832E-09  -1.09900136217001E-18  -1.10867978907214E-01  -1.10867978902629E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.58547902266278E-09   0.00000000000000E+00  -4.58547902266278E-09
      4.30461898959098E-18  -5.16033455146692E-01  -5.16325959739971E-01   0.00000000000000E+00   1.42965577116906E-10
     -1.59738395964993E-22   7.85205858247828E-10   9.28171435364574E-10  -3.20561762742097E-18
      5.59360843255782E-09
      0.00000000000000E+00  -4.12759433484346E-12   0.00000000000000E+00   2.88606371642399E-12  -4.37858361800419E-23
      4.12474845889150E-09   4.12763452260788E-09  -1.06480771487062E-18  -1.28444106535310E-01  -1.28444106530264E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.04604518336318E-09   0.00000000000000E+00  -5.04604518336318E-09
      4.25863690285758E-18  -5.22084004706464E-01  -5.22373449785970E-01   0.00000000000000E+00   1.53368952698292E-10
     -1.57650579118244E-22   7.65041708057204E-10   9.18410660755338E-10  -3.19382918798696E-18
      5.60591030755782E-09
      0.00000000000000E+00  -4.81835860338127E-12   0.00000000000000E+00   3.08615987820007E-12  -4.24173844385177E-23
      4.81532101983297E-09   4.81840717971113E-09  -1.01588412792288E-18  -1.52878722666639E-01  -1.52878722661206E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.43305031330591E-09   0.00000000000000E+00  -5.43305031330591E-09
      4.19180019703458E-18  -5.29665022117849E-01  -5.29858794185537E-01   0.00000000000000E+00   1.57761889701720E-10
     -1.54702797032319E-22   4.56881243892989E-10   6.14643133594555E-10  -3.17591606911170E-18
      5.62251783880782E-09
      0.00000000000000E+00  -6.28052681972509E-12   0.00000000000000E+00   4.60892825506515E-12  -3.75756314983784E-23
      6.27596582204403E-09   6.28057475029906E-09  -9.48805997294610E-19  -1.85120340222689E-01  -1.85120340217004E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.68549324358980E-09   0.00000000000000E+00  -5.68549324358980E-09
      4.09737819032000E-18  -5.37615590436163E-01  -5.37428310078641E-01   0.00000000000000E+00   1.55933232923685E-10
     -1.50644693743389E-22  -7.51014739632685E-10  -5.95081506709150E-10  -3.14857219302539E-18
      5.64251783880782E-09
      0.00000000000000E+00  -9.92556890528021E-12   0.00000000000000E+00   9.18659273210695E-12  -1.91306931402352E-23
      9.91633828908872E-09   9.92552488182081E-09  -8.71853460913021E-19  -2.20520263043437E-01  -2.20520263037560E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.87673018811703E-09   0.00000000000000E+00  -5.87673018811703E-09
      3.97984358655766E-18  -5.40261822041577E-01  -5.38986612115724E-01   0.00000000000000E+00   1.55904830718406E-10
     -1.45442026586695E-22  -4.20469952442196E-09  -4.04879469370370E-09  -3.10799012564463E-18
      5.66251783880782E-09
      0.00000000000000E+00  -1.65118468551692E-11   0.00000000000000E+00   1.63807191832222E-11   2.22325178557731E-23
      1.64954676887767E-08   1.65118484079599E-08  -8.04227850903473E-19  -2.50534285148692E-01  -2.50534285142579E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.11246879435365E-09   0.00000000000000E+00  -6.11246879435365E-09
      3.85759421067058E-18  -5.30618181130463E-01  -5.27342437196944E-01   0.00000000000000E+00   1.63042152665212E-10
     -1.39379042460853E-22  -1.05624217662715E-08  -1.03993796136064E-08  -3.05336635976711E-18
      5.68251783880782E-09
      0.00000000000000E+00  -2.51232094157469E-11   0.00000000000000E+00   2.13526993238537E-11   7.68650822511953E-23
      2.51018604693283E-08   2.51232131686523E-08  -7.50073182581201E-19  -2.74225241318055E-01  -2.74225241311660E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.39458829618628E-09   0.00000000000000E+00  -6.39458829618628E-09
      3.72970244474686E-18  -5.04404776182761E-01  -4.98505042841940E-01   0.00000000000000E+00   1.73246409418328E-10
     -1.31896486825734E-22  -1.89018712818841E-08  -1.87286248724659E-08  -2.97962926216566E-18
      5.70251783880782E-09
      0.00000000000000E+00  -3.31291314686526E-11   0.00000000000000E+00   1.98600389842314E-11   1.28016229913315E-22
      3.31093397260487E-08   3.31291997650331E-08  -7.10538236477025E-19  -2.91768814149921E-01  -2.91768814143239E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.68231918361430E-09   0.00000000000000E+00  -6.68231918361430E-09
      3.59605606107457E-18  -4.60450735009016E-01  -4.52119306839706E-01   0.00000000000000E+00   1.76187982814375E-10
     -1.22916191712692E-22  -2.66230685642329E-08  -2.64468805814187E-08  -2.88551782459755E-18
      5.72251783880782E-09
      0.00000000000000E+00  -3.78765859349096E-11   0.00000000000000E+00   1.18048813767416E-11   1.59815554742208E-22
      3.78647909556250E-08   3.78765958370019E-08  -6.84827066180843E-19  -3.03836651438657E-01  -3.03836651431702E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.95463882407960E-09   0.00000000000000E+00  -6.95463882407960E-09
      3.45696328459298E-18  -3.99985707062037E-01  -3.90244178450680E-01   0.00000000000000E+00   1.68024419043604E-10
     -1.13065809255210E-22  -3.10899814319660E-08  -3.09219570129225E-08  -2.77213621841214E-18
      5.74251783880782E-09
      0.00000000000000E+00  -3.80849816436335E-11   0.00000000000000E+00   5.61332225064556E-13   1.64794708755337E-22
      3.80843987436346E-08   3.80849600758598E-08  -6.71201606338402E-19  -3.11270082837557E-01  -3.11270082830354E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.20365884168309E-09   0.00000000000000E+00  -7.20365884168309E-09
      3.31289010775932E-18  -3.26512645382149E-01  -3.16783654737304E-01   0.00000000000000E+00   1.48959649314243E-10
     -1.03225622957365E-22  -3.10302608834907E-08  -3.08813012341766E-08  -2.64168850142092E-18
      5.76251783880782E-09
      0.00000000000000E+00  -3.54355365094080E-11   0.00000000000000E+00  -6.53243024312427E-12   1.50612956991997E-22
      3.54420324170412E-08   3.54354999867982E-08  -6.64494551994067E-19  -3.16123918133659E-01  -3.16123918126318E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.34166181001730E-09   0.00000000000000E+00  -7.34166181001730E-09
      3.16605687155897E-18  -2.50219690709508E-01  -2.41368681105461E-01   0.00000000000000E+00   1.14398808848791E-10
     -9.30745558684489E-23  -2.82082369856296E-08  -2.80938381767809E-08  -2.50156231956491E-18
      5.78251783880782E-09
      0.00000000000000E+00  -3.27557826119040E-11   0.00000000000000E+00  -6.62229191698857E-12   1.32006646917035E-22
      3.27624220015788E-08   3.27557997096620E-08  -6.58293014968396E-19  -3.20850847013217E-01  -3.20850847005899E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.31815170800500E-09   0.00000000000000E+00  -7.31815170800500E-09
      3.01969383739887E-18  -1.81358814286893E-01  -1.73344507782874E-01   0.00000000000000E+00   7.59737678310398E-11
     -8.41427450241432E-23  -2.55136217694880E-08  -2.54376480016570E-08  -2.36140082243048E-18
      5.79251783880782E-09
      0.00000000000000E+00  -3.13672738748006E-11   0.00000000000000E+00  -6.86039868423635E-12   1.21923269052849E-22
      3.13741288296972E-08   3.13672684310131E-08  -6.55380258923314E-19  -3.23155675880502E-01  -3.23155675873196E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.30604024860152E-09   0.00000000000000E+00  -7.30604024860152E-09
      2.94663343491286E-18  -1.49221983745207E-01  -1.41641277308073E-01   0.00000000000000E+00   5.76233875264335E-11
     -8.11754679867488E-23  -2.41188515699379E-08  -2.40612281824116E-08  -2.29125317598954E-18
      5.80601783880782E-09
      0.00000000000000E+00  -3.00354333405542E-11   0.00000000000000E+00  -4.87635438148897E-12   1.10602583452421E-22
      3.00403296765624E-08   3.00354533221810E-08  -6.50128071577115E-19  -3.26788349102254E-01  -3.26788349095030E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.22485887612931E-09   0.00000000000000E+00  -7.22485887612931E-09
      2.84909784008511E-18  -1.10307023412289E-01  -1.03120292435940E-01   0.00000000000000E+00   4.37872557261646E-11
     -7.71251715847034E-23  -2.28543817017777E-08  -2.28105944460516E-08  -2.19896976850800E-18
      5.82424283880782E-09
      0.00000000000000E+00  -2.81978956832432E-11   0.00000000000000E+00  -4.96988231306716E-12   1.00099102992764E-22
      2.82028410607599E-08   2.81978711784470E-08  -6.39518329234297E-19  -3.32961448423417E-01  -3.32961448416340E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.07674144984786E-09   0.00000000000000E+00  -7.07674144984786E-09
      2.72012422716164E-18  -6.69322795699844E-02  -6.02777891822407E-02   0.00000000000000E+00   3.20211406074991E-11
     -5.80967469711989E-23  -2.11531508692066E-08  -2.11211297285992E-08  -2.08060589792734E-18
      5.82924283880782E-09
      0.00000000000000E+00  -2.71582132580540E-11   0.00000000000000E+00  -1.02093662259453E-11   9.74654204294360E-23
      2.71683841028656E-08   2.71581747366397E-08  -6.36024093380155E-19  -3.34831425819651E-01  -3.34831425812632E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.01866995646413E-09   0.00000000000000E+00  -7.01866995646413E-09
      2.68503087737931E-18  -5.64170874360480E-02  -5.00718610139195E-02   0.00000000000000E+00   3.09516508522041E-11
     -4.57453041254699E-23  -2.01704564310277E-08  -2.01395047801755E-08  -2.04900678399916E-18
      5.83599283880782E-09
      0.00000000000000E+00  -2.58284851527635E-11   0.00000000000000E+00  -9.71454220205667E-12   9.63570625327587E-23
      2.58382117755433E-08   2.58284972333413E-08  -6.29297563119446E-19  -3.38058666200839E-01  -3.38058666193976E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.86293480915532E-09   0.00000000000000E+00  -6.86293480915532E-09
      2.63870606741752E-18  -4.49920800988415E-02  -3.90167094064117E-02   0.00000000000000E+00   2.59068921527615E-11
     -2.29649528787556E-23  -1.89914693163386E-08  -1.89655624241858E-08  -2.00940850429807E-18
      5.84510533880782E-09
      0.00000000000000E+00  -2.41913527120393E-11   0.00000000000000E+00  -8.84812965055895E-12   9.93593693614383E-23
      2.42001750744625E-08   2.41913269448120E-08  -6.16772549928464E-19  -3.43599035204846E-01  -3.43599035198205E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.64149933139103E-09   0.00000000000000E+00  -6.64149933139103E-09
      2.57818540476022E-18  -3.40884389150975E-02  -2.85591049836990E-02   0.00000000000000E+00   2.07981895461049E-11
      1.41890621911190E-23  -1.75706258029674E-08  -1.75498276134212E-08  -1.96141285483175E-18
      5.85740721380782E-09
      0.00000000000000E+00  -2.25451276423316E-11   0.00000000000000E+00  -6.57856914446315E-12   1.08876708266583E-22
      2.25516770027181E-08   2.25450984335738E-08  -5.95689152086910E-19  -3.52489905866026E-01  -3.52489905859625E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.40065057533944E-09   0.00000000000000E+00  -6.40065057533944E-09
      2.49944540146371E-18  -2.52082835611012E-02  -2.01217253321242E-02   0.00000000000000E+00   1.50848151975665E-11
      6.26053197121671E-23  -1.61595326734319E-08  -1.61444478582342E-08  -1.90375624937680E-18
      5.87401474505782E-09
      0.00000000000000E+00  -2.12146647791434E-11   0.00000000000000E+00  -3.92138831206619E-12   1.24329882277326E-22
      2.12185868441032E-08   2.12146654557913E-08  -5.64312520299543E-19  -3.65423960163084E-01  -3.65423960156891E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.19325956455391E-09   0.00000000000000E+00  -6.19325956455391E-09
      2.39659064970602E-18  -1.88256833697911E-02  -1.40929479318253E-02   0.00000000000000E+00   1.01079597671077E-11
      1.17105999373581E-22  -1.50315138510046E-08  -1.50214058912374E-08  -1.83227812940648E-18
      5.89401474505782E-09
      0.00000000000000E+00  -2.02456109568667E-11   0.00000000000000E+00  -2.35652419340276E-12   1.38139586787828E-22
      2.02479232188724E-08   2.02455666946792E-08  -5.26492006021978E-19  -3.80912930831288E-01  -3.80912930825250E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.03813238933454E-09   0.00000000000000E+00  -6.03813238933454E-09
      2.27582800191933E-18  -1.47306423388771E-02  -1.02543546563269E-02   0.00000000000000E+00   7.07909985548503E-12
      1.63558655867618E-22  -1.42145134052002E-08  -1.42074343053446E-08  -1.74933599589735E-18
      5.91401474505782E-09
      0.00000000000000E+00  -1.94920248880790E-11   0.00000000000000E+00  -1.82609704735778E-12   1.42328995276021E-22
      1.94938386591950E-08   1.94920125621478E-08  -4.90300560863598E-19  -3.95772157564872E-01  -3.95772157558951E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.92186669170391E-09   0.00000000000000E+00  -5.92186669170391E-09
      2.15739066808525E-18  -1.22685333255566E-02  -7.99302896404541E-03   0.00000000000000E+00   5.61718692110802E-12
      1.87686817313857E-22  -1.35757630573652E-08  -1.35701458704439E-08  -1.66709010722165E-18
      5.93401474505782E-09
      0.00000000000000E+00  -1.88285385064918E-11   0.00000000000000E+00  -1.60698947620014E-12   1.36238345827683E-22
      1.88301222090610E-08   1.88285152195849E-08  -4.56068297136387E-19  -4.09921132369630E-01  -4.09921132363810E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.81981048813089E-09   0.00000000000000E+00  -5.81981048813089E-09
      2.04099445832263E-18  -1.06168574366316E-02  -6.51824085942670E-03   0.00000000000000E+00   4.77631648131689E-12
      1.90271227827302E-22  -1.30134810479355E-08  -1.30087047314540E-08  -1.58492616118625E-18
      5.95401474505782E-09
      0.00000000000000E+00  -1.82478042331286E-11   0.00000000000000E+00  -1.40590111087489E-12   1.21749074550647E-22
      1.82491929013862E-08   1.82477870002754E-08  -4.23611619430315E-19  -4.23433376985372E-01  -4.23433376979644E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.72786021301849E-09   0.00000000000000E+00  -5.72786021301849E-09
      1.92643725406226E-18  -9.44124796014839E-03  -5.49662626774667E-03   0.00000000000000E+00   4.14294998946393E-12
      1.75353051306870E-22  -1.25240697372466E-08  -1.25199267872569E-08  -1.50282563463195E-18
      5.97401474505782E-09
      0.00000000000000E+00  -1.77549653732730E-11   0.00000000000000E+00  -1.19159653697620E-12   1.01928759867394E-22
      1.77561544598419E-08   1.77549628633050E-08  -3.92637035794825E-19  -4.36406778050224E-01  -4.36406778044580E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64458222568810E-09   0.00000000000000E+00  -5.64458222568810E-09
      1.81354560954850E-18  -8.57519029608082E-03  -4.75960072511148E-03   0.00000000000000E+00   3.61269216305063E-12
      1.48816873157593E-22  -1.21139933297801E-08  -1.21103806376169E-08  -1.42090857375368E-18
      5.99401474505782E-09
      0.00000000000000E+00  -1.73581961085365E-11   0.00000000000000E+00  -9.56693326155705E-13   8.01217506881283E-23
      1.73591382322349E-08   1.73581815389088E-08  -3.62796398506737E-19  -4.48964436638196E-01  -4.48964436632610E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58571620297984E-09   0.00000000000000E+00  -5.58571620297984E-09
      1.70183128548891E-18  -7.91994564851233E-03  -4.21082007937502E-03   0.00000000000000E+00   3.18325131792819E-12
      1.16946136980740E-22  -1.17756485872471E-08  -1.17724653359291E-08  -1.33903488698217E-18
      6.01401474505782E-09
      0.00000000000000E+00  -1.72961090661842E-11   0.00000000000000E+00  -1.32953092043398E-13   5.94323194320197E-23
      1.72962658024783E-08   1.72961328493863E-08  -3.32755448696999E-19  -4.61666369894657E-01  -4.61666369888912E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.74516986611946E-09   0.00000000000000E+00  -5.74516986611946E-09
      1.58692788816652E-18  -7.46126412679883E-03  -3.82192488782429E-03   0.00000000000000E+00   2.76901386282537E-12
      8.53486616442703E-23  -1.15537319971297E-08  -1.15509629832668E-08  -1.25417243946952E-18
      6.03401474505782E-09
      0.00000000000000E+00  -1.76708355939909E-11   0.00000000000000E+00   9.44256889328005E-13   4.17340624346948E-23
      1.76698868547530E-08   1.76708311116424E-08  -3.01219120295420E-19  -4.75090505867886E-01  -4.75090505861711E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.17541726906745E-09   0.00000000000000E+00  -6.17541726906745E-09
      1.46341954278517E-18  -7.18636800820675E-03  -3.56452864179725E-03   0.00000000000000E+00   2.33378601823048E-12
      5.76222958300442E-23  -1.14977476285932E-08  -1.14954138425749E-08  -1.16220042248975E-18
      6.05401474505782E-09
      0.00000000000000E+00  -1.79785154636362E-11   0.00000000000000E+00   7.81265430267017E-13   2.76841160472102E-23
      1.79777599277502E-08   1.79785411931805E-08  -2.69292946678552E-19  -4.88803046943750E-01  -4.88803046937285E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.46433636763458E-09   0.00000000000000E+00  -6.46433636763458E-09
      1.33413281543248E-18  -6.97868070502710E-03  -3.35091910830948E-03   0.00000000000000E+00   2.06261939744992E-12
      3.54984210762294E-23  -1.15162674449434E-08  -1.15142048255459E-08  -1.06483986875392E-18
      6.05403427630782E-09
      0.00000000000000E+00  -1.79788828425850E-11   0.00000000000000E+00   8.08512532859726E-13   2.76703691263002E-23
      1.79780714150210E-08   1.79788799275539E-08  -2.69261962457049E-19  -4.88816394333558E-01  -4.88816394327093E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.46468132080864E-09   0.00000000000000E+00  -6.46468132080864E-09
      1.33400655212543E-18  -6.97847347019052E-03  -3.35071383109891E-03   0.00000000000000E+00   2.07868556186623E-12
      3.54767314353449E-23  -1.15162772923658E-08  -1.15141986068039E-08  -1.06474458966838E-18
      6.05406064349532E-09
      0.00000000000000E+00  -1.79795257557454E-11   0.00000000000000E+00   9.28304648380148E-13   2.76517870243838E-23
      1.79785561606248E-08   1.79794844652732E-08  -2.69220355059981E-19  -4.88834361013742E-01  -4.88834361007277E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.46538027495236E-09   0.00000000000000E+00  -6.46538027495236E-09
      1.33383607823146E-18  -6.97817431291878E-03  -3.35044442606554E-03   0.00000000000000E+00   2.14544065015007E-12
      3.54473052515386E-23  -1.15162496309666E-08  -1.15141041903165E-08  -1.06461572317148E-18
      6.05409623919845E-09
      0.00000000000000E+00  -1.79805360478547E-11   0.00000000000000E+00   1.17559669989674E-12   2.76266883298478E-23
      1.79793893732677E-08   1.79805649699677E-08  -2.69164417484010E-19  -4.88858563142211E-01  -4.88858563135744E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.46679567627900E-09   0.00000000000000E+00  -6.46679567627900E-09
      1.33360588809240E-18  -6.97771992038697E-03  -3.35009557564316E-03   0.00000000000000E+00   2.31146507961980E-12
      3.54072478702803E-23  -1.15160807587904E-08  -1.15137692937107E-08  -1.06444147060839E-18
      6.05414429339767E-09
      0.00000000000000E+00  -1.79823729425989E-11   0.00000000000000E+00   1.51470664529099E-12   2.75927948152473E-23
      1.79808448056109E-08   1.79823595122562E-08  -2.69089115648390E-19  -4.88891195647235E-01  -4.88891195640766E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.46941837661822E-09   0.00000000000000E+00  -6.46941837661822E-09
      1.33329500537290E-18  -6.97700891360750E-03  -3.34964556399263E-03   0.00000000000000E+00   2.60545710086770E-12
      3.53523745219569E-23  -1.15155465926684E-08  -1.15129411355674E-08  -1.06420588972450E-18
      6.05420916656661E-09
      0.00000000000000E+00  -1.79851282847151E-11   0.00000000000000E+00   1.84286603131051E-12   2.75469566280236E-23
      1.79832409463629E-08   1.79850838123942E-08  -2.68987610723575E-19  -4.88935235597710E-01  -4.88935235591236E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.47379599259912E-09   0.00000000000000E+00  -6.47379599259912E-09
      1.33287502971175E-18  -6.97589862943255E-03  -3.34905630392423E-03   0.00000000000000E+00   2.99727535027804E-12
      3.52765869582336E-23  -1.15142850951772E-08  -1.15112878198269E-08  -1.06388741898818E-18
      6.05429674534469E-09
      0.00000000000000E+00  -1.79888939189406E-11   0.00000000000000E+00   2.04308611411845E-12   2.74846951967420E-23
      1.79868303136997E-08   1.79888733998138E-08  -2.68850623768052E-19  -4.88994710995571E-01  -4.88994710989091E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.48041912502630E-09   0.00000000000000E+00  -6.48041912502630E-09
      1.33230748252336E-18  -6.97420868280364E-03  -3.34825925908472E-03   0.00000000000000E+00   3.39637402669696E-12
      3.51712215877798E-23  -1.15118506488407E-08  -1.15084542748140E-08  -1.06345685875531E-18
      6.05441497669509E-09
      0.00000000000000E+00  -1.79937616900126E-11   0.00000000000000E+00   2.04408607762067E-12   2.73995166011634E-23
      1.79916772253597E-08   1.79937213114373E-08  -2.68665590264455E-19  -4.89075061031029E-01  -4.89075061024540E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.48958534722222E-09   0.00000000000000E+00  -6.48958534722222E-09
      1.33154021008420E-18  -6.97172954883055E-03  -3.34714080970848E-03   0.00000000000000E+00   3.69642708201848E-12
      3.50246096509965E-23  -1.15078323912946E-08  -1.15041359642126E-08  -1.06287461981975E-18
      6.05457458901813E-09
      0.00000000000000E+00  -1.79994560637195E-11   0.00000000000000E+00   1.84535293753649E-12   2.72820881378287E-23
      1.79975768716480E-08   1.79994222245856E-08  -2.68415521779427E-19  -4.89183626259226E-01  -4.89183626252725E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.50125167918066E-09   0.00000000000000E+00  -6.50125167918066E-09
      1.33050253020100E-18  -6.96824071502806E-03  -3.34553155128078E-03   0.00000000000000E+00   3.82436373961202E-12
      3.48219222420647E-23  -1.15019949091427E-08  -1.14981705454030E-08  -1.06208700842157E-18
      6.05479006565424E-09
      0.00000000000000E+00  -1.80055178163752E-11   0.00000000000000E+00   1.50841037640624E-12   2.71195518124749E-23
      1.80040700155196E-08   1.80055784258960E-08  -2.68077458913972E-19  -4.89330320865369E-01  -4.89330320858854E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.51491879664556E-09   0.00000000000000E+00  -6.51491879664556E-09
      1.32909871741417E-18  -6.96355006266817E-03  -3.34320733155435E-03   0.00000000000000E+00   3.75778035949687E-12
      3.45449765082282E-23  -1.14944174096061E-08  -1.14906596292465E-08  -1.06102125850020E-18
      6.05508095911299E-09
      0.00000000000000E+00  -1.80117632585053E-11   0.00000000000000E+00   1.13507726360384E-12   2.68952238211389E-23
      1.80106359104618E-08   1.80117709877254E-08  -2.67620368408977E-19  -4.89528555144891E-01  -4.89528555138362E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.52967405321463E-09   0.00000000000000E+00  -6.52967405321463E-09
      1.32719927794434E-18  -6.95755804370993E-03  -3.33991305035771E-03   0.00000000000000E+00   3.51848635638802E-12
      3.41714494307340E-23  -1.14856154208686E-08  -1.14820969345121E-08  -1.05957890953536E-18
      6.05547366528230E-09
      0.00000000000000E+00  -1.80179168558982E-11   0.00000000000000E+00   8.35340328751058E-13   2.65885959412235E-23
      1.80171161812705E-08   1.80179515215993E-08  -2.67002297959369E-19  -4.89796493724713E-01  -4.89796493718169E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.54452247713695E-09   0.00000000000000E+00  -6.54452247713695E-09
      1.32462920359239E-18  -6.95032435599573E-03  -3.33541018591107E-03   0.00000000000000E+00   3.16099053512938E-12
      3.36732042229656E-23  -1.14765900349909E-08  -1.14734290444557E-08  -1.05762690563302E-18
      6.05600381861087E-09
      0.00000000000000E+00  -1.80248970559260E-11   0.00000000000000E+00   6.82583205540210E-13   2.61752197063966E-23
      1.80242252048390E-08   1.80249077880445E-08  -2.66166542001655E-19  -4.90158752620446E-01  -4.90158752613887E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.55892320922596E-09   0.00000000000000E+00  -6.55892320922596E-09
      1.32115196862120E-18  -6.94208789870771E-03  -3.32951905435035E-03   0.00000000000000E+00   2.75709067066599E-12
      3.30140264701554E-23  -1.14687416694896E-08  -1.14659845788189E-08  -1.05498542661955E-18
      6.05671952560443E-09
      0.00000000000000E+00  -1.80344489085955E-11   0.00000000000000E+00   6.78852329751274E-13   2.56260872747322E-23
      1.80337693033822E-08   1.80344481557119E-08  -2.65036487266567E-19  -4.90648664551569E-01  -4.90648664544996E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.57317094039546E-09   0.00000000000000E+00  -6.57317094039546E-09
      1.31644750420926E-18  -6.93318554344748E-03  -3.32209964288474E-03   0.00000000000000E+00   2.37533515276880E-12
      3.21475378792717E-23  -1.14636525504722E-08  -1.14612772153194E-08  -1.05141101694269E-18
      6.05768573004575E-09
      0.00000000000000E+00  -1.80490522218115E-11   0.00000000000000E+00   7.61165804289829E-13   2.49065448164247E-23
      1.80482655936595E-08   1.80490267594638E-08  -2.63508700128946E-19  -4.91311296129635E-01  -4.91311296123047E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.58828845461461E-09   0.00000000000000E+00  -6.58828845461461E-09
      1.31008187064375E-18  -6.92384781115814E-03  -3.31293151148296E-03   0.00000000000000E+00   2.06428080298058E-12
      3.10161215559881E-23  -1.14628025856516E-08  -1.14607383048486E-08  -1.04657317051481E-18
      6.05899010604152E-09
      0.00000000000000E+00  -1.80709112692669E-11   0.00000000000000E+00   8.46696308672838E-13   2.39754274861925E-23
      1.80700960897577E-08   1.80709427860664E-08  -2.61443691829596E-19  -4.92207487712132E-01  -4.92207487705526E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.60549901214669E-09   0.00000000000000E+00  -6.60549901214669E-09
      1.30146581629221E-18  -6.91391886312191E-03  -3.30151983295398E-03   0.00000000000000E+00   1.84620548581440E-12
      2.95515752096237E-23  -1.14672899794074E-08  -1.14654437739215E-08  -1.04002212446261E-18
      6.06075101363581E-09
      0.00000000000000E+00  -1.81015874114942E-11   0.00000000000000E+00   8.79339986364593E-13   2.27858568098130E-23
      1.81007329978478E-08   1.81016123378341E-08  -2.58653675499654E-19  -4.93419279743910E-01  -4.93419279737285E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.62567392001565E-09   0.00000000000000E+00  -6.62567392001565E-09
      1.28979861676914E-18  -6.90262276164626E-03  -3.28691701171640E-03   0.00000000000000E+00   1.71879829015796E-12
      2.76785353220277E-23  -1.14776572161087E-08  -1.14759384178185E-08  -1.03114494126948E-18
      6.06312823888811E-09
      0.00000000000000E+00  -1.81413561827051E-11   0.00000000000000E+00   8.47217936793784E-13   2.12897988290222E-23
      1.81405495477216E-08   1.81413967656585E-08  -2.54886567004562E-19  -4.95057155606070E-01  -4.95057155599421E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.64905239429235E-09   0.00000000000000E+00  -6.64905239429235E-09
      1.27399232151358E-18  -6.88853147262887E-03  -3.26765651206179E-03   0.00000000000000E+00   1.66041107718426E-12
      2.53228899088836E-23  -1.14940047824432E-08  -1.14923443713660E-08  -1.01910575450902E-18
      6.06633749297871E-09
      0.00000000000000E+00  -1.81903094276367E-11   0.00000000000000E+00   7.74088409751678E-13   1.94488902676128E-23
      1.81895562229930E-08   1.81903303114028E-08  -2.49805496597057E-19  -4.97269593954738E-01  -4.97269593948063E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.67530193883581E-09   0.00000000000000E+00  -6.67530193883581E-09
      1.25256958146038E-18  -6.86989938631677E-03  -3.24187714706308E-03   0.00000000000000E+00   1.63692751463751E-12
      2.24288853824181E-23  -1.15166653000821E-08  -1.15150283725674E-08  -1.00276408486332E-18
      6.07066998600102E-09
      0.00000000000000E+00  -1.82505595752448E-11   0.00000000000000E+00   7.06375215565836E-13   1.72539152558309E-23
      1.82497904066875E-08   1.82504967819030E-08  -2.42962949821364E-19  -5.00255662231619E-01  -5.00255662224915E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.70406767632234E-09   0.00000000000000E+00  -6.70406767632234E-09
      1.22352425503161E-18  -6.84570218647066E-03  -3.20778621097345E-03   0.00000000000000E+00   1.60639945937378E-12
      1.89888903471135E-23  -1.15480355050402E-08  -1.15464291055808E-08  -9.80561305210249E-19
      6.07651885158114E-09
      0.00000000000000E+00  -1.83317503229363E-11   0.00000000000000E+00   7.05298945590043E-13   1.47533397800831E-23
      1.83310144870996E-08   1.83317197860452E-08  -2.33768118829094E-19  -5.04281956050646E-01  -5.04281956043910E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.73610320410287E-09   0.00000000000000E+00  -6.73610320410287E-09
      1.18412569285700E-18  -6.81819329050352E-03  -3.16477940096651E-03   0.00000000000000E+00   1.51789154473365E-12
      1.50862176200819E-23  -1.15971344734867E-08  -1.15956165819420E-08  -9.50357574027908E-19
      6.08441482011430E-09
      0.00000000000000E+00  -1.84555570286920E-11   0.00000000000000E+00   7.93163894644933E-13   1.20825787611519E-23
      1.84547877587386E-08   1.84555809226332E-08  -2.21454416113960E-19  -5.09701711988830E-01  -5.09701711982060E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.77015154100633E-09   0.00000000000000E+00  -6.77015154100633E-09
      1.13066878932448E-18  -6.79630610521254E-03  -3.11459434369601E-03   0.00000000000000E+00   1.32711588727780E-12
      1.09398214519855E-23  -1.16867564975143E-08  -1.16854293816270E-08  -9.09214373210522E-19
      6.08974459887418E-09
      0.00000000000000E+00  -1.85635664396481E-11   0.00000000000000E+00   1.01737438658194E-12   1.05434548419022E-23
      1.85625854405816E-08   1.85636028149682E-08  -2.13217090980076E-19  -5.13347979555170E-01  -5.13347979548371E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.79865326047159E-09   0.00000000000000E+00  -6.79865326047159E-09
      1.09443347158101E-18  -6.79432549999443E-03  -3.08755892486832E-03   0.00000000000000E+00   1.10910935745732E-12
      8.54593198886615E-24  -1.17660586638539E-08  -1.17649495544965E-08  -8.81216380600929E-19
      6.09693980020003E-09
      0.00000000000000E+00  -1.86744230374576E-11   0.00000000000000E+00   7.80639829551135E-13   8.90751709158358E-24
      1.86736743128193E-08   1.86744549526488E-08  -2.02257281863207E-19  -5.18221839933049E-01  -5.18221839926262E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.78626380673431E-09   0.00000000000000E+00  -6.78626380673431E-09
      1.04560493724127E-18  -6.79734382230536E-03  -3.05174708424246E-03   0.00000000000000E+00   9.50028687094036E-13
      6.04004660362154E-24  -1.18891411746014E-08  -1.18881911459143E-08  -8.43347655378061E-19
      6.10665332198992E-09
      0.00000000000000E+00  -1.86572480715998E-11   0.00000000000000E+00  -6.57481498969195E-14   7.27944481560110E-24
      1.86572975920036E-08   1.86572318438537E-08  -1.88051391635573E-19  -5.24574558490615E-01  -5.24574558483981E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.63338359659204E-09   0.00000000000000E+00  -6.63338359659204E-09
      9.81171421135084E-19  -6.77791934320216E-03  -2.98958059919465E-03   0.00000000000000E+00   1.00928564303408E-12
      3.63586055011054E-24  -1.20248575329048E-08  -1.20238482472617E-08  -7.93120029499511E-19
      6.11976657640626E-09
      0.00000000000000E+00  -1.81937995276506E-11   0.00000000000000E+00  -1.72303368150072E-12   5.74161006122443E-24
      1.81955088974725E-08   1.81937858637910E-08  -1.70912071241799E-19  -5.32284932389296E-01  -5.32284932383227E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.06953831119082E-09   0.00000000000000E+00  -6.06953831119082E-09
      9.01580021070659E-19  -6.68865586926498E-03  -2.86868361293441E-03   0.00000000000000E+00   1.11693707337226E-12
      1.55191239518089E-24  -1.21253644896735E-08  -1.21242475526001E-08  -7.30667949828859E-19
      6.13746946986834E-09
      0.00000000000000E+00  -1.64488413654448E-11   0.00000000000000E+00  -4.84601605567408E-12   4.25288319153937E-24
      1.64536723313135E-08   1.64488263152579E-08  -1.55038883348793E-19  -5.39424701658979E-01  -5.39424701654693E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.28646802719041E-09   0.00000000000000E+00  -4.28646802719041E-09
      8.25697134256731E-19  -6.45533979124706E-03  -2.62335907229846E-03   0.00000000000000E+00   9.10743309517016E-13
     -1.20922548090348E-25  -1.21632690313769E-08  -1.21623582880674E-08  -6.70658250907937E-19
      6.15746946986834E-09
      0.00000000000000E+00  -1.21889906090225E-11   0.00000000000000E+00  -1.04946280741600E-11   2.67913206817881E-24
      1.21995228308082E-08   1.21890282027340E-08  -1.55258061057196E-19  -5.39092168401699E-01  -5.39092168401669E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.01658406687136E-11   0.00000000000000E+00  -3.01658406687136E-11
      8.25093817443357E-19  -6.01266821087976E-03  -2.18178786840447E-03   0.00000000000000E+00   2.92020187677977E-14
     -1.46260426402414E-24  -1.21588915640841E-08  -1.21588623620654E-08  -6.69835756386161E-19
      6.17746946986834E-09
      0.00000000000000E+00  -5.20511679176216E-12   0.00000000000000E+00  -1.72179530353312E-11   6.33729302870322E-25
      5.22227658995580E-09   5.20505863692047E-09  -1.85521417235828E-19  -5.24991054562129E-01  -5.24991054569070E-01
      0.00000000000000E+00   0.00000000000000E+00   6.94093936873159E-09   0.00000000000000E+00   6.94093936873159E-09
      9.63912604817988E-19  -5.35932042186553E-03  -1.53249245724946E-03   0.00000000000000E+00  -1.60803179044923E-12
     -3.11870957004452E-24  -1.21443899738616E-08  -1.21459980056520E-08  -7.78391187582160E-19
      6.19746946986834E-09
      0.00000000000000E+00   2.95850267492885E-12   0.00000000000000E+00  -2.01463757373579E-11  -2.79765228803196E-24
     -2.93835979785373E-09  -2.95850617359109E-09  -2.55829708959987E-19  -4.93653661927504E-01  -4.93653661942586E-01
      0.00000000000000E+00   0.00000000000000E+00   1.50811717557875E-08   0.00000000000000E+00   1.50811717557875E-08
      1.26553603993374E-18  -4.59090569806424E-03  -7.71429679886675E-04   0.00000000000000E+00  -4.03206360126202E-12
     -6.99421279536407E-24  -1.21186335185952E-08  -1.21226655821964E-08  -1.00970633097375E-18
      6.21746946986834E-09
      0.00000000000000E+00   9.53127944844830E-12   0.00000000000000E+00  -1.62779693379501E-11  -1.04368104888419E-23
     -9.51500976379796E-09  -9.53128773313592E-09  -3.72206942154895E-19  -4.44755625191848E-01  -4.44755625213461E-01
      0.00000000000000E+00   0.00000000000000E+00   2.16122815868915E-08   0.00000000000000E+00   2.16122815868915E-08
      1.69778167167157E-18  -3.87872970991092E-03  -7.23881986800528E-05   0.00000000000000E+00  -7.65768787085999E-12
     -1.90801313198337E-23  -1.20733361658847E-08  -1.20809938537555E-08  -1.32557472951667E-18
      6.23746946986834E-09
      0.00000000000000E+00   1.21586818457440E-11   0.00000000000000E+00  -6.65120155644663E-12  -2.61560730741689E-23
     -1.21519975556147E-08  -1.21586487571712E-08  -5.34487844549640E-19  -3.80004688873232E-01  -3.80004688897406E-01
      0.00000000000000E+00   0.00000000000000E+00   2.41744479183964E-08   0.00000000000000E+00   2.41744479183964E-08
      2.18127063003949E-18  -3.41690806082894E-03   3.68892781240913E-04   0.00000000000000E+00  -1.38761596816639E-11
     -4.80211733643328E-23  -1.20019230015434E-08  -1.20157991612252E-08  -1.64678278548985E-18
      6.25746946986834E-09
      0.00000000000000E+00   1.05110791049782E-11   0.00000000000000E+00   3.77592130062183E-12  -3.88322190865746E-23
     -1.05148270970606E-08  -1.05110511757600E-08  -7.20571596455612E-19  -3.04316521358817E-01  -3.04316521381066E-01
      0.00000000000000E+00   0.00000000000000E+00   2.22484427977674E-08   0.00000000000000E+00   2.22484427977674E-08
      2.62623948599484E-18  -4.70168503459966E-03  -1.00360673111860E-03   0.00000000000000E+00  -2.45816159516033E-11
     -7.23157519894399E-23  -1.17128100060558E-08  -1.17373916220075E-08  -1.90566788953923E-18
      6.27746946986834E-09
      0.00000000000000E+00   8.09712387695277E-12   0.00000000000000E+00   5.57013230409269E-12  -4.23379631843457E-23
     -8.10267239562655E-09  -8.09710226332250E-09  -8.86633209389435E-19  -2.29573551226137E-01  -2.29573551244694E-01
      0.00000000000000E+00   0.00000000000000E+00   1.85573969007039E-08   0.00000000000000E+00   1.85573969007039E-08
      2.99738742400892E-18  -1.45338858257185E-02  -1.12381837573232E-02   0.00000000000000E+00  -3.95122470143606E-11
     -8.08390903827559E-23  -1.04207823903669E-08  -1.04602946373814E-08  -2.11075421461949E-18
      6.29746946986834E-09
      0.00000000000000E+00   6.57250123930782E-12   0.00000000000000E+00   3.30401913510624E-12  -4.42337233734474E-23
     -6.57576695079860E-09  -6.57246293166353E-09  -1.01951779270625E-18  -1.63232214346371E-01  -1.63232214361819E-01
      0.00000000000000E+00   0.00000000000000E+00   1.54474909837553E-08   0.00000000000000E+00   1.54474909837553E-08
      3.30633724368403E-18  -3.41448606355466E-02  -3.13486243939841E-02   0.00000000000000E+00  -6.13779286536347E-11
     -8.91181748317909E-23  -8.81365012343800E-09  -8.87502805209172E-09  -2.28681945097778E-18
      6.30746946986834E-09
      0.00000000000000E+00   5.79788272569954E-12   0.00000000000000E+00   3.29046188300240E-12  -4.51166719915621E-23
     -5.80117068727750E-09  -5.79788022539454E-09  -1.07753204936453E-18  -1.32350646160028E-01  -1.32350646173883E-01
      0.00000000000000E+00   0.00000000000000E+00   1.38546415365211E-08   0.00000000000000E+00   1.38546415365211E-08
      3.44488365904924E-18  -4.62425618451823E-02  -4.37041262667285E-02   0.00000000000000E+00  -8.31746801064256E-11
     -9.35244437106364E-23  -7.97358663102024E-09  -8.05676131112676E-09  -2.36735160968471E-18
      6.32096946986834E-09
      0.00000000000000E+00   4.98000534086652E-12   0.00000000000000E+00   2.44719635160726E-12  -4.61799479600479E-23
     -4.98248358114844E-09  -4.98003638479688E-09  -1.14411095828653E-18  -9.52917721599943E-02  -9.52917721722392E-02
      0.00000000000000E+00   0.00000000000000E+00   1.22449325703434E-08   0.00000000000000E+00   1.22449325703434E-08
      3.61019024874887E-18  -6.50839976116949E-02  -6.27950525620701E-02   0.00000000000000E+00  -1.01139270282560E-10
     -9.94397399740579E-23  -7.16375691526390E-09  -7.26489618554656E-09  -2.46607929046234E-18
      6.33919446986834E-09
      0.00000000000000E+00   3.74074430172536E-12   0.00000000000000E+00   2.85920945553664E-12  -4.72482752820932E-23
     -3.74359342283615E-09  -3.74073421338066E-09  -1.21104068802790E-18  -5.61543592022994E-02  -5.61543592122494E-02
      0.00000000000000E+00   0.00000000000000E+00   9.94997067714947E-09   0.00000000000000E+00   9.94997067714947E-09
      3.79152846433992E-18  -9.44880465370129E-02  -9.25317065430741E-02   0.00000000000000E+00  -1.18497337513910E-10
     -1.07138980680415E-22  -6.09073912625474E-09  -6.20923646376876E-09  -2.58048777631203E-18
      6.34419446986834E-09
      0.00000000000000E+00   3.08763637544263E-12   0.00000000000000E+00   5.95453662801626E-12  -4.74682290544603E-23
     -3.09360883141703E-09  -3.08765429478906E-09  -1.22612849584472E-18  -4.70789010997062E-02  -4.70789011084791E-02
      0.00000000000000E+00   0.00000000000000E+00   8.77294672578473E-09   0.00000000000000E+00   8.77294672578473E-09
      3.83539319796885E-18  -1.03138841624875E-01  -1.01347570460131E-01   0.00000000000000E+00  -1.29725283519670E-10
     -1.09243922042268E-22  -5.55556714747620E-09  -5.68529243099598E-09  -2.60926470212413E-18
      6.35094446986834E-09
      0.00000000000000E+00   2.33166234348748E-12   0.00000000000000E+00   5.17361222432839E-12  -4.76844061751054E-23
     -2.33685851307285E-09  -2.33168490084857E-09  -1.24138588947480E-18  -3.77353080782812E-02  -3.77353080857369E-02
      0.00000000000000E+00   0.00000000000000E+00   7.45572194530978E-09   0.00000000000000E+00   7.45572194530978E-09
      3.88571932109969E-18  -1.15625164385560E-01  -1.14010727711091E-01   0.00000000000000E+00  -1.28785438389861E-10
     -1.11917793733980E-22  -4.99525160607131E-09  -5.12403704446129E-09  -2.64433343162489E-18
      6.36005696986834E-09
      0.00000000000000E+00   1.55759489830245E-12   0.00000000000000E+00   3.95695684828137E-12  -4.78657931895535E-23
     -1.56157436043381E-09  -1.55761740358558E-09  -1.25492718905344E-18  -2.92326604226596E-02  -2.92326604287304E-02
      0.00000000000000E+00   0.00000000000000E+00   6.07079790713351E-09   0.00000000000000E+00   6.07079790713351E-09
      3.94103946702844E-18  -1.33395504652635E-01  -1.31973530719504E-01   0.00000000000000E+00  -1.26405443428292E-10
     -1.15257907602308E-22  -4.38677506011937E-09  -4.51318050354777E-09  -2.68611227797500E-18
      6.37235884486834E-09
      0.00000000000000E+00   9.20192422082211E-13   0.00000000000000E+00   2.42655937332423E-12  -4.79962991689254E-23
     -9.22617202865322E-10  -9.20190643492045E-10  -1.26537486930340E-18  -2.24070931406723E-02  -2.24070931455168E-02
      0.00000000000000E+00   0.00000000000000E+00   4.84452411503973E-09   0.00000000000000E+00   4.84452411503973E-09
      4.00063619712615E-18  -1.57865279183007E-01  -1.56628833205538E-01   0.00000000000000E+00  -1.24993142881031E-10
     -1.19418013927316E-22  -3.79934032866650E-09  -3.92433347154765E-09  -2.73526132782275E-18
      6.38896637611834E-09
      0.00000000000000E+00   5.07534017808793E-13   0.00000000000000E+00   1.16494826490816E-12  -4.80790932718723E-23
     -5.08707236654146E-10  -5.07542288389286E-10  -1.27265091703648E-18  -1.73390249142434E-02  -1.73390249181335E-02
      0.00000000000000E+00   0.00000000000000E+00   3.89007590275963E-09   0.00000000000000E+00   3.89007590275963E-09
      4.06524075424610E-18  -1.89863223824709E-01  -1.88797482374136E-01   0.00000000000000E+00  -1.24965434213485E-10
     -1.24595746071828E-22  -3.25756818015682E-09  -3.38253361437043E-09  -2.79258983720963E-18
      6.40896637611834E-09
      0.00000000000000E+00   2.95923743282651E-13   0.00000000000000E+00   4.96307517253036E-13  -4.81228470933923E-23
     -2.96418126473470E-10  -2.95921818956265E-10  -1.27721679740070E-18  -1.38964660421807E-02  -1.38964660453251E-02
      0.00000000000000E+00   0.00000000000000E+00   3.14432667066204E-09   0.00000000000000E+00   3.14432667066204E-09
      4.12812728765934E-18  -2.24674677931746E-01  -2.23777223625323E-01   0.00000000000000E+00  -1.22684022824913E-10
     -1.30202910375395E-22  -2.72572082888069E-09  -2.84840485170574E-09  -2.85091049025864E-18
      6.42896637611834E-09
      0.00000000000000E+00   2.03252403440257E-13   0.00000000000000E+00   2.18140302440085E-13  -4.81423190491571E-23
     -2.03452193527148E-10  -2.03234053224756E-10  -1.27995948334677E-18  -1.17281999084129E-02  -1.17281999109304E-02
      0.00000000000000E+00   0.00000000000000E+00   2.51741545900053E-09   0.00000000000000E+00   2.51741545900053E-09
      4.17847559683935E-18  -2.53909543564587E-01  -2.53180406589381E-01   0.00000000000000E+00  -1.13177138074600E-10
     -1.34981605459043E-22  -2.20100426770104E-09  -2.31418140577578E-09  -2.89851611349258E-18
      6.44896637611834E-09
      0.00000000000000E+00   1.60911979587587E-13   0.00000000000000E+00   1.00504400025710E-13  -4.81509103303628E-23
     -1.61044213347668E-10  -1.60943708947690E-10  -1.28188071694651E-18  -1.02379636789431E-02  -1.02379636809043E-02
      0.00000000000000E+00   0.00000000000000E+00   1.96127355594894E-09   0.00000000000000E+00   1.96127355594894E-09
      4.21770106795833E-18  -2.76789301425333E-01  -2.76222065227113E-01   0.00000000000000E+00  -9.54978593274373E-11
     -1.38775978511222E-22  -1.70483198767373E-09  -1.80032984700131E-09  -2.93582035101182E-18
      6.46896637611834E-09
      0.00000000000000E+00   1.39052932132195E-13   0.00000000000000E+00   5.33644481560194E-14  -4.81537860188077E-23
     -1.39120682059700E-10  -1.39067317611592E-10  -1.28338327780282E-18  -9.16529246847344E-03  -9.16529246995864E-03
      0.00000000000000E+00   0.00000000000000E+00   1.48520780965965E-09   0.00000000000000E+00   1.48520780965965E-09
      4.24740522415152E-18  -2.93595406157657E-01  -2.93171274432664E-01   0.00000000000000E+00  -7.37079034213459E-11
     -1.41581442186521E-22  -1.27243258862665E-09  -1.34614049204814E-09  -2.96402194634871E-18
      6.48896637611834E-09
      0.00000000000000E+00   1.27204961032425E-13   0.00000000000000E+00   3.02487326176435E-14  -4.81537284660269E-23
     -1.27223736947128E-10  -1.27193488214559E-10  -1.28466263344285E-18  -8.36748079243649E-03  -8.36748079352526E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08876695415970E-09   0.00000000000000E+00   1.08876695415970E-09
      4.26918056323472E-18  -3.05017034759186E-01  -3.04714072292721E-01   0.00000000000000E+00  -5.11259922957705E-11
     -1.43476671632510E-22  -9.10447473649204E-10  -9.61573465945118E-10  -2.98451792979186E-18
      6.50896637611834E-09
      0.00000000000000E+00   1.19765537318615E-13   0.00000000000000E+00   2.01149599931420E-14  -4.81518961810359E-23
     -1.19781540528629E-10  -1.19761425568684E-10  -1.28580398542485E-18  -7.76568253960567E-03  -7.76568254037534E-03
      0.00000000000000E+00   0.00000000000000E+00   7.69667438938195E-10   0.00000000000000E+00   7.69667438938195E-10
      4.28457391201348E-18  -3.11967407994994E-01  -3.11762646262158E-01   0.00000000000000E+00  -3.04914906986587E-11
     -1.44596505843609E-22  -6.19414522670640E-10  -6.49906013369443E-10  -2.99876992658863E-18
      6.52896637611834E-09
      0.00000000000000E+00   1.06723584635146E-13   0.00000000000000E+00   3.57921625789014E-14  -4.81456313632198E-23
     -1.06741517054223E-10  -1.06705724891693E-10  -1.28669331620447E-18  -7.36876106759830E-03  -7.36876106819206E-03
      0.00000000000000E+00   0.00000000000000E+00   5.93760821551766E-10   0.00000000000000E+00   5.93760821551766E-10
      4.29644912844452E-18  -3.16704383763233E-01  -3.16550933438504E-01   0.00000000000000E+00  -1.95251476824691E-11
     -1.45310285910903E-22  -4.67529948977495E-10  -4.87055096660109E-10  -3.00975581224004E-18
      6.54896637611834E-09
      0.00000000000000E+00   9.30387187912246E-14   0.00000000000000E+00   3.93330875434347E-14  -4.81350609683226E-23
     -9.30711738695216E-11  -9.30318407820263E-11  -1.28731856309892E-18  -7.12292053767667E-03  -7.12292053824547E-03
      0.00000000000000E+00   0.00000000000000E+00   5.68800685510646E-10   0.00000000000000E+00   5.68800685510646E-10
      4.30782514215473E-18  -3.21486360588648E-01  -3.21336466175108E-01   0.00000000000000E+00  -1.95244101851475E-11
     -1.46008597002269E-22  -4.56244434543324E-10  -4.75768844728617E-10  -3.02050657905581E-18
      6.55896637611834E-09
      0.00000000000000E+00   8.99159977261687E-14   0.00000000000000E+00   2.15387266306834E-14  -4.81295999955995E-23
     -8.99127282095441E-11  -8.98911894829615E-11  -1.28760212293454E-18  -7.01627896540141E-03  -7.01627896595833E-03
      0.00000000000000E+00   0.00000000000000E+00   5.56921837168511E-10   0.00000000000000E+00   5.56921837168511E-10
      4.31339436052642E-18  -3.23831054075099E-01  -3.23683912867652E-01   0.00000000000000E+00  -1.91365711781697E-11
     -1.46347373661250E-22  -4.47894076507358E-10  -4.67030647685674E-10  -3.02579223759187E-18
      6.57246637611834E-09
      0.00000000000000E+00   8.40379345448870E-14   0.00000000000000E+00   2.80503993717585E-14  -4.81210083963919E-23
     -8.40648366211541E-11  -8.40367862218304E-11  -1.28791049246436E-18  -6.89957850277841E-03  -6.89957850337585E-03
      0.00000000000000E+00   0.00000000000000E+00   5.97442852205881E-10   0.00000000000000E+00   5.97442852205881E-10
      4.32145983903119E-18  -3.27532717380630E-01  -3.27370963900717E-01   0.00000000000000E+00  -2.32124737069418E-11
     -1.46892640947278E-22  -4.90193592276870E-10  -5.13406065983959E-10  -3.03354934656683E-18
      6.59069137611834E-09
      0.00000000000000E+00   7.59555976706246E-14   0.00000000000000E+00   2.95931138561762E-14  -4.81073253895230E-23
     -7.59753427274523E-11  -7.59457496136442E-11  -1.28818890012622E-18  -6.77905924477617E-03  -6.77905924546677E-03
      0.00000000000000E+00   0.00000000000000E+00   6.90601584228326E-10   0.00000000000000E+00   6.90601584228326E-10
      4.33404605290375E-18  -3.34019601760401E-01  -3.33825946020239E-01   0.00000000000000E+00  -3.17375144283664E-11
     -1.47880287970047E-22  -5.82918320186234E-10  -6.14655834614748E-10  -3.04585715277753E-18
      6.59569137611834E-09
      0.00000000000000E+00   6.74140371103246E-14   0.00000000000000E+00   9.25932313664140E-14  -4.81024471296831E-23
     -6.75055870861866E-11  -6.74129938548683E-11  -1.28822339622877E-18  -6.76534271352601E-03  -6.76534271425996E-03
      0.00000000000000E+00   0.00000000000000E+00   7.33955668894419E-10   0.00000000000000E+00   7.33955668894419E-10
      4.33771583124823E-18  -3.36030684019663E-01  -3.35820679232488E-01   0.00000000000000E+00  -3.65744024115598E-11
     -1.48188565506605E-22  -6.29968272627888E-10  -6.66542675039596E-10  -3.04949243501946E-18
      6.60244137611834E-09
      0.00000000000000E+00   5.53823765361386E-14   0.00000000000000E+00   9.86106017160128E-14  -4.80944901963871E-23
     -5.55173081275320E-11  -5.54186975258641E-11  -1.28819065238958E-18  -6.77470522799170E-03  -6.77470522884651E-03
      0.00000000000000E+00   0.00000000000000E+00   8.54807003639509E-10   0.00000000000000E+00   8.54807003639509E-10
      4.34348577852279E-18  -3.39492708229506E-01  -3.39240845518063E-01   0.00000000000000E+00  -4.80913317756833E-11
     -1.48730345951589E-22  -7.51296974337688E-10  -7.99388306113520E-10  -3.05529512613321E-18
      6.61155387611834E-09
      0.00000000000000E+00   5.06982949385548E-14   0.00000000000000E+00   3.74615305312887E-14  -4.80838712933893E-23
     -5.07478989777069E-11  -5.07104374472236E-11  -1.28810696895015E-18  -6.77820374084761E-03  -6.77820374186064E-03
      0.00000000000000E+00   0.00000000000000E+00   1.01303124756768E-09   0.00000000000000E+00   1.01303124756768E-09
      4.35271702576625E-18  -3.45315879313041E-01  -3.45012678953783E-01   0.00000000000000E+00  -6.20673444503524E-11
     -1.49666521843866E-22  -9.00253465669954E-10  -9.62320810120456E-10  -3.06461005681610E-18
      6.62385575111834E-09
      0.00000000000000E+00   5.26270344199128E-14   0.00000000000000E+00   3.33136748867756E-15  -4.80707726664949E-23
     -5.26545426117307E-11  -5.26512112442901E-11  -1.28802464712732E-18  -6.72742138156093E-03  -6.72742138271113E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15019967238040E-09   0.00000000000000E+00   1.15019967238040E-09
      4.36686663836092E-18  -3.54418676482625E-01  -3.54072867956402E-01   0.00000000000000E+00  -7.45745287800635E-11
     -1.51166231761235E-22  -1.02297393235586E-09  -1.09754846113607E-09  -3.07884199123360E-18
      6.64046328236834E-09
      0.00000000000000E+00   5.99746133965150E-14   0.00000000000000E+00  -1.23881449328761E-14  -4.80560555804430E-23
     -5.99427386624436E-11  -5.99551268074246E-11  -1.28804734961844E-18  -6.55366859005533E-03  -6.55366859127349E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21816436000894E-09   0.00000000000000E+00   1.21816436000894E-09
      4.38709734103740E-18  -3.67414328013608E-01  -3.67049406244817E-01   0.00000000000000E+00  -8.21955061412391E-11
     -1.53356757391755E-22  -1.07601372706008E-09  -1.15820923320148E-09  -3.09904999141895E-18
      6.66046328236834E-09
      0.00000000000000E+00   7.27410318683612E-14   0.00000000000000E+00  -2.49392836958585E-14  -4.80437689129001E-23
     -7.27116384389710E-11  -7.27365777227149E-11  -1.28834766533862E-18  -6.17944277082076E-03  -6.17944277204358E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22282504282676E-09   0.00000000000000E+00   1.22282504282676E-09
      4.41155384189394E-18  -3.82846115319652E-01  -3.82483752193443E-01   0.00000000000000E+00  -8.51283271973993E-11
     -1.56025062085042E-22  -1.06496013790646E-09  -1.15008846510402E-09  -3.12320617655532E-18
      6.68046328236834E-09
      0.00000000000000E+00   9.08344450982440E-14   0.00000000000000E+00  -4.15999166074420E-14  -4.80387662202383E-23
     -9.07898598134226E-11  -9.08314597300781E-11  -1.28902576355185E-18  -5.59026876335198E-03  -5.59026876455851E-03
      0.00000000000000E+00   0.00000000000000E+00   1.20652156969682E-09   0.00000000000000E+00   1.20652156969682E-09
      4.43568427328788E-18  -3.97614733923472E-01  -3.97263208898024E-01   0.00000000000000E+00  -8.60469626108334E-11
     -1.58656887792675E-22  -1.02964314735577E-09  -1.11569010996677E-09  -3.14665850973603E-18
      6.70046328236834E-09
      0.00000000000000E+00   1.04611155679373E-13   0.00000000000000E+00  -3.39032477732082E-14  -4.80388365699760E-23
     -1.04627096326839E-10  -1.04660999574660E-10  -1.28999497499862E-18  -4.84135757247135E-03  -4.84135757365169E-03
      0.00000000000000E+00   0.00000000000000E+00   1.18033294195985E-09   0.00000000000000E+00   1.18033294195985E-09
      4.45929093212707E-18  -4.11676761085947E-01  -4.11337844943295E-01   0.00000000000000E+00  -8.61236237257174E-11
     -1.61231697069328E-22  -9.89548318659381E-10  -1.07567194238526E-09  -3.16929595712845E-18
      6.72046328236834E-09
      0.00000000000000E+00   1.05162224102618E-13   0.00000000000000E+00  -1.55522513980084E-15  -4.80386770814388E-23
     -1.05191534525840E-10  -1.05193089751027E-10  -1.29098862304183E-18  -4.09276629784919E-03  -4.09276629898641E-03
      0.00000000000000E+00   0.00000000000000E+00   1.13722637651569E-09   0.00000000000000E+00   1.13722637651569E-09
      4.48203545965739E-18  -4.25114674914917E-01  -4.24789508513835E-01   0.00000000000000E+00  -8.54062359539716E-11
     -1.63731739311783E-22  -9.46627050810484E-10  -1.03203328676462E-09  -3.19104683661556E-18
      6.74046328236834E-09
      0.00000000000000E+00   9.12936687842816E-14   0.00000000000000E+00   3.62508711706509E-14  -4.80331454523338E-23
     -9.13104984096174E-11  -9.12742475384948E-11  -1.29171771916309E-18  -3.51652542942912E-03  -3.51652543050544E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07632146315289E-09   0.00000000000000E+00   1.07632146315289E-09
      4.50356188892044E-18  -4.38025741859358E-01  -4.37715380036391E-01   0.00000000000000E+00  -8.38414557560423E-11
     -1.66138422806009E-22  -9.01205759858144E-10  -9.85047215614352E-10  -3.21184416975735E-18
      6.76046328236834E-09
      0.00000000000000E+00   2.10324448205236E-14   0.00000000000000E+00   1.86803414826763E-13  -4.79999165156873E-23
     -2.12334830814112E-11  -2.10466796666325E-11  -1.29105904732356E-18  -3.78786123112819E-03  -3.78786123205779E-03
      0.00000000000000E+00   0.00000000000000E+00   9.29594920854833E-10   0.00000000000000E+00   9.29594920854833E-10
      4.52215378733754E-18  -4.50552424724054E-01  -4.50266166967859E-01   0.00000000000000E+00  -7.81841301804864E-11
     -1.68342159547379E-22  -8.30364111007642E-10  -9.08548241188296E-10  -3.23109474001398E-18
      6.78046328236834E-09
      0.00000000000000E+00  -4.88614001944042E-13   0.00000000000000E+00   1.35414556757762E-12  -4.77612801222304E-23
      4.87271533689978E-10   4.88625679257508E-10  -1.28025427350094E-18  -1.01578055891488E-02  -1.01578055892312E-02
      0.00000000000000E+00   0.00000000000000E+00   8.24453443159258E-11   0.00000000000000E+00   8.24453443159258E-11
      4.52380269422386E-18  -4.63342296177991E-01  -4.63162376178762E-01   0.00000000000000E+00  -3.91938861787084E-11
     -1.69420579994363E-22  -5.31877137394500E-10  -5.71071023573378E-10  -3.24354842072292E-18
      6.80046328236834E-09
      0.00000000000000E+00  -1.39420311081026E-12   0.00000000000000E+00   2.46810130342700E-12  -4.71868503875339E-23
      1.39170995697112E-09   1.39417805827450E-09  -1.25149242423568E-18  -2.70394665133369E-02  -2.70394665119512E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.38576058146915E-09   0.00000000000000E+00  -1.38576058146915E-09
      4.49608748259447E-18  -4.76832345966012E-01  -4.76829717084544E-01   0.00000000000000E+00   2.93565167779072E-11
     -1.68564358681603E-22  -3.77739935830348E-11  -8.41747680529624E-12  -3.24459505835880E-18
      6.81046328236834E-09
      0.00000000000000E+00  -1.87730642852185E-12   0.00000000000000E+00   2.67258673413464E-12  -4.68173898860766E-23
      1.87459693455947E-09   1.87726952129356E-09  -1.23235966002846E-18  -3.80893492510504E-02  -3.80893492488953E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.15512511987275E-09   0.00000000000000E+00  -2.15512511987275E-09
      4.47453623139575E-18  -4.83682201203163E-01  -4.83769776533441E-01   0.00000000000000E+00   6.35037075486399E-11
     -1.67651154606492E-22   2.14351891030642E-10   2.77855598579114E-10  -3.24217657136729E-18
      6.82396328236834E-09
      0.00000000000000E+00  -2.30254756179270E-12   0.00000000000000E+00   1.88049561325309E-12  -4.62443963629968E-23
      2.30062833990892E-09   2.30250883552213E-09  -1.20106178845689E-18  -5.58132931517267E-02  -5.58132931489193E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.80735745809272E-09   0.00000000000000E+00  -2.80735745809272E-09
      4.43663690571150E-18  -4.92983377555163E-01  -4.93142478815761E-01   0.00000000000000E+00   8.95806365021454E-11
     -1.65905086776588E-22   4.15267986068552E-10   5.04848622570532E-10  -3.23557511725460E-18
      6.84218828236834E-09
      0.00000000000000E+00  -2.82762392440813E-12   0.00000000000000E+00   1.76055554348475E-12  -4.53497809486707E-23
      2.82588187749472E-09   2.82764243303816E-09  -1.15042522663382E-18  -8.36192442199458E-02  -8.36192442164109E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.53490985484819E-09   0.00000000000000E+00  -3.53490985484819E-09
      4.37221317360689E-18  -5.05436819572629E-01  -5.05659707488134E-01   0.00000000000000E+00   1.14344949028473E-10
     -1.62870710054505E-22   5.92922472781808E-10   7.07267421810117E-10  -3.22178794697308E-18
      6.84718828236834E-09
      0.00000000000000E+00  -3.13172184930225E-12   0.00000000000000E+00   3.31883523521793E-12  -4.50757368673813E-23
      3.12840876294198E-09   3.13172759817715E-09  -1.13517538048017E-18  -9.18094981364884E-02  -9.18094981325443E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.94409945634620E-09   0.00000000000000E+00  -3.94409945634620E-09
      4.35249267632516E-18  -5.08843616270866E-01  -5.09099623464639E-01   0.00000000000000E+00   1.25226866239038E-10
     -1.61953167764597E-22   6.87144991929518E-10   8.12371858168393E-10  -3.21731729584499E-18
      6.85393828236834E-09
      0.00000000000000E+00  -3.46860834537946E-12   0.00000000000000E+00   2.80838158049437E-12  -4.46821804977519E-23
      3.46578065816375E-09   3.46858903974420E-09  -1.11274126294332E-18  -1.03689369422193E-01  -1.03689369417822E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.37124557490448E-09   0.00000000000000E+00  -4.37124557490448E-09
      4.32298676869455E-18  -5.13443898104658E-01  -5.13728358826190E-01   0.00000000000000E+00   1.37720049286862E-10
     -1.60583158408581E-22   7.64936485873967E-10   9.02656535160668E-10  -3.21024550575123E-18
      6.86305078236834E-09
      0.00000000000000E+00  -3.92305610508230E-12   0.00000000000000E+00   2.80394217436315E-12  -4.40812058428634E-23
      3.92022809757845E-09   3.92303203975277E-09  -1.07960384323573E-18  -1.20892912108200E-01  -1.20892912103337E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.86273269331370E-09   0.00000000000000E+00  -4.86273269331370E-09
      4.27867511702673E-18  -5.19568484390342E-01  -5.19864630055937E-01   0.00000000000000E+00   1.49988218237627E-10
     -1.58551294302178E-22   7.89712435323521E-10   9.39700653560990E-10  -3.19907127379100E-18
      6.87535265736834E-09
      0.00000000000000E+00  -4.57001043397212E-12   0.00000000000000E+00   2.92048728805665E-12  -4.29494292747303E-23
      4.56710425545128E-09   4.57002474273929E-09  -1.03147451244991E-18  -1.45180310485159E-01  -1.45180310479842E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.31724226735342E-09   0.00000000000000E+00  -5.31724226735342E-09
      4.21326306730903E-18  -5.27381501028630E-01  -5.27617030093472E-01   0.00000000000000E+00   1.57140150279571E-10
     -1.55633969524150E-22   5.90077374334550E-10   7.47217524613965E-10  -3.18178855485912E-18
      6.89196018861834E-09
      0.00000000000000E+00  -5.83535537848021E-12   0.00000000000000E+00   4.03830824279602E-12  -3.92469274129973E-23
      5.83136369927567E-09   5.83540200751843E-09  -9.64469108671278E-19  -1.77713636364859E-01  -1.77713636359232E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.62698483503695E-09   0.00000000000000E+00  -5.62698483503695E-09
      4.11981274081788E-18  -5.36030687538114E-01  -5.35965204521877E-01   0.00000000000000E+00   1.56628906979783E-10
     -1.51596449420781E-22  -3.65046079461153E-10  -2.08417172481521E-10  -3.15534363214660E-18
      6.91196018861834E-09
      0.00000000000000E+00  -8.98636462259604E-12   0.00000000000000E+00   7.98241192659059E-12  -2.43966163002027E-23
      8.97840627636736E-09   8.98638868829392E-09  -8.86383236809084E-19  -2.13950903537910E-01  -2.13950903532076E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.83365370721448E-09   0.00000000000000E+00  -5.83365370721448E-09
      4.00313966667359E-18  -5.40440034134005E-01  -5.39447088956976E-01   0.00000000000000E+00   1.55412867803793E-10
     -1.46491719112808E-22  -3.30814784888312E-09  -3.15273498107948E-09  -3.11675642986451E-18
      6.93196018861834E-09
      0.00000000000000E+00  -1.49967760701938E-11   0.00000000000000E+00   1.49695230601353E-11   1.25875562415402E-23
      1.49818287881563E-08   1.49967983112164E-08  -8.16521194555178E-19  -2.45132313843911E-01  -2.45132313837850E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.06122315667248E-09   0.00000000000000E+00  -6.06122315667248E-09
      3.88191520354014E-18  -5.33627524183181E-01  -5.30812909697950E-01   0.00000000000000E+00   1.60991812959801E-10
     -1.40649736896099E-22  -9.09656696750357E-09  -8.93557515454391E-09  -3.06539400898496E-18
      6.95196018861835E-09
      0.00000000000000E+00  -2.33849559193572E-11   0.00000000000000E+00   2.08036708218637E-11   6.58622392504123E-23
      2.33641644789715E-08   2.33849681497935E-08  -7.59541245159621E-19  -2.70078980662322E-01  -2.70078980655985E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.33746387186656E-09   0.00000000000000E+00  -6.33746387186656E-09
      3.75516592610281E-18  -5.10862548558753E-01  -5.05492438029159E-01   0.00000000000000E+00   1.71458266729243E-10
     -1.33474286109364E-22  -1.72189625446561E-08  -1.70475042779269E-08  -2.99562468094319E-18
      6.97196018861835E-09
      0.00000000000000E+00  -3.17402553526003E-11   0.00000000000000E+00   2.07216026754908E-11   1.19100823245048E-22
      3.17194825190236E-08   3.17402041216992E-08  -7.17168472395782E-19  -2.88780365036058E-01  -2.88780365029431E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.62700256760619E-09   0.00000000000000E+00  -6.62700256760619E-09
      3.62262587475068E-18  -4.70346022709673E-01  -4.62434797431341E-01   0.00000000000000E+00   1.76420578234747E-10
     -1.24759726826394E-22  -2.52896221323275E-08  -2.51132015540929E-08  -2.90545740235490E-18
      6.99196018861835E-09
      0.00000000000000E+00  -3.72877693246722E-11   0.00000000000000E+00   1.37846699650152E-11   1.55638004249880E-22
      3.72739624827700E-08   3.72877471527351E-08  -6.88846839336632E-19  -3.01865721821360E-01  -3.01865721814458E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.90246247342366E-09   0.00000000000000E+00  -6.90246247342366E-09
      3.48457662528221E-18  -4.12951966312538E-01  -4.03379568221582E-01   0.00000000000000E+00   1.70375130262370E-10
     -1.15008271308170E-22  -3.05556598095738E-08  -3.03852846793116E-08  -2.79572978594558E-18
      7.01196018861835E-09
      0.00000000000000E+00  -3.83666694526490E-11   0.00000000000000E+00   2.71923946053952E-12   1.65832319226603E-22
      3.83639822673531E-08   3.83667015068138E-08  -6.73097431198691E-19  -3.10105524500833E-01  -3.10105524493673E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.15920367389790E-09   0.00000000000000E+00  -7.15920367389790E-09
      3.34139255180425E-18  -3.41505910421449E-01  -3.31674201524717E-01   0.00000000000000E+00   1.53704452079654E-10
     -1.05129351564206E-22  -3.13612022849955E-08  -3.12074978329159E-08  -2.66829512060556E-18
      7.03196018861835E-09
      0.00000000000000E+00  -3.60082802906341E-11   0.00000000000000E+00  -5.80796963614230E-12   1.54096731640662E-22
      3.60140545379614E-08   3.60082465683255E-08  -6.65645774554669E-19  -3.15229021103912E-01  -3.15229021096583E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32927054432366E-09   0.00000000000000E+00  -7.32927054432366E-09
      3.19480714091778E-18  -2.64687718638285E-01  -2.55652395608703E-01   0.00000000000000E+00   1.22220691567332E-10
     -9.51019236673242E-23  -2.88011967155690E-08  -2.86789760240017E-08  -2.52916136636311E-18
      7.05196018861835E-09
      0.00000000000000E+00  -3.32251092190344E-11   0.00000000000000E+00  -6.87659755479596E-12   1.35627810579207E-22
      3.32319956579979E-08   3.32251190604433E-08  -6.59597829850740E-19  -3.19886749559804E-01  -3.19886749552474E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.33015069237750E-09   0.00000000000000E+00  -7.33015069237750E-09
      3.04820412707023E-18  -1.94110536739741E-01  -1.85952171190616E-01   0.00000000000000E+00   8.26230898648271E-11
     -8.55535591573403E-23  -2.59775914579305E-08  -2.58949683680658E-08  -2.38860629721949E-18
      7.07196018861835E-09
      0.00000000000000E+00  -3.10557365261926E-11   0.00000000000000E+00  -5.36030155965029E-12   1.18053672855045E-22
      3.10611373296215E-08   3.10557770280620E-08  -6.52417864124318E-19  -3.25020867634196E-01  -3.25020867626940E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25508201188634E-09   0.00000000000000E+00  -7.25508201188634E-09
      2.90310248683250E-18  -1.32213716573853E-01  -1.24715072060359E-01   0.00000000000000E+00   5.42102502652133E-11
     -7.96135115705677E-23  -2.38549052664407E-08  -2.38006950161756E-08  -2.25068462270819E-18
      7.07321018861835E-09
      0.00000000000000E+00  -3.07431888854754E-11   0.00000000000000E+00  -1.20948700363623E-11   1.16766584487206E-22
      3.07552613441607E-08   3.07431664741244E-08  -6.52105009241228E-19  -3.25282864137020E-01  -3.25282864129729E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29143564728241E-09   0.00000000000000E+00  -7.29143564728241E-09
      2.89398819227340E-18  -1.28308249830187E-01  -1.20919544138655E-01   0.00000000000000E+00   5.49737711508129E-11
     -7.92681185645309E-23  -2.35067045979935E-08  -2.34517308268427E-08  -2.24188318303217E-18
      7.07489768861835E-09
      0.00000000000000E+00  -3.04659096238459E-11   0.00000000000000E+00  -8.23368136573660E-12   1.14912106867321E-22
      3.04741367983259E-08   3.04659031169603E-08  -6.51690612823860E-19  -3.25643469225311E-01  -3.25643469218012E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29851763643123E-09   0.00000000000000E+00  -7.29851763643123E-09
      2.88167194376193E-18  -1.23148989062954E-01  -1.15849861487505E-01   0.00000000000000E+00   4.80430633972996E-11
     -7.87846030869459E-23  -2.32154285439270E-08  -2.31673854805298E-08  -2.22998133093807E-18
      7.07717581361835E-09
      0.00000000000000E+00  -3.01561173252449E-11   0.00000000000000E+00  -6.75033209829431E-12   1.12462991248749E-22
      3.01628724749554E-08   3.01561221428572E-08  -6.51054228049171E-19  -3.26163178910583E-01  -3.26163178903299E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28443127348692E-09   0.00000000000000E+00  -7.28443127348692E-09
      2.86507709876701E-18  -1.16378732240672E-01  -1.09172757959199E-01   0.00000000000000E+00   4.41774804882426E-11
     -7.80498306542169E-23  -2.29158683498586E-08  -2.28716908693704E-08  -2.21402287071784E-18
      7.08025128236835E-09
      0.00000000000000E+00  -2.97746861316221E-11   0.00000000000000E+00  -6.13385711511227E-12   1.09411331995021E-22
      2.97808884618344E-08   2.97747546047194E-08  -6.50046389344992E-19  -3.26921359914312E-01  -3.26921359907055E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25686089301250E-09   0.00000000000000E+00  -7.25686089301250E-09
      2.84275884986745E-18  -1.07567076684269E-01  -1.00472560028134E-01   0.00000000000000E+00   4.10661836326142E-11
     -7.68328042565388E-23  -2.25589598953397E-08  -2.25178937117072E-08  -2.19271246052246E-18
      7.08440316518085E-09
      0.00000000000000E+00  -2.92895622296919E-11   0.00000000000000E+00  -5.77260290584008E-12   1.05757755558476E-22
      2.92953583680729E-08   2.92895857651671E-08  -6.48430172419653E-19  -3.28039548450162E-01  -3.28039548442945E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.21732403949079E-09   0.00000000000000E+00  -7.21732403949079E-09
      2.81279336623565E-18  -9.62422298403578E-02  -8.92881024113396E-02   0.00000000000000E+00   3.77613622627222E-11
     -7.45491769586741E-23  -2.21100230879388E-08  -2.20722617256762E-08  -2.16436319381600E-18
      7.09000820697772E-09
      0.00000000000000E+00  -2.86360869244604E-11   0.00000000000000E+00  -5.75241061628407E-12   1.01620707825760E-22
      2.86418457056763E-08   2.86360932950601E-08  -6.45751422418460E-19  -3.29728581106170E-01  -3.29728581099010E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.16002027028114E-09   0.00000000000000E+00  -7.16002027028114E-09
      2.77266115335425E-18  -8.20184068056797E-02  -7.52521012596411E-02   0.00000000000000E+00   3.40883934186315E-11
     -6.95633393238815E-23  -2.15101614181977E-08  -2.14760730247791E-08  -2.12690973093579E-18
      7.09757501340350E-09
      0.00000000000000E+00  -2.76527053231794E-11   0.00000000000000E+00  -6.40396341549191E-12   9.76558436297162E-23
      2.76591154591147E-08   2.76527114956993E-08  -6.40916094918305E-19  -3.32436540767053E-01  -3.32436540759990E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.06284527703947E-09   0.00000000000000E+00  -7.06284527703947E-09
      2.71921797032765E-18  -6.50467403521107E-02  -5.85596291611976E-02   0.00000000000000E+00   3.00323168675196E-11
     -5.73396720860589E-23  -2.06198985355270E-08  -2.05898662186596E-08  -2.07830187540935E-18
      7.10268260774091E-09
      0.00000000000000E+00  -2.67712713801987E-11   0.00000000000000E+00  -8.48924950933924E-12   9.58548295489093E-23
      2.67797910548417E-08   2.67713018053324E-08  -6.36833196224913E-19  -3.34539177144434E-01  -3.34539177137457E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.97708356586588E-09   0.00000000000000E+00  -6.97708356586588E-09
      2.68358185781505E-18  -5.49326599718429E-02  -4.86962190149016E-02   0.00000000000000E+00   2.81838412231191E-11
     -4.42773973117288E-23  -1.98224020806895E-08  -1.97942182394664E-08  -2.04674866159014E-18
      7.10957786009640E-09
      0.00000000000000E+00  -2.55406437463551E-11   0.00000000000000E+00  -8.79153112937196E-12   9.57514275018596E-23
      2.55493936666572E-08   2.55406021355279E-08  -6.29421148327536E-19  -3.38032693601944E-01  -3.38032693595119E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.82489642249081E-09   0.00000000000000E+00  -6.82489642249081E-09
      2.63652247468188E-18  -4.38887332236667E-02  -3.79920822560417E-02   0.00000000000000E+00   2.44858103295292E-11
     -2.06921158640989E-23  -1.87401915233666E-08  -1.87157057130371E-08  -2.00710132635434E-18
      7.11888645077631E-09
      0.00000000000000E+00  -2.39897535138688E-11   0.00000000000000E+00  -8.19970985818332E-12   9.97234752877480E-23
      2.39979429055195E-08   2.39897431956614E-08  -6.16147732188270E-19  -3.43864571007540E-01  -3.43864571000927E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.61300379580556E-09   0.00000000000000E+00  -6.61300379580556E-09
      2.57496472918199E-18  -3.33284283642602E-02  -2.78536275346355E-02   0.00000000000000E+00   1.98542737858906E-11
      1.72992662908650E-23  -1.73965936736416E-08  -1.73767393998557E-08  -1.95881699699372E-18
      7.13145304819420E-09
      0.00000000000000E+00  -2.24181063707736E-11   0.00000000000000E+00  -6.14435678553344E-12   1.10039979453367E-22
      2.24242398583521E-08   2.24180955015667E-08  -5.94290269830395E-19  -3.53059840278643E-01  -3.53059840272261E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.38199011080453E-09   0.00000000000000E+00  -6.38199011080453E-09
      2.49476482873458E-18  -2.47148878346983E-02  -1.96624638682716E-02   0.00000000000000E+00   1.44769792574021E-11
      6.63261959335302E-23  -1.60505823700198E-08  -1.60361053907623E-08  -1.90047455890419E-18
      7.14841795470835E-09
      0.00000000000000E+00  -2.11362293735681E-11   0.00000000000000E+00  -3.69583257329774E-12   1.25878716535384E-22
      2.11399247589804E-08   2.11362289264072E-08  -5.62140874848312E-19  -3.66303622320259E-01  -3.66303622314077E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.18136804605659E-09   0.00000000000000E+00  -6.18136804605659E-09
      2.38989849770370E-18  -1.85015766996164E-02  -1.37898067765847E-02   0.00000000000000E+00   9.77150838596081E-12
      1.21150856912826E-22  -1.49646323887367E-08  -1.49548608803506E-08  -1.82775762285539E-18
      7.16841795470835E-09
      0.00000000000000E+00  -2.01949126619282E-11   0.00000000000000E+00  -2.28788992519344E-12   1.39189722018598E-22
      2.01971538136460E-08   2.01948659237210E-08  -5.24397377368959E-19  -3.81762488077943E-01  -3.81762488071912E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.03103152339561E-09   0.00000000000000E+00  -6.03103152339561E-09
      2.26927786723578E-18  -1.45535432538145E-02  -1.00909920859978E-02   0.00000000000000E+00   6.93884313300283E-12
      1.66337363268035E-22  -1.41707732434585E-08  -1.41638344003254E-08  -1.74488048986683E-18
      7.18841795470835E-09
      0.00000000000000E+00  -1.94500518431751E-11   0.00000000000000E+00  -1.80467109161596E-12   1.42695698819041E-22
      1.94518500518125E-08   1.94500453807210E-08  -4.88330429002948E-19  -3.96577443112044E-01  -3.96577443106128E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.91610374389501E-09   0.00000000000000E+00  -5.91610374389501E-09
      2.15095579235788E-18  -1.21559293935391E-02  -7.89183153622042E-03   0.00000000000000E+00   5.54858309458777E-12
      1.89079765874904E-22  -1.35394902199207E-08  -1.35339416368259E-08  -1.66262536335494E-18
      7.20841795470835E-09
      0.00000000000000E+00  -1.87913413879228E-11   0.00000000000000E+00  -1.59542160022396E-12   1.35966767970488E-22
      1.87929051137205E-08   1.87913096921204E-08  -4.54216747082476E-19  -4.10685088327543E-01  -4.10685088321728E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.81465300322665E-09   0.00000000000000E+00  -5.81465300322665E-09
      2.03466273229335E-18  -1.05385829703731E-02  -6.45006348753821E-03   0.00000000000000E+00   4.73270421363392E-12
      1.90406424542243E-22  -1.29813893931076E-08  -1.29766566888938E-08  -1.58044598521088E-18
      7.22841795470835E-09
      0.00000000000000E+00  -1.82160259540548E-11   0.00000000000000E+00  -1.39272908710055E-12   1.21002583155777E-22
      1.82173799483408E-08   1.82159872192539E-08  -4.21858508210781E-19  -4.24162834972762E-01  -4.24162834967039E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.72322276503009E-09   0.00000000000000E+00  -5.72322276503009E-09
      1.92019827699275E-18  -9.38456057593072E-03  -5.44849669295728E-03   0.00000000000000E+00   4.10746812632476E-12
      1.74533442808416E-22  -1.24968719223503E-08  -1.24927644542238E-08  -1.49833976878197E-18
      7.24841795470835E-09
      0.00000000000000E+00  -1.77282385547456E-11   0.00000000000000E+00  -1.17931208009789E-12   1.00910924029559E-22
      1.77293728161378E-08   1.77281935040578E-08  -3.90963020795005E-19  -4.37107919197685E-01  -4.37107919192045E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.64044275762105E-09   0.00000000000000E+00  -5.64044275762105E-09
      1.80738942184033E-18  -8.53273440653168E-03  -4.72427465004466E-03   0.00000000000000E+00   3.58426311511419E-12
      1.47418101125616E-22  -1.20913350095521E-08  -1.20877507464368E-08  -1.41642640104532E-18
      7.26841795470835E-09
      0.00000000000000E+00  -1.73406537637299E-11   0.00000000000000E+00  -9.34009512092310E-13   7.90338898172228E-23
      1.73415855100133E-08   1.73406515005013E-08  -3.61164571288650E-19  -4.49651566887793E-01  -4.49651566882208E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.58596930805737E-09   0.00000000000000E+00  -5.58596930805737E-09
      1.69567003567918E-18  -7.88817596860590E-03  -4.18465318200315E-03   0.00000000000000E+00   3.15951180729771E-12
      1.15334058439374E-22  -1.17578417042513E-08  -1.17546821924439E-08  -1.33450546439053E-18
      7.28841795470835E-09
      0.00000000000000E+00  -1.73123655846700E-11   0.00000000000000E+00  -4.96774789078031E-14   5.84412963329092E-23
      1.73124615429755E-08   1.73124118654967E-08  -3.31032959906150E-19  -4.62396343842349E-01  -4.62396343836579E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.76915247053739E-09   0.00000000000000E+00  -5.76915247053739E-09
      1.58028698626843E-18  -7.44218122966187E-03  -3.80526903315055E-03   0.00000000000000E+00   2.74285839454992E-12
      8.38164180789818E-23  -1.15460022533539E-08  -1.15432593949593E-08  -1.24925402636228E-18
      7.30841795470835E-09
      0.00000000000000E+00  -1.76948070704021E-11   0.00000000000000E+00   9.63452941717155E-13   4.08999535734880E-23
      1.76938644205933E-08   1.76948278735350E-08  -2.99428481653331E-19  -4.75855630754201E-01  -4.75855630748002E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.19925997344480E-09   0.00000000000000E+00  -6.19925997344480E-09
      1.45630178679954E-18  -7.17404874704011E-03  -3.55216073871366E-03   0.00000000000000E+00   2.31215747368620E-12
      5.63119169794805E-23  -1.14978800575640E-08  -1.14955679000902E-08  -1.15687330514621E-18
      7.32841795470835E-09
      0.00000000000000E+00  -1.79929350873777E-11   0.00000000000000E+00   7.57686218194485E-13   2.70454254678059E-23
      1.79922066783254E-08   1.79929643645436E-08  -2.67507184888541E-19  -4.89574393142841E-01  -4.89574393136365E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.47687927048281E-09   0.00000000000000E+00  -6.47687927048281E-09
      1.32676420138988E-18  -6.96827281114850E-03  -3.33991870483805E-03   0.00000000000000E+00   2.05205860363833E-12
      3.44962249491906E-23  -1.15181371526645E-08  -1.15160850940608E-08  -1.05925701650134E-18
}
